/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTAmbiguityResolver;
import org.eclipse.cdt.internal.core.dom.parser.c.CScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CStructMapper;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTTranslationUnit
extends ASTTranslationUnit
implements IASTAmbiguityParent {
    private CScope compilationUnit = null;
    private final CStructMapper fStructMapper = new CStructMapper(this);

    @Override
    public CASTTranslationUnit copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTTranslationUnit copy(IASTNode.CopyStyle style) {
        CASTTranslationUnit copy = new CASTTranslationUnit();
        this.copyAbstractTU(copy, style);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public IScope getScope() {
        if (this.compilationUnit == null) {
            this.compilationUnit = new CScope(this, EScopeKind.eGlobal);
        }
        return this.compilationUnit;
    }

    @Override
    public IASTName[] getDeclarationsInAST(IBinding binding) {
        if (binding instanceof IMacroBinding) {
            return this.getMacroDefinitionsInAST((IMacroBinding)binding);
        }
        return CVisitor.getDeclarations(this, binding);
    }

    @Override
    public IASTName[] getDefinitionsInAST(IBinding binding) {
        if (binding instanceof IMacroBinding) {
            return this.getMacroDefinitionsInAST((IMacroBinding)binding);
        }
        IASTName[] names = CVisitor.getDeclarations(this, binding);
        int i = 0;
        while (i < names.length) {
            if (!names[i].isDefinition()) {
                names[i] = null;
            }
            ++i;
        }
        return ArrayUtil.removeNulls(IASTName.class, names);
    }

    @Override
    public IASTName[] getReferences(IBinding binding) {
        if (binding instanceof IMacroBinding) {
            return this.getMacroReferencesInAST((IMacroBinding)binding);
        }
        return CVisitor.getReferences(this, binding);
    }

    @Override
    @Deprecated
    public ParserLanguage getParserLanguage() {
        return ParserLanguage.C;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.C_LINKAGE;
    }

    @Override
    public void resolveAmbiguities() {
        this.accept(new CASTAmbiguityResolver());
    }

    public ICompositeType mapToASTType(ICompositeType type) {
        return this.fStructMapper.mapToAST(type);
    }

    @Override
    protected IType createType(IASTTypeId typeid) {
        return CVisitor.createType(typeid.getAbstractDeclarator());
    }
}

