/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationDataProvider;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.util.CDataSerializer;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class CDefaultConfigurationDataProvider
extends CConfigurationDataProvider {
    private static final String DEFAULT_STORAGE_ID = "defaultConfigurationDataProvider";

    @Override
    public CConfigurationData applyConfiguration(ICConfigurationDescription des, ICConfigurationDescription baseDescription, CConfigurationData base, IProgressMonitor monitor) throws CoreException {
        ICStorageElement el = this.getStorageElement(des, true);
        CDataSerializer serializer = this.getDataSerializer();
        serializer.store(base, el);
        return base;
    }

    @Override
    public CConfigurationData createConfiguration(ICConfigurationDescription des, ICConfigurationDescription baseDescription, CConfigurationData base, boolean clone, IProgressMonitor monitor) throws CoreException {
        CDataFactory factory = this.getDataFactory();
        return factory.createConfigurationdata(des.getId(), des.getName(), base, clone);
    }

    @Override
    public CConfigurationData loadConfiguration(ICConfigurationDescription des, IProgressMonitor monitor) throws CoreException {
        ICStorageElement el = this.getStorageElement(des, false);
        if (el != null) {
            CDataSerializer serializer = this.getDataSerializer();
            CDataFactory factory = this.getDataFactory();
            try {
                return serializer.loadConfigurationData(factory, el);
            }
            catch (CoreException e) {
                if (des.isPreferenceConfiguration()) {
                    return this.createPreferenceConfig(factory);
                }
                throw e;
            }
        }
        if (des.isPreferenceConfiguration()) {
            return this.createPreferenceConfig(this.getDataFactory());
        }
        return null;
    }

    @Override
    public void removeConfiguration(ICConfigurationDescription des, CConfigurationData data, IProgressMonitor monitor) {
    }

    protected CDataFactory getDataFactory() {
        return CDataFactory.getDefault();
    }

    protected CDataSerializer getDataSerializer() {
        return CDataSerializer.getDefault();
    }

    protected String getStorageId() {
        return DEFAULT_STORAGE_ID;
    }

    protected ICStorageElement getStorageElement(ICConfigurationDescription des, boolean create) throws CoreException {
        return des.getStorage(this.getStorageId(), create);
    }

    protected CConfigurationData createPreferenceConfig(CDataFactory factory) {
        return CDataUtil.createEmptyData(null, "preference", factory, true);
    }
}

