/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.rse.ui;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.ptp.internal.remote.rse.core.RSEConnectionManager;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.ui.AbstractRemoteUIConnectionManager;
import org.eclipse.rse.ui.actions.SystemNewConnectionAction;
import org.eclipse.swt.widgets.Shell;

public class RSEUIConnectionManager
extends AbstractRemoteUIConnectionManager {
    private SystemNewConnectionAction action;
    private final RSEConnectionManager manager;

    public RSEUIConnectionManager(IRemoteServices services) {
        this.manager = (RSEConnectionManager)services.getConnectionManager();
    }

    public IRemoteConnection newConnection(Shell shell) {
        IRemoteConnection[] oldConns = this.manager.getConnections();
        if (this.action == null) {
            this.action = new SystemNewConnectionAction(shell, false, false, null);
        }
        try {
            this.action.run();
        }
        catch (Exception exception) {}
        this.manager.refreshConnections();
        IRemoteConnection[] newConns = this.manager.getConnections();
        if (newConns.length <= oldConns.length) {
            return null;
        }
        Arrays.sort(oldConns, new Comparator<IRemoteConnection>(){

            @Override
            public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        Arrays.sort(newConns, new Comparator<IRemoteConnection>(){

            @Override
            public int compare(IRemoteConnection c1, IRemoteConnection c2) {
                return c1.getName().compareToIgnoreCase(c2.getName());
            }
        });
        int i = 0;
        while (i < oldConns.length) {
            if (!oldConns[i].equals(newConns[i])) {
                return newConns[i];
            }
            ++i;
        }
        return newConns[newConns.length - 1];
    }

    public IRemoteConnection newConnection(Shell shell, String[] attrHints, String[] attrHintValues) {
        return this.newConnection(shell);
    }

    public void updateConnection(Shell shell, IRemoteConnection connection) {
    }
}

