/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.util;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.util.IOSGIServiceAccess;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class CoreUtil {
    public static final IStatus OK_STATUS = new Status(0, "com.nvidia.common", "");

    public static <K, R> R accessService(Class<K> serviceClass, IOSGIServiceAccess<K, R> access) throws CoreException {
        Object service;
        Bundle bundle = FrameworkUtil.getBundle(access.getClass());
        BundleContext context = bundle.getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(serviceClass);
        if (serviceReference != null && (service = context.getService(serviceReference)) != null) {
            try {
                R r = access.runWithService(service);
                return r;
            }
            finally {
                context.ungetService(serviceReference);
            }
        }
        throw new CoreException((IStatus)new Status(4, "com.nvidia.common", String.format("OSGi service %s is not available.", serviceClass.getName())));
    }

    public static int[] append(int[] array, int ... elements) {
        if (CoreUtil.isNullOrEmpty(array)) {
            return elements;
        }
        if (CoreUtil.isNullOrEmpty(elements)) {
            return array;
        }
        int[] result = new int[array.length + elements.length];
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(elements, 0, result, array.length, elements.length);
        return result;
    }

    public static <T, K extends T> T[] append(T[] array, K ... elements) {
        if (CoreUtil.isNullOrEmpty(array)) {
            return elements;
        }
        if (CoreUtil.isNullOrEmpty(elements)) {
            return array;
        }
        LinkedHashSet<Object> set = new LinkedHashSet<Object>(Arrays.asList(array));
        set.addAll(Arrays.asList(elements));
        return set.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), set.size()));
    }

    public static String concat(String ... strings) {
        if (CoreUtil.isNullOrEmpty(strings)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(strings[0]);
        int i = 1;
        while (i < strings.length) {
            String string = strings[i];
            buffer.append(" ");
            buffer.append(string);
            ++i;
        }
        return buffer.toString();
    }

    public static CoreException coreException(String format, Object ... args) {
        return new CoreException(CoreUtil.errorStatus(format, args));
    }

    public static CoreException coreException(Throwable e) {
        return new CoreException(CoreUtil.errorStatus(e, null, new Object[0]));
    }

    public static CoreException coreException(Throwable e, String format, Object ... args) {
        return new CoreException(CoreUtil.errorStatus(e, format, args));
    }

    public static <T, A extends T> boolean equals(T obj1, A obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static boolean equalsIgnoringOrder(Object[] array1, Object[] array2) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null || array1.length != array2.length) {
            return false;
        }
        HashSet<Object> set = new HashSet<Object>(Arrays.asList(array1));
        return set.containsAll(Arrays.asList(array2));
    }

    public static IStatus errorStatus(String format, Object ... args) {
        return CoreUtil.status(4, null, format, args);
    }

    public static IStatus errorStatus(Throwable e, String format, Object ... args) {
        return CoreUtil.status(4, e, format, args);
    }

    public static <E extends Exception> E exceptionCast(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return (E)((Exception)e);
    }

    public static <T> T first(Iterable<T> t) {
        if (t == null) {
            return null;
        }
        Iterator<T> iterator = t.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static <T> T firstOrNull(T[] array) {
        if (CoreUtil.isNullOrEmpty(array)) {
            return null;
        }
        return array[0];
    }

    public static int getLowestSetBit(int arch) {
        if (arch == 0) {
            return 0;
        }
        int bit = 1;
        while (bit != 0) {
            if ((bit & arch) != 0) {
                return bit;
            }
            bit <<= 1;
        }
        return 0;
    }

    public static IStatus getMostSevereStatus(IStatus ... statuses) {
        if (CoreUtil.isNullOrEmpty(statuses)) {
            return OK_STATUS;
        }
        IStatus status = null;
        IStatus[] iStatusArray = statuses;
        int n = statuses.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus s = iStatusArray[n2];
            if (s != null && (status == null || status.getSeverity() < s.getSeverity())) {
                status = s;
            }
            ++n2;
        }
        return status;
    }

    public static <T> T getSelectedObject(ISelection selection, Class<T> clazz) {
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            return clazz.cast(element);
        }
        return null;
    }

    public static <T> T getSelectedObject(ISelectionProvider provider, Class<T> clazz) {
        return CoreUtil.getSelectedObject(provider.getSelection(), clazz);
    }

    public static <T, A extends T> int indexOf(T[] array, A value) {
        int i = 0;
        while (i < array.length) {
            T path = array[i];
            if (CoreUtil.equals(path, value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static <T> boolean isOneOf(T element, Object ... collection) {
        Object[] objectArray = collection;
        int n = collection.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (CoreUtil.equals(object, element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> T[] join(T[] ar1, Object ... ts) {
        int len = ar1.length;
        Object[] objectArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            Object t = objectArray[n2];
            if (t != null) {
                if (t.getClass().isArray()) {
                    int length = ((Object[])t).length;
                    if (length > 0) {
                        len += length;
                    }
                } else {
                    ++len;
                }
            }
            ++n2;
        }
        if (len == ar1.length) {
            return ar1;
        }
        Object[] array = (Object[])Array.newInstance(ar1.getClass().getComponentType(), len);
        if (ar1.length > 0) {
            System.arraycopy(ar1, 0, array, 0, ar1.length);
        }
        int pos = ar1.length;
        Object[] objectArray2 = ts;
        int n3 = ts.length;
        int n4 = 0;
        while (n4 < n3) {
            Object k = objectArray2[n4];
            if (k != null) {
                if (k.getClass().isArray()) {
                    int length = ((Object[])k).length;
                    if (length > 0) {
                        System.arraycopy(k, 0, array, pos, length);
                        pos += length;
                    }
                } else {
                    array[pos++] = k;
                }
            }
            ++n4;
        }
        return array;
    }

    public static IStatus moreSevere(IStatus status1, IStatus status2) {
        if (status1 == null) {
            return status2 != null ? status2 : OK_STATUS;
        }
        if (status2 == null || status1.getSeverity() >= status2.getSeverity()) {
            return status1;
        }
        return status2;
    }

    public static String notNull(String string) {
        return string == null ? "" : string.trim();
    }

    public static <T, E extends T> T pickNextSelection(T[] array, E element) {
        if (CoreUtil.isNullOrEmpty(array)) {
            return null;
        }
        if (array.length == 1) {
            return CoreUtil.equals(array[0], element) ? null : (T)array[0];
        }
        int i = CoreUtil.indexOf(array, element);
        if (i < 0) {
            return array[0];
        }
        if (i == array.length - 1) {
            return array[array.length - 2];
        }
        return array[i + 1];
    }

    public static boolean isTrue(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            return true;
        }
        if (o instanceof Integer && (Integer)o > 0) {
            return true;
        }
        return o instanceof BigInteger && ((BigInteger)o).compareTo(BigInteger.ZERO) > 0;
    }

    public static <T> T[] readExtensions(Class<T> clazz, String extensionPointId, String attributeName) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
        if (elements.length > 0) {
            HashSet<T> collection = new HashSet<T>(elements.length);
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                try {
                    collection.add(clazz.cast(element.createExecutableExtension(attributeName)));
                }
                catch (CoreException e) {
                    Activator.log(e, "Extension point %s cannot instantiate type %s from plugin %s", extensionPointId, element.getAttribute(attributeName), element.getContributor().getName());
                }
                ++n2;
            }
            return collection.toArray((Object[])Array.newInstance(clazz, collection.size()));
        }
        return (Object[])Array.newInstance(clazz, 0);
    }

    public static <T, K extends T> T[] remove(T[] array, K element) {
        if (CoreUtil.isNullOrEmpty(array)) {
            return array;
        }
        int removed = 0;
        int i = 0;
        while (i < array.length) {
            T t = array[i];
            if (CoreUtil.equals(t, element)) {
                ++removed;
                if (i < array.length - 1) {
                    System.arraycopy(array, i + 1, array, i, array.length - i - removed);
                }
            }
            ++i;
        }
        if (removed > 0) {
            return Arrays.copyOf(array, array.length - removed);
        }
        return array;
    }

    public static <T> T[] removeGaps(T[] elements) {
        return CoreUtil.remove(elements, null);
    }

    public static Status status(int severity, String format, Object ... args) {
        return CoreUtil.status(severity, null, format, args);
    }

    public static Status status(int severity, Throwable e, String format, Object ... args) {
        return new Status(severity, "com.nvidia.common", format == null ? null : String.format(format, args), e);
    }

    public static String trimAfter(String string, String delimeter) {
        if (CoreUtil.isNullOrEmpty(string) || CoreUtil.isNullOrEmpty(delimeter)) {
            return string;
        }
        int ind = string.lastIndexOf(delimeter);
        return ind > 0 ? string.substring(0, ind) : string;
    }

    public static IStatus warningStatus(String format, Object ... args) {
        return CoreUtil.status(2, null, format, args);
    }

    private CoreUtil() {
    }
}

