/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.toolkit;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.OS;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;

public abstract class AbstractToolkit
implements ICudaToolkit {
    private final Map<ICudaToolkit.Tool, String> toolPaths = new HashMap<ICudaToolkit.Tool, String>();

    protected Map<ICudaToolkit.Tool, String> getCustomizedToolPaths() {
        return this.toolPaths;
    }

    @Override
    public final String getDefaultToolPath(ICudaToolkit.Tool tool) {
        String exe = tool.executable(this.getToolkitOS());
        String bin = this.getBinDirectory();
        if (CoreUtil.isNullOrEmpty(bin)) {
            return exe;
        }
        return new Path(bin).append(exe).toString();
    }

    protected abstract OS getToolkitOS();

    @Override
    public final String getToolPath(ICudaToolkit.Tool tool) {
        if (this.toolPaths.containsKey((Object)tool)) {
            return this.toolPaths.get((Object)tool);
        }
        return this.getDefaultToolPath(tool);
    }

    protected void setToolPath(ICudaToolkit.Tool tool, String path) {
        if (CoreUtil.isNullOrEmpty(path)) {
            this.toolPaths.remove((Object)tool);
        } else if (!CoreUtil.equals(path, this.getDefaultToolPath(tool))) {
            this.toolPaths.put(tool, path);
        }
    }
}

