/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.util.OS;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class ToolkitOnPath
implements IToolkitLookup {
    private IPath getToolkitOnPath() {
        String path = System.getenv("PATH");
        if (path == null) {
            path = System.getenv("path");
        }
        if (path != null) {
            String[] paths;
            String[] stringArray = paths = path.split(File.pathSeparator);
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                try {
                    File file = new File(p).getAbsoluteFile().getCanonicalFile();
                    if (new File(file, ICudaToolkit.Tool.Nvcc.executable(OS.local())).isFile()) {
                        return new Path(file.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    Activator.log(e);
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public ICudaToolkit[] discover() {
        IPath path = this.getToolkitOnPath();
        if (path != null) {
            return new ICudaToolkit[]{new CudaToolkit("path.toolkit", path, "Toolkit on the Path")};
        }
        return null;
    }
}

