/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.internal.toolkit;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.internal.toolkit.CudaToolkit;
import com.nvidia.common.internal.toolkit.IToolkitLookup;
import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.ToolkitVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public final class LocallyInstalledToolkits
implements IToolkitLookup {
    private static final String[] DEFAULT_TOOLKIT_LOCATIONS = new String[]{ToolkitVersion.current.defaultBinPath, ToolkitVersion.current.defaultMacBinPath};

    @Override
    public ICudaToolkit[] discover() {
        ArrayList<CudaToolkit> paths = new ArrayList<CudaToolkit>(DEFAULT_TOOLKIT_LOCATIONS.length);
        int i = 1;
        String[] stringArray = DEFAULT_TOOLKIT_LOCATIONS;
        int n = DEFAULT_TOOLKIT_LOCATIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            try {
                File file = new File(p).getAbsoluteFile().getCanonicalFile();
                File nvcc = new File(file, "bin" + File.separator + "nvcc");
                if (nvcc.isFile()) {
                    paths.add(new CudaToolkit("local." + i++, (IPath)new Path(nvcc.getParentFile().getAbsolutePath()), null));
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
            ++n2;
        }
        return paths.toArray(new ICudaToolkit[paths.size()]);
    }
}

