/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IBandContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableGroupLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;

public class PDFTableBandLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    protected PDFTableLM tbl = this.getTableLayoutManager();
    protected int groupLevel;
    protected int type;
    protected boolean repeatHeader = false;

    public PDFTableBandLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) throws BirtException {
        super(context, parent, content, executor);
        IElement pContent = content.getParent();
        if (pContent instanceof IGroupContent) {
            IGroupContent groupContent = (IGroupContent)pContent;
            this.groupLevel = groupContent.getGroupLevel();
            this.repeatHeader = groupContent.isHeaderRepeat();
            this.type = ((IBandContent)content).getBandType();
            if (this.type == 3 && !(executor instanceof DOMReportItemExecutor) && this.repeatHeader) {
                this.execute(executor, content);
                executor.close();
                groupContent.getChildren().add(content);
                this.executor = new DOMReportItemExecutor(content);
                this.executor.execute();
            }
        } else if (pContent instanceof ITableContent) {
            ITableContent tableContent = (ITableContent)pContent;
            this.repeatHeader = tableContent.isHeaderRepeat();
            this.type = ((IBandContent)content).getBandType();
            if (this.type == 1 && !(executor instanceof DOMReportItemExecutor) && this.repeatHeader) {
                this.execute(executor, content);
                executor.close();
                tableContent.getChildren().add(content);
                this.executor = new DOMReportItemExecutor(content);
                this.executor.execute();
            }
        }
    }

    protected boolean traverseChildren() throws BirtException {
        if (this.isFirst && this.groupLevel >= 0 && this.type == 4) {
            int height = 0;
            height = this.tbl.updateUnresolvedCell(this.groupLevel, false);
            if (height != 0) {
                ((PDFTableGroupLM)this.parent).updateHeight(height);
            }
        }
        this.isFirst = false;
        boolean childBreak = super.traverseChildren();
        if (!childBreak && this.groupLevel >= 0 && this.type == 4) {
            int height = 0;
            height = this.tbl.updateUnresolvedCell(this.groupLevel, true);
            if (height != 0) {
                ((PDFTableGroupLM)this.parent).updateHeight(height);
            }
        }
        return childBreak;
    }

    public int getCurrentBP() {
        return this.parent.getCurrentBP();
    }

    protected boolean submitRoot(boolean childBreak) {
        return true;
    }

    public int getCurrentIP() {
        return this.parent.getCurrentIP();
    }

    public int getCurrentMaxContentHeight() {
        return this.parent.getCurrentMaxContentHeight();
    }

    public int getCurrentMaxContentWidth() {
        return this.parent.getCurrentMaxContentWidth();
    }

    public int getOffsetX() {
        return this.parent.getOffsetX();
    }

    public int getOffsetY() {
        return this.parent.getOffsetY();
    }

    public void setCurrentBP(int bp) {
        this.parent.setCurrentBP(bp);
    }

    public void setCurrentIP(int ip) {
        this.parent.setCurrentIP(ip);
    }

    public void setOffsetX(int x) {
        this.parent.setOffsetX(x);
    }

    public int getMaxAvaHeight() {
        return this.parent.getMaxAvaHeight();
    }

    public void setOffsetY(int y) {
        this.parent.setOffsetY(y);
    }

    public boolean addArea(IArea area, boolean keepWithPrevious, boolean keepWithNext) {
        return this.parent.addArea(area, false, false);
    }

    protected void createRoot() {
    }

    protected void initialize() {
    }

    protected IReportItemExecutor createExecutor() {
        return this.executor;
    }

    protected boolean allowPageBreak() {
        if (this.type == 3 || this.type == 1) {
            return !this.repeatHeader;
        }
        return true;
    }

    public void submit(AbstractArea area) {
        this.parent.submit(area);
    }

    protected boolean addToRoot(AbstractArea area) {
        if (this.getCurrentBP() + area.getAllocatedHeight() <= this.getMaxAvaHeight()) {
            this.parent.addArea(area, false, false);
            return true;
        }
        return false;
    }
}

