/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.dup;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.executor.DataItemExecutionState;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.model.api.TableHandle;

public class SuppressDuplicateUtil {
    private HashMap<DataItemDesign, DataItemExecutionState> states = new HashMap();
    private Report report;
    private ClearDuplicateFlagVisitor resetVisitor;

    public SuppressDuplicateUtil(Report report) {
        this.report = report;
        this.resetVisitor = new ClearDuplicateFlagVisitor();
    }

    public void clearDuplicateFlags(IContent content) {
        Object itemDesign = content.getGenerateBy();
        if (itemDesign instanceof GroupDesign) {
            GroupDesign groupDesign = (GroupDesign)itemDesign;
            ListingDesign listingDesign = this.getListingDesign(groupDesign);
            if (!this.isGroupEmpty(groupDesign)) {
                int groupLevel = groupDesign.getGroupLevel();
                int groupCount = listingDesign.getGroupCount();
                int i = groupLevel + 1;
                while (i < groupCount) {
                    GroupDesign group = listingDesign.getGroup(i);
                    group.accept(this.resetVisitor, null);
                    ++i;
                }
                BandDesign detail = listingDesign.getDetail();
                if (detail != null) {
                    detail.accept(this.resetVisitor, null);
                }
            }
        } else if (itemDesign instanceof ListingDesign) {
            ((ListingDesign)itemDesign).accept(this.resetVisitor, null);
        }
    }

    protected ListingDesign getListingDesign(GroupDesign groupDesign) {
        long listingId = groupDesign.getHandle().getContainer().getID();
        return (ListingDesign)this.report.getReportItemByID(listingId);
    }

    protected boolean isGroupEmpty(GroupDesign groupDesign) {
        BandDesign header = groupDesign.getHeader();
        BandDesign footer = groupDesign.getFooter();
        return (header == null || header.getContentCount() == 0) && (footer == null || footer.getContentCount() == 0);
    }

    public IContent suppressDuplicate(IContent content) throws BirtException {
        DataItemDesign dataDesign;
        int contentType = content.getContentType();
        if (contentType != 3) {
            return content;
        }
        IDataContent dataContent = (IDataContent)content;
        Object genBy = dataContent.getGenerateBy();
        if (genBy instanceof DataItemDesign && (dataDesign = (DataItemDesign)genBy).getSuppressDuplicate() && this.states.containsKey(dataDesign)) {
            Object lastValue;
            Object value = dataContent.getValue();
            DataItemExecutionState state = this.states.get(dataDesign);
            if (state != null && ((lastValue = state.lastValue) == value || lastValue != null && lastValue.equals(value))) {
                return null;
            }
            if (state == null) {
                state = new DataItemExecutionState();
                this.states.put(dataDesign, state);
            }
            state.lastValue = value;
        }
        return content;
    }

    protected class ClearDuplicateFlagVisitor
    extends DefaultReportItemVisitorImpl {
        Stack<Boolean> isInDetailBand = new Stack();

        protected ClearDuplicateFlagVisitor() {
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            int i = 0;
            while (i < container.getItemCount()) {
                container.getItem(i).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            TableHandle handle = (TableHandle)table.getHandle();
            boolean isSummaryTable = handle.isSummaryTable();
            if (isSummaryTable) {
                BandDesign header = table.getHeader();
                if (header != null) {
                    value = header.accept(this, value);
                }
                int i = 0;
                while (i < table.getGroupCount()) {
                    GroupDesign group = table.getGroup(i);
                    if (i == table.getGroupCount() - 1) {
                        this.isInDetailBand.push(Boolean.TRUE);
                    }
                    value = group.accept(this, value);
                    if (i == table.getGroupCount() - 1) {
                        this.isInDetailBand.pop();
                    }
                    ++i;
                }
                BandDesign footer = table.getFooter();
                if (footer != null) {
                    value = footer.accept(this, value);
                }
            } else {
                BandDesign footer;
                BandDesign header = table.getHeader();
                if (header != null) {
                    value = header.accept(this, value);
                }
                int i = 0;
                while (i < table.getGroupCount()) {
                    GroupDesign group = table.getGroup(i);
                    value = group.accept(this, value);
                    ++i;
                }
                BandDesign detail = table.getDetail();
                if (detail != null) {
                    this.isInDetailBand.push(Boolean.TRUE);
                    value = detail.accept(this, value);
                    this.isInDetailBand.pop();
                }
                if ((footer = table.getFooter()) != null) {
                    value = footer.accept(this, value);
                }
            }
            return value;
        }

        public Object visitListing(ListingDesign list, Object value) {
            BandDesign footer;
            BandDesign header = list.getHeader();
            if (header != null) {
                value = header.accept(this, value);
            }
            int i = 0;
            while (i < list.getGroupCount()) {
                GroupDesign group = list.getGroup(i);
                value = group.accept(this, value);
                ++i;
            }
            BandDesign detail = list.getDetail();
            if (detail != null) {
                value = detail.accept(this, value);
            }
            if ((footer = list.getFooter()) != null) {
                value = footer.accept(this, value);
            }
            return value;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            if (!this.isInDetailBand.isEmpty() && this.isInDetailBand.peek().booleanValue()) {
                SuppressDuplicateUtil.this.states.put(data, null);
            }
            return value;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            int i = 0;
            while (i < grid.getRowCount()) {
                value = grid.getRow(i).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitRow(RowDesign row, Object value) {
            int i = 0;
            while (i < row.getCellCount()) {
                value = this.visitCell(row.getCell(i), value);
                ++i;
            }
            return value;
        }

        public Object visitCell(CellDesign cell, Object value) {
            int i = 0;
            while (i < cell.getContentCount()) {
                value = cell.getContent(i).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitBand(BandDesign band, Object value) {
            int i = 0;
            while (i < band.getContentCount()) {
                value = band.getContent(i).accept(this, value);
                ++i;
            }
            return value;
        }

        public Object visitGroup(GroupDesign group, Object value) {
            BandDesign footer;
            BandDesign header = group.getHeader();
            if (header != null) {
                value = header.accept(this, value);
            }
            if ((footer = group.getFooter()) != null) {
                value = footer.accept(this, value);
            }
            return value;
        }
    }
}

