/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.DocWriter;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.codec.wmf.MetaDo;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.output.RtfByteArrayBuffer;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RtfImage
extends RtfElement {
    private static final byte[] PICTURE_GROUP = DocWriter.getISOBytes("\\*\\shppict");
    private static final byte[] PICTURE = DocWriter.getISOBytes("\\pict");
    private static final byte[] PICTURE_JPEG = DocWriter.getISOBytes("\\jpegblip");
    private static final byte[] PICTURE_PNG = DocWriter.getISOBytes("\\pngblip");
    private static final byte[] PICTURE_WMF = DocWriter.getISOBytes("\\wmetafile8");
    private static final byte[] PICTURE_WIDTH = DocWriter.getISOBytes("\\picw");
    private static final byte[] PICTURE_HEIGHT = DocWriter.getISOBytes("\\pich");
    private static final byte[] PICTURE_SCALED_WIDTH = DocWriter.getISOBytes("\\picwgoal");
    private static final byte[] PICTURE_SCALED_HEIGHT = DocWriter.getISOBytes("\\pichgoal");
    private static final byte[] PICTURE_SCALE_X = DocWriter.getISOBytes("\\picscalex");
    private static final byte[] PICTURE_SCALE_Y = DocWriter.getISOBytes("\\picscaley");
    private static final byte[] PICTURE_BINARY_DATA = DocWriter.getISOBytes("\\bin");
    private static final int PIXEL_TWIPS_FACTOR = 15;
    private final int imageType;
    private final byte[][] imageData;
    private int alignment = 0;
    private float width = 0.0f;
    private float height = 0.0f;
    private float plainWidth = 0.0f;
    private float plainHeight = 0.0f;
    private boolean topLevelElement = false;
    public static final byte[] byte2charLUT = new byte[512];

    public RtfImage(RtfDocument rtfDocument, Image image) throws DocumentException {
        super(rtfDocument);
        this.imageType = image.getOriginalType();
        if (this.imageType != 1 && this.imageType != 4 && this.imageType != 2 && this.imageType != 6 && this.imageType != 3) {
            throw new DocumentException("Only BMP, PNG, WMF, GIF and JPEG images are supported by the RTF Writer");
        }
        this.alignment = image.getAlignment();
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.plainWidth = image.getPlainWidth();
        this.plainHeight = image.getPlainHeight();
        this.imageData = this.getImageData(image);
    }

    private byte[][] getImageData(Image image) throws DocumentException {
        RtfByteArrayBuffer rtfByteArrayBuffer = new RtfByteArrayBuffer();
        try {
            if (this.imageType == 4) {
                rtfByteArrayBuffer.append(MetaDo.wrapBMP(image));
            } else {
                byte[] byArray = image.getOriginalData();
                if (byArray == null) {
                    InputStream inputStream = image.getUrl().openStream();
                    if (this.imageType == 6) {
                        for (int i = 0; i < 22; ++i) {
                            if (inputStream.read() >= 0) continue;
                            throw new EOFException("while removing wmf placeable header");
                        }
                    }
                    rtfByteArrayBuffer.write(inputStream);
                    inputStream.close();
                } else if (this.imageType == 6) {
                    rtfByteArrayBuffer.write(byArray, 22, byArray.length - 22);
                } else {
                    rtfByteArrayBuffer.append(byArray);
                }
            }
            return rtfByteArrayBuffer.toByteArrayArray();
        }
        catch (IOException iOException) {
            throw new DocumentException(iOException.getMessage());
        }
    }

    private void writeImageDataHexEncoded(OutputStream outputStream) throws IOException {
        int n = 0;
        for (int i = 0; i < this.imageData.length; ++i) {
            byte[] byArray = this.imageData[i];
            for (int j = 0; j < byArray.length; ++j) {
                outputStream.write(byte2charLUT, (byArray[j] & 0xFF) * 2, 2);
                if (++n != 64) continue;
                outputStream.write(10);
                n = 0;
            }
        }
        if (n > 0) {
            outputStream.write(10);
        }
    }

    private int imageDataSize() {
        int n = 0;
        for (int i = 0; i < this.imageData.length; ++i) {
            n += this.imageData[i].length;
        }
        return n;
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        if (this.topLevelElement) {
            outputStream.write(RtfParagraph.PARAGRAPH_DEFAULTS);
            switch (this.alignment) {
                case 0: {
                    outputStream.write(RtfParagraphStyle.ALIGN_LEFT);
                    break;
                }
                case 2: {
                    outputStream.write(RtfParagraphStyle.ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    outputStream.write(RtfParagraphStyle.ALIGN_CENTER);
                    break;
                }
                case 3: {
                    outputStream.write(RtfParagraphStyle.ALIGN_JUSTIFY);
                }
            }
        }
        outputStream.write(OPEN_GROUP);
        outputStream.write(PICTURE_GROUP);
        outputStream.write(OPEN_GROUP);
        outputStream.write(PICTURE);
        switch (this.imageType) {
            case 1: {
                outputStream.write(PICTURE_JPEG);
                break;
            }
            case 2: 
            case 3: {
                outputStream.write(PICTURE_PNG);
                break;
            }
            case 4: 
            case 6: {
                outputStream.write(PICTURE_WMF);
            }
        }
        outputStream.write(PICTURE_WIDTH);
        outputStream.write(this.intToByteArray((int)this.width));
        outputStream.write(PICTURE_HEIGHT);
        outputStream.write(this.intToByteArray((int)this.height));
        if (this.document.getDocumentSettings().isWriteImageScalingInformation()) {
            outputStream.write(PICTURE_SCALE_X);
            outputStream.write(this.intToByteArray((int)(100.0f * this.plainWidth / this.width)));
            outputStream.write(PICTURE_SCALE_Y);
            outputStream.write(this.intToByteArray((int)(100.0f * this.plainHeight / this.height)));
        }
        if (this.document.getDocumentSettings().isImagePDFConformance()) {
            outputStream.write(PICTURE_SCALED_WIDTH);
            outputStream.write(this.intToByteArray((int)((double)this.plainWidth * 20.0)));
            outputStream.write(PICTURE_SCALED_HEIGHT);
            outputStream.write(this.intToByteArray((int)((double)this.plainHeight * 20.0)));
        } else {
            if (this.width != this.plainWidth || this.imageType == 4) {
                outputStream.write(PICTURE_SCALED_WIDTH);
                outputStream.write(this.intToByteArray((int)(this.plainWidth * 15.0f)));
            }
            if (this.height != this.plainHeight || this.imageType == 4) {
                outputStream.write(PICTURE_SCALED_HEIGHT);
                outputStream.write(this.intToByteArray((int)(this.plainHeight * 15.0f)));
            }
        }
        if (this.document.getDocumentSettings().isImageWrittenAsBinary()) {
            outputStream.write(10);
            outputStream.write(PICTURE_BINARY_DATA);
            outputStream.write(this.intToByteArray(this.imageDataSize()));
            outputStream.write(DELIMITER);
            if (outputStream instanceof RtfByteArrayBuffer) {
                ((RtfByteArrayBuffer)outputStream).append(this.imageData);
            } else {
                for (int i = 0; i < this.imageData.length; ++i) {
                    outputStream.write(this.imageData[i]);
                }
            }
        } else {
            outputStream.write(DELIMITER);
            outputStream.write(10);
            this.writeImageDataHexEncoded(outputStream);
        }
        outputStream.write(CLOSE_GROUP);
        outputStream.write(CLOSE_GROUP);
        if (this.topLevelElement) {
            outputStream.write(RtfParagraph.PARAGRAPH);
            outputStream.write(RtfParagraph.PARAGRAPH);
        }
        outputStream.write(10);
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setTopLevelElement(boolean bl) {
        this.topLevelElement = bl;
    }

    static {
        int n = 48;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                byte by = (byte)n;
                RtfImage.byte2charLUT[(j * 16 + i) * 2 + 1] = by;
                RtfImage.byte2charLUT[(i * 16 + j) * 2] = by;
            }
            if ((n = (int)((char)(n + 1))) != 58) continue;
            n = 97;
        }
    }
}

