/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ide.launch;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ide.Activator;
import com.nvidia.viper.ide.ProfilerImages;
import com.nvidia.viper.ide.launch.LaunchConfigurationAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public final class ProfileTab
extends AbstractLaunchConfigurationTab {
    private Button startWithProfiling;
    private Button concurrent;
    private Button apiTrace;
    private Spinner timeout;
    private Button environmentProfiling;
    private Button uvmProfiling;
    private Button applicataionReplay;

    public Image getImage() {
        return ProfilerImages.getProfileTabImage();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        new Label(composite, 0).setText("Execution timeout:");
        this.timeout = new Spinner(composite, 2048);
        this.timeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProfileTab.this.setDirty(true);
                ProfileTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.timeout.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText("seconds");
        this.startWithProfiling = this.createCheckbox(composite, "Start execution with profiling enabled");
        this.concurrent = this.createCheckbox(composite, "Enable concurrent kernel profiling");
        this.apiTrace = this.createCheckbox(composite, "Enable CUDA API tracing in the timeline");
        this.environmentProfiling = this.createCheckbox(composite, ViperMessages.NewSession_Wizard_EnvironmentProfiling_Label);
        this.uvmProfiling = this.createCheckbox(composite, ViperMessages.NewSession_Wizard_UvmProfiling_Label);
        this.applicataionReplay = this.createCheckbox(composite, ViperMessages.NewSession_Wizard_AppReplay_Label);
        this.setControl((Control)composite);
    }

    private Button createCheckbox(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new DirtyOnChange());
        button.setLayoutData((Object)new GridData(-1, -1, false, false, 3, 1));
        return button;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("nvvp.startProfiling", true);
        configuration.setAttribute("nvvp.concurrentProfiling", true);
        configuration.setAttribute("nvvp.apiTraceProfiling", true);
        configuration.setAttribute("nvvp.environmentProfiling", false);
        configuration.setAttribute("nvvp.uvmProfiling", true);
        configuration.setAttribute("nvvp.appReplay", false);
        configuration.setAttribute("nvvp.timeout", 0);
        configuration.setAttribute("nvvp.filename", LaunchConfigurationAdapter.getDefaultSessionFile(configuration.getName()));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.startWithProfiling.setSelection(configuration.getAttribute("nvvp.startProfiling", true));
            this.concurrent.setSelection(configuration.getAttribute("nvvp.concurrentProfiling", true));
            this.apiTrace.setSelection(configuration.getAttribute("nvvp.apiTraceProfiling", true));
            this.configureEnvProfilingCheckbox(configuration);
            this.configureUvmProfilingCheckbox(configuration);
            this.applicataionReplay.setSelection(configuration.getAttribute("nvvp.appReplay", false));
            this.timeout.setValues(configuration.getAttribute("nvvp.timeout", 0), 0, Integer.MAX_VALUE, 0, 1, 10);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    private void disableForMacOS(ILaunchConfiguration configuration, String label, Button button, String attribute, boolean defaultSelection) throws CoreException {
        boolean enabled;
        boolean selection;
        if ("macosx".equals(Platform.getOS()) && !"org.eclipse.cdt.launch.remoteApplicationLaunchType".equals(configuration.getType().getIdentifier())) {
            label = String.valueOf(label) + " [not supported on Mac OSX]";
            selection = false;
            enabled = false;
        } else {
            selection = configuration.getAttribute(attribute, defaultSelection);
            enabled = true;
        }
        button.setText(label);
        button.setEnabled(enabled);
        button.setSelection(selection);
    }

    private void configureEnvProfilingCheckbox(ILaunchConfiguration configuration) throws CoreException {
        this.disableForMacOS(configuration, ViperMessages.NewSession_Wizard_EnvironmentProfiling_Label, this.environmentProfiling, "nvvp.environmentProfiling", false);
    }

    private void configureUvmProfilingCheckbox(ILaunchConfiguration configuration) throws CoreException {
        this.disableForMacOS(configuration, ViperMessages.NewSession_Wizard_UvmProfiling_Label, this.uvmProfiling, "nvvp.uvmProfiling", true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("nvvp.startProfiling", this.startWithProfiling.getSelection());
        configuration.setAttribute("nvvp.concurrentProfiling", this.concurrent.getSelection());
        configuration.setAttribute("nvvp.apiTraceProfiling", this.apiTrace.getSelection());
        configuration.setAttribute("nvvp.environmentProfiling", this.environmentProfiling.getSelection());
        configuration.setAttribute("nvvp.uvmProfiling", this.uvmProfiling.getSelection());
        configuration.setAttribute("nvvp.appReplay", this.applicataionReplay.getSelection());
        configuration.setAttribute("nvvp.timeout", this.timeout.getSelection());
    }

    public String getName() {
        return "Profiler";
    }

    public String getId() {
        return "com.nvidia.viper.ide.cudaProfiler.profileTab";
    }

    private final class DirtyOnChange
    extends SelectionAdapter {
        private DirtyOnChange() {
        }

        public void widgetSelected(SelectionEvent e) {
            ProfileTab.this.setDirty(true);
            ProfileTab.this.updateLaunchConfigurationDialog();
        }
    }
}

