/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIArg;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIFrame {
    int level;
    String addr;
    String exceptionAddr;
    String func = "";
    String file = "";
    String exceptionFile;
    String fullname = "";
    int line;
    int exceptionLine;
    MIArg[] args = new MIArg[0];

    public MIFrame(MITuple tuple) {
        this.parse(tuple);
    }

    public MIFrame(MITuple tuple, String exceptionAddr, String exceptionFile, int exceptionLine) {
        this.parse(tuple);
        this.exceptionAddr = exceptionAddr;
        this.exceptionFile = exceptionFile;
        this.exceptionLine = exceptionLine;
    }

    public MIArg[] getArgs() {
        return this.args;
    }

    public String getFile() {
        String fname = this.getFullname();
        return fname.length() != 0 ? fname : this.file;
    }

    public String getFullname() {
        return this.fullname;
    }

    public String getFunction() {
        return this.func;
    }

    public int getLine() {
        return this.line;
    }

    public String getAddress() {
        return this.addr;
    }

    public String getExceptionAddress() {
        return this.exceptionAddr;
    }

    public int getExceptionLine() {
        return this.exceptionLine;
    }

    public String getExceptionFile() {
        return this.exceptionFile;
    }

    public int getLevel() {
        return this.level;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("level=\"" + this.level + "\"");
        buffer.append(",addr=\"" + this.addr + "\"");
        buffer.append(",func=\"" + this.func + "\"");
        buffer.append(",file=\"" + this.file + "\"");
        buffer.append(",line=\"").append(this.line).append('\"');
        buffer.append(",args=[");
        int i = 0;
        while (i < this.args.length) {
            if (i != 0) {
                buffer.append(',');
            }
            buffer.append("{name=\"" + this.args[i].getName() + "\"");
            buffer.append(",value=\"" + this.args[i].getValue() + "\"}");
            ++i;
        }
        buffer.append(']');
        return buffer.toString();
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getCString();
            }
            if (var.equals("level")) {
                try {
                    this.level = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("addr")) {
                try {
                    this.addr = str.trim();
                    if (str.equals("<unavailable>")) {
                        this.addr = "";
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("func")) {
                this.func = null;
                if (str != null) {
                    int end;
                    this.func = (str = str.trim()).equals("??") ? "" : ((end = str.indexOf(40)) != -1 ? str.substring(0, end) : str);
                }
            } else if (var.equals("file")) {
                this.file = str;
            } else if (var.equals("fullname")) {
                this.fullname = str;
            } else if (var.equals("line")) {
                try {
                    this.line = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("args")) {
                if (value instanceof MIList) {
                    this.args = MIArg.getMIArgs((MIList)value);
                } else if (value instanceof MITuple) {
                    this.args = MIArg.getMIArgs((MITuple)value);
                }
            }
            ++i;
        }
    }
}

