/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.AbstractDMContext;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.BufferedCommandControl;
import org.eclipse.cdt.dsf.debug.service.command.CommandCache;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControl;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBTraceControl;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.events.IMIDMEvent;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIArg;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackInfoDepthInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackListArgumentsInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackListFramesInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStackListLocalsInfo;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.service.IDsfService;
import org.eclipse.cdt.utils.Addr32;
import org.eclipse.cdt.utils.Addr64;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

public class MIStack
extends AbstractDsfService
implements IStack,
ICachingService {
    private CommandCache fMICommandCache;
    private CommandFactory fCommandFactory;
    private StackDepthHashMap<Integer, StackDepthInfo> fStackDepthCache = new StackDepthHashMap();
    private MIStoppedEvent fCachedStoppedEvent;
    private IRunControl fRunControl;
    private boolean fTraceVisualization;

    public MIStack(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return GdbPlugin.getBundleContext();
    }

    public void initialize(final RequestMonitor rm) {
        super.initialize((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                MIStack.this.doInitialize(rm);
            }
        });
    }

    private void doInitialize(RequestMonitor rm) {
        ICommandControlService commandControl = (ICommandControlService)this.getServicesTracker().getService(ICommandControlService.class);
        BufferedCommandControl bufferedCommandControl = new BufferedCommandControl((ICommandControl)commandControl, this.getExecutor(), 2);
        this.fMICommandCache = new CommandCache(this.getSession(), (ICommandControl)bufferedCommandControl);
        this.fMICommandCache.setContextAvailable((IDMContext)commandControl.getContext(), true);
        this.fRunControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
        this.fCommandFactory = ((IMICommandControl)this.getServicesTracker().getService(IMICommandControl.class)).getCommandFactory();
        this.getSession().addServiceEventListener((Object)this, null);
        this.register(new String[]{IStack.class.getName(), MIStack.class.getName()}, new Hashtable());
        rm.done();
    }

    public void shutdown(RequestMonitor rm) {
        this.unregister();
        this.getSession().removeServiceEventListener((Object)this);
        this.fMICommandCache.reset();
        super.shutdown(rm);
    }

    public IStack.IFrameDMContext createFrameDMContext(IRunControl.IExecutionDMContext execDmc, int level) {
        return new MIFrameDMC(this.getSession().getId(), execDmc, level);
    }

    public void getFrames(IDMContext ctx, DataRequestMonitor<IStack.IFrameDMContext[]> rm) {
        this.getFrames(ctx, 0, -1, rm);
    }

    public void getFrames(IDMContext ctx, final int startIndex, final int endIndex, final DataRequestMonitor<IStack.IFrameDMContext[]> rm) {
        int firstIndex;
        ICommand<MIStackListFramesInfo> miStackListCmd;
        if (startIndex < 0 || endIndex > 0 && endIndex < startIndex) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid stack frame range [" + startIndex + ',' + endIndex + ']', null));
            rm.done();
            return;
        }
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context " + ctx, null));
            rm.done();
            return;
        }
        if (!this.fTraceVisualization && !this.fRunControl.isSuspended((IRunControl.IExecutionDMContext)execDmc)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Context is running: " + ctx, null));
            rm.done();
            return;
        }
        if (startIndex == 0 && endIndex == 0 && this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && execDmc.equals(this.fCachedStoppedEvent.getDMContext())) {
            rm.setData((Object)new IStack.IFrameDMContext[]{this.createFrameDMContext(execDmc, this.fCachedStoppedEvent.getFrame().getLevel())});
            rm.done();
            return;
        }
        if (endIndex >= 0) {
            miStackListCmd = this.fCommandFactory.createMIStackListFrames(execDmc, startIndex, endIndex);
            firstIndex = startIndex;
        } else {
            miStackListCmd = this.fCommandFactory.createMIStackListFrames(execDmc);
            firstIndex = 0;
        }
        this.fMICommandCache.execute(miStackListCmd, (DataRequestMonitor)new DataRequestMonitor<MIStackListFramesInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)MIStack.this.getFrames(execDmc, (MIStackListFramesInfo)this.getData(), firstIndex, endIndex, startIndex));
                rm.done();
            }
        });
    }

    public void getTopFrame(IDMContext ctx, final DataRequestMonitor<IStack.IFrameDMContext> rm) {
        IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)ctx, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context" + ctx, null));
            rm.done();
            return;
        }
        if (this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && execDmc.equals(this.fCachedStoppedEvent.getDMContext())) {
            rm.setData((Object)this.createFrameDMContext(execDmc, this.fCachedStoppedEvent.getFrame().getLevel()));
            rm.done();
            return;
        }
        this.getFrames(ctx, 0, 0, new DataRequestMonitor<IStack.IFrameDMContext[]>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                rm.setData((Object)((IStack.IFrameDMContext[])this.getData())[0]);
                rm.done();
            }
        });
    }

    private IStack.IFrameDMContext[] getFrames(IMIExecutionDMContext execDmc, MIStackListFramesInfo info, int firstIndex, int lastIndex, int startIndex) {
        int limit;
        int length = info.getMIFrames().length;
        if (lastIndex > 0 && (limit = lastIndex - startIndex + 1) < length) {
            length = limit;
        }
        IStack.IFrameDMContext[] frameDMCs = new MIFrameDMC[length];
        int i = 0;
        while (i < length) {
            MIFrame frame = info.getMIFrames()[i + startIndex - firstIndex];
            assert (startIndex + i == frame.getLevel());
            frameDMCs[i] = this.createFrameDMContext(execDmc, frame.getLevel());
            ++i;
        }
        return frameDMCs;
    }

    public void getFrameData(final IStack.IFrameDMContext frameDmc, final DataRequestMonitor<IStack.IFrameDMData> rm) {
        if (!(frameDmc instanceof MIFrameDMC)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context type " + frameDmc, null));
            rm.done();
            return;
        }
        final MIFrameDMC miFrameDmc = (MIFrameDMC)frameDmc;
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frameDmc, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No execution context found in " + frameDmc, null));
            rm.done();
            return;
        }
        if (miFrameDmc.fLevel == 0 && this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && (execDmc.equals(this.fCachedStoppedEvent.getDMContext()) || this.fTraceVisualization)) {
            class FrameDataFromStoppedEvent
            extends 1FrameData {
                private final MIStoppedEvent fEvent;

                FrameDataFromStoppedEvent(MIStoppedEvent event) {
                    abstract class FrameData
                    implements IStack.IFrameDMData {
                        FrameData() {
                        }

                        protected abstract MIFrame getMIFrame();

                        public IAddress getAddress() {
                            String addr = this.getMIFrame().getAddress();
                            if (addr == null || addr.length() == 0) {
                                return new Addr32(0L);
                            }
                            if (addr.startsWith("0x")) {
                                addr = addr.substring(2);
                            }
                            if (addr.length() <= 8) {
                                return new Addr32(this.getMIFrame().getAddress());
                            }
                            return new Addr64(this.getMIFrame().getAddress());
                        }

                        public int getColumn() {
                            return 0;
                        }

                        public String getFile() {
                            return this.getMIFrame().getFile();
                        }

                        public int getLine() {
                            return this.getMIFrame().getLine();
                        }

                        public String getFunction() {
                            return this.getMIFrame().getFunction();
                        }

                        public String getModule() {
                            return "";
                        }

                        public String toString() {
                            return this.getMIFrame().toString();
                        }

                        public IAddress getExceptionAddress() {
                            String addr = this.getMIFrame().getExceptionAddress();
                            if (addr == null || addr.length() == 0) {
                                return null;
                            }
                            if (addr.startsWith("0x")) {
                                addr = addr.substring(2);
                            }
                            if (addr.length() <= 8) {
                                return new Addr32(this.getMIFrame().getExceptionAddress());
                            }
                            return new Addr64(this.getMIFrame().getExceptionAddress());
                        }

                        public String getExceptionFile() {
                            return this.getMIFrame().getExceptionFile();
                        }

                        public int getExceptionLine() {
                            return this.getMIFrame().getExceptionLine();
                        }
                    }
                    this.fEvent = event;
                }

                @Override
                protected MIFrame getMIFrame() {
                    return this.fEvent.getFrame();
                }
            }
            rm.setData((Object)new FrameDataFromStoppedEvent(this.fCachedStoppedEvent));
            rm.done();
            return;
        }
        this.fMICommandCache.execute(this.fCommandFactory.createMIStackListFrames(execDmc), (DataRequestMonitor)new DataRequestMonitor<MIStackListFramesInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                int idx = MIStack.this.findFrameIndex(((MIStackListFramesInfo)this.getData()).getMIFrames(), miFrameDmc.fLevel);
                if (idx == -1) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid frame " + frameDmc, null));
                    rm.done();
                    return;
                }
                class FrameDataFromMIStackFrameListInfo
                extends 1FrameData {
                    private MIStackListFramesInfo fFrameDataCacheInfo;
                    private int fFrameIndex;

                    FrameDataFromMIStackFrameListInfo(MIStackListFramesInfo info, int index) {
                        this.fFrameDataCacheInfo = info;
                        this.fFrameIndex = index;
                    }

                    @Override
                    protected MIFrame getMIFrame() {
                        return this.fFrameDataCacheInfo.getMIFrames()[this.fFrameIndex];
                    }
                }
                rm.setData((Object)new FrameDataFromMIStackFrameListInfo((MIStackListFramesInfo)this.getData(), idx));
                rm.done();
            }

            protected void handleError() {
                if (miFrameDmc.fLevel == 0) {
                    MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListFrames(execDmc, 0, 0), (DataRequestMonitor)new DataRequestMonitor<MIStackListFramesInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            int idx = MIStack.this.findFrameIndex(((MIStackListFramesInfo)this.getData()).getMIFrames(), miFrameDmc.fLevel);
                            if (idx == -1) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid frame " + frameDmc, null));
                                rm.done();
                                return;
                            }
                            rm.setData((Object)new FrameDataFromMIStackFrameListInfo((MIStackListFramesInfo)this.getData(), idx));
                            rm.done();
                        }
                    });
                } else {
                    super.handleError();
                }
            }
        });
    }

    public void getArguments(final IStack.IFrameDMContext frameDmc, final DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frameDmc, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No execution context found in " + frameDmc, null));
            rm.done();
            return;
        }
        if (frameDmc.getLevel() == 0 && this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && execDmc.equals(this.fCachedStoppedEvent.getDMContext()) && this.fCachedStoppedEvent.getFrame().getArgs() != null) {
            rm.setData((Object)this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.ARGUMENT, this.fCachedStoppedEvent.getFrame().getArgs()));
            rm.done();
            return;
        }
        this.fMICommandCache.execute(this.fCommandFactory.createMIStackListArguments(execDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIStackListArgumentsInfo>((Executor)this.getExecutor(), rm){

            protected void handleSuccess() {
                int idx = frameDmc.getLevel();
                if (idx == -1 || idx >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames().length) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid frame " + frameDmc, null));
                    rm.done();
                    return;
                }
                MIArg[] args = ((MIStackListArgumentsInfo)this.getData()).getMIFrames()[idx].getArgs();
                if (args == null) {
                    args = new MIArg[]{};
                }
                rm.setData((Object)MIStack.this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.ARGUMENT, args));
                rm.done();
            }

            protected void handleError() {
                MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListArguments(execDmc, false), (DataRequestMonitor)new DataRequestMonitor<MIStackListArgumentsInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                    protected void handleSuccess() {
                        int idx = frameDmc.getLevel();
                        if (idx == -1 || idx >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames().length) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, "Invalid frame " + frameDmc, null));
                            rm.done();
                            return;
                        }
                        MIArg[] args = ((MIStackListArgumentsInfo)this.getData()).getMIFrames()[idx].getArgs();
                        if (args == null) {
                            args = new MIArg[]{};
                        }
                        rm.setData((Object)MIStack.this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.ARGUMENT, args));
                        rm.done();
                    }
                });
            }
        });
    }

    public void getVariableData(IStack.IVariableDMContext variableDmc, final DataRequestMonitor<IStack.IVariableDMData> rm) {
        if (!(variableDmc instanceof MIVariableDMC)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context type " + variableDmc, null));
            rm.done();
            return;
        }
        final MIVariableDMC miVariableDmc = (MIVariableDMC)variableDmc;
        final MIFrameDMC frameDmc = (MIFrameDMC)DMContexts.getAncestorOfType((IDMContext)variableDmc, MIFrameDMC.class);
        if (frameDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No frame context found in " + variableDmc, null));
            rm.done();
            return;
        }
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frameDmc, IMIExecutionDMContext.class);
        if (execDmc == null) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "No execution context found in " + (Object)((Object)frameDmc), null));
            rm.done();
            return;
        }
        if (execDmc != null && miVariableDmc.fType == MIVariableDMC.Type.ARGUMENT && frameDmc.fLevel == 0 && this.fCachedStoppedEvent != null && this.fCachedStoppedEvent.getFrame() != null && execDmc.equals(this.fCachedStoppedEvent.getDMContext()) && this.fCachedStoppedEvent.getFrame().getArgs() != null) {
            if (miVariableDmc.fIndex >= this.fCachedStoppedEvent.getFrame().getArgs().length) {
                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                rm.done();
                return;
            }
            class VariableData
            implements IStack.IVariableDMData {
                private MIArg dsfMIArg;

                VariableData(MIArg arg) {
                    this.dsfMIArg = arg;
                }

                public String getName() {
                    return this.dsfMIArg.getName();
                }

                public String getValue() {
                    return this.dsfMIArg.getValue();
                }

                public String toString() {
                    return this.dsfMIArg.toString();
                }
            }
            rm.setData((Object)new VariableData(this.fCachedStoppedEvent.getFrame().getArgs()[miVariableDmc.fIndex]));
            rm.done();
            return;
        }
        if (miVariableDmc.fType == MIVariableDMC.Type.ARGUMENT) {
            this.fMICommandCache.execute(this.fCommandFactory.createMIStackListArguments(execDmc, true), (DataRequestMonitor)new DataRequestMonitor<MIStackListArgumentsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    if (frameDmc.fLevel >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames().length || miVariableDmc.fIndex >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames()[frameDmc.fLevel].getArgs().length) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                        rm.done();
                        return;
                    }
                    rm.setData((Object)new VariableData(((MIStackListArgumentsInfo)this.getData()).getMIFrames()[frameDmc.fLevel].getArgs()[miVariableDmc.fIndex]));
                    rm.done();
                }

                protected void handleError() {
                    MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListArguments(execDmc, false), (DataRequestMonitor)new DataRequestMonitor<MIStackListArgumentsInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            if (frameDmc.fLevel >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames().length || miVariableDmc.fIndex >= ((MIStackListArgumentsInfo)this.getData()).getMIFrames()[frameDmc.fLevel].getArgs().length) {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                                rm.done();
                                return;
                            }
                            rm.setData((Object)new VariableData(((MIStackListArgumentsInfo)this.getData()).getMIFrames()[frameDmc.fLevel].getArgs()[miVariableDmc.fIndex]));
                            rm.done();
                        }
                    });
                }
            });
        }
        if (miVariableDmc.fType == MIVariableDMC.Type.LOCAL) {
            this.fMICommandCache.execute(this.fCommandFactory.createMIStackListLocals(frameDmc, !this.fTraceVisualization), (DataRequestMonitor)new DataRequestMonitor<MIStackListLocalsInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIArg[] locals = ((MIStackListLocalsInfo)this.getData()).getLocals();
                    if (locals.length > miVariableDmc.fIndex) {
                        rm.setData((Object)new VariableData(locals[miVariableDmc.fIndex]));
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                    }
                    rm.done();
                }

                protected void handleError() {
                    MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListLocals(frameDmc, false), (DataRequestMonitor)new DataRequestMonitor<MIStackListLocalsInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)rm){

                        protected void handleSuccess() {
                            MIArg[] locals = ((MIStackListLocalsInfo)this.getData()).getLocals();
                            if (locals.length > miVariableDmc.fIndex) {
                                rm.setData((Object)new VariableData(locals[miVariableDmc.fIndex]));
                            } else {
                                rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid variable " + (Object)((Object)miVariableDmc), null));
                            }
                            rm.done();
                        }
                    });
                }
            });
        }
    }

    private MIVariableDMC[] makeVariableDMCs(IStack.IFrameDMContext frame, MIVariableDMC.Type type, MIArg[] miArgs) {
        LinkedHashMap<String, MIVariableDMC> variableNames = new LinkedHashMap<String, MIVariableDMC>();
        int i = 0;
        while (i < miArgs.length) {
            String name = miArgs[i].getName();
            MIVariableDMC var = (MIVariableDMC)((Object)variableNames.get(name));
            if (var == null) {
                variableNames.put(name, new MIVariableDMC(this, frame, type, i));
            }
            ++i;
        }
        return variableNames.values().toArray(new MIVariableDMC[0]);
    }

    private int findFrameIndex(MIFrame[] frames, int level) {
        int idx = 0;
        while (idx < frames.length) {
            if (frames[idx].getLevel() == level) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public void getLocals(final IStack.IFrameDMContext frameDmc, DataRequestMonitor<IStack.IVariableDMContext[]> rm) {
        final ArrayList localsList = new ArrayList();
        final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)this.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm, localsList){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ List val$localsList;
            {
                this.val$rm = dataRequestMonitor;
                this.val$localsList = list;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$rm.setData((Object)this.val$localsList.toArray(new IStack.IVariableDMContext[this.val$localsList.size()]));
                this.val$rm.done();
            }
        };
        countingRm.setDoneCount(2);
        this.getArguments(frameDmc, new DataRequestMonitor<IStack.IVariableDMContext[]>((Executor)this.getExecutor(), (RequestMonitor)countingRm){

            protected void handleSuccess() {
                localsList.addAll(Arrays.asList((IStack.IVariableDMContext[])this.getData()));
                countingRm.done();
            }
        });
        this.fMICommandCache.execute(this.fCommandFactory.createMIStackListLocals(frameDmc, !this.fTraceVisualization), (DataRequestMonitor)new DataRequestMonitor<MIStackListLocalsInfo>((Executor)this.getExecutor(), (RequestMonitor)countingRm){

            protected void handleSuccess() {
                localsList.addAll(Arrays.asList(MIStack.this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.LOCAL, ((MIStackListLocalsInfo)this.getData()).getLocals())));
                countingRm.done();
            }

            protected void handleError() {
                MIStack.this.fMICommandCache.execute(MIStack.this.fCommandFactory.createMIStackListLocals(frameDmc, false), (DataRequestMonitor)new DataRequestMonitor<MIStackListLocalsInfo>((Executor)MIStack.this.getExecutor(), (RequestMonitor)countingRm){

                    protected void handleSuccess() {
                        localsList.addAll(Arrays.asList(MIStack.this.makeVariableDMCs(frameDmc, MIVariableDMC.Type.LOCAL, ((MIStackListLocalsInfo)this.getData()).getLocals())));
                        countingRm.done();
                    }
                });
            }
        });
    }

    public void getStackDepth(final IDMContext dmc, final int maxDepth, final DataRequestMonitor<Integer> rm) {
        final IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)dmc, IMIExecutionDMContext.class);
        if (execDmc != null) {
            if (!this.fTraceVisualization && !this.fRunControl.isSuspended((IRunControl.IExecutionDMContext)execDmc)) {
                rm.setData((Object)0);
                rm.done();
                return;
            }
            StackDepthInfo cachedDepth = (StackDepthInfo)this.fStackDepthCache.get(execDmc.getThreadId());
            if (cachedDepth != null && (cachedDepth.maxDepthRequested == 0 || maxDepth != 0 && cachedDepth.maxDepthRequested >= maxDepth)) {
                rm.setData((Object)cachedDepth.returnedDepth);
                rm.done();
                return;
            }
            ICommand<MIStackInfoDepthInfo> depthCommand = null;
            depthCommand = maxDepth > 0 ? this.fCommandFactory.createMIStackInfoDepth(execDmc, maxDepth) : this.fCommandFactory.createMIStackInfoDepth(execDmc);
            this.fMICommandCache.execute(depthCommand, (DataRequestMonitor)new DataRequestMonitor<MIStackInfoDepthInfo>((Executor)this.getExecutor(), rm){

                protected void handleSuccess() {
                    MIStack.this.fStackDepthCache.put(execDmc.getThreadId(), new StackDepthInfo(maxDepth, ((MIStackInfoDepthInfo)this.getData()).getDepth()));
                    rm.setData((Object)((MIStackInfoDepthInfo)this.getData()).getDepth());
                    rm.done();
                }

                protected void handleError() {
                    if (MIStack.this.fTraceVisualization) {
                        rm.setData((Object)1);
                        rm.done();
                    } else if (maxDepth != 1) {
                        MIStack.this.getStackDepth(dmc, 1, (DataRequestMonitor<Integer>)rm);
                    } else {
                        super.handleError();
                    }
                }
            });
        } else {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10002, "Invalid context", null));
            rm.done();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.IResumedDMEvent e) {
        this.fMICommandCache.setContextAvailable(e.getDMContext(), false);
        if (e.getReason() != IRunControl.StateChangeReason.STEP) {
            this.fCachedStoppedEvent = null;
            this.fMICommandCache.reset();
            this.fStackDepthCache.clear();
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IRunControl.ISuspendedDMEvent e) {
        this.fMICommandCache.setContextAvailable(e.getDMContext(), true);
        this.fMICommandCache.reset();
        this.fStackDepthCache.clear();
    }

    @DsfServiceEventHandler
    public void eventDispatched(IMIDMEvent e) {
        if (e.getMIEvent() instanceof MIStoppedEvent) {
            this.fCachedStoppedEvent = (MIStoppedEvent)((Object)e.getMIEvent());
        }
    }

    @DsfServiceEventHandler
    public void eventDispatched(IGDBTraceControl.ITraceRecordSelectedChangedDMEvent e) {
        if (e.isVisualizationModeEnabled()) {
            this.fTraceVisualization = true;
        } else {
            this.fTraceVisualization = false;
            this.fCachedStoppedEvent = null;
        }
    }

    public void flushCache(IDMContext context) {
        this.fMICommandCache.reset(context);
        this.fStackDepthCache.clear(context);
        this.fCachedStoppedEvent = null;
    }

    protected static class MIFrameDMC
    extends AbstractDMContext
    implements IStack.IFrameDMContext {
        private final int fLevel;

        public MIFrameDMC(String sessionId, IRunControl.IExecutionDMContext execDmc, int level) {
            super(sessionId, new IDMContext[]{execDmc});
            this.fLevel = level;
        }

        public int getLevel() {
            return this.fLevel;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && ((MIFrameDMC)((Object)other)).fLevel == this.fLevel;
        }

        public int hashCode() {
            return super.baseHashCode() ^ this.fLevel;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".frame[" + this.fLevel + "]";
        }
    }

    protected static class MIVariableDMC
    extends AbstractDMContext
    implements IStack.IVariableDMContext {
        private final Type fType;
        private final int fIndex;

        public MIVariableDMC(MIStack service, IStack.IFrameDMContext frame, Type type, int index) {
            super((IDsfService)service, new IDMContext[]{frame});
            this.fIndex = index;
            this.fType = type;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public Type getType() {
            return this.fType;
        }

        public boolean equals(Object other) {
            return super.baseEquals(other) && ((MIVariableDMC)((Object)other)).fType == this.fType && ((MIVariableDMC)((Object)other)).fIndex == this.fIndex;
        }

        public int hashCode() {
            int typeFactor = 0;
            if (this.fType == Type.LOCAL) {
                typeFactor = 2;
            } else if (this.fType == Type.ARGUMENT) {
                typeFactor = 3;
            }
            return super.baseHashCode() ^ typeFactor ^ this.fIndex;
        }

        public String toString() {
            return String.valueOf(this.baseToString()) + ".variable(" + (Object)((Object)this.fType) + ")[" + this.fIndex + "]";
        }

        public static enum Type {
            ARGUMENT,
            LOCAL;

        }
    }

    private class StackDepthHashMap<V, T>
    extends HashMap<V, T> {
        private StackDepthHashMap() {
        }

        public void clear(IDMContext context) {
            IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)context, IMIExecutionDMContext.class);
            if (execDmc != null) {
                this.remove(execDmc.getThreadId());
            } else {
                this.clear();
            }
        }
    }

    private class StackDepthInfo {
        public int maxDepthRequested;
        public int returnedDepth;

        StackDepthInfo(int requested, int returned) {
            this.maxDepthRequested = requested;
            this.returnedDepth = returned;
        }
    }
}

