/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.ui.connection.toolkits;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.DataBindingUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.common.util.PageTitleStatusObservable;
import com.nvidia.common.util.SWTUtil;
import com.nvidia.common.wizards.PropertyDescriptor;
import com.nvidia.common.wizards.WizardContext;
import com.nvidia.cuda.ide.remote.connection.CudaToolkitWorkingCopy;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import com.nvidia.cuda.ide.remote.internal.connection.DetectRemoteToolkits;
import com.nvidia.cuda.ide.remote.internal.connection.Images;
import com.nvidia.cuda.ide.remote.internal.ui.connection.toolkits.RemotePathCellEditor;
import com.nvidia.cuda.ide.remote.ui.connection.ConnectionStateLabel;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.CustomToolsWizard;
import com.nvidia.cuda.ide.remote.ui.connection.toolkits.IToolkitProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.map.ObservableMap;
import org.eclipse.core.databinding.observable.map.WritableMap;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RemoteConnectionToolkitWizardPage
extends WizardPage
implements SelectionListener,
FocusListener {
    private static Font italic;
    private static final Object PLACEHOLDER;
    private static final PropertyDescriptor<ObservableMap> PROPERTY_DISCOVERED_TOOLKITS;
    private Button btnBrowse;
    private Button btnBrowseLibrary;
    private Button btnDelete;
    private Button btnDetect;
    private Button btnMoveDown;
    private Button btnMoveUp;
    private Combo comboLocation;
    private ConnectionStateLabel connectionStateLabel;
    private final WizardContext context;
    private DataBindingContext databinding;
    private final Map<String, String[]> detected = new HashMap<String, String[]>();
    private final Map<String, CudaToolkitWorkingCopy> toolkitWorkingCopies = new HashMap<String, CudaToolkitWorkingCopy>();
    private TableViewer libraryPaths;
    private IObservableValue libraryPathsObservable;
    private Text location;
    private IObservableValue locationObservable;
    private String originalPath;
    private PageBook pbLocation;
    private final PropertyDescriptor<IRemoteConnection> property;
    private String message;
    private String app;
    private final IToolkitProperties[] props = (IToolkitProperties[])CoreUtil.readExtensions(IToolkitProperties.class, (String)"com.nvidia.cuda.ide.remote.connection.remoteToolkitProperties", (String)"class");
    private final IObservableValue toolkit = new ComputedValue(CudaToolkitWorkingCopy.class){

        protected Object calculate() {
            return RemoteConnectionToolkitWizardPage.this.getConnectionWorkingCopy();
        }
    };

    static {
        PLACEHOLDER = new Object();
        PROPERTY_DISCOVERED_TOOLKITS = new PropertyDescriptor("remote.connection.discovered", ObservableMap.class);
    }

    private static IStatus validatePath(IRemoteConnection connection, String path, boolean requireFile, boolean requireExecutable, String wrongFileMessageFormat) {
        boolean valid = requireFile ? connection.isFile(path, requireExecutable, (IProgressMonitor)new NullProgressMonitor()) : connection.isDirectory(path, (IProgressMonitor)new NullProgressMonitor());
        return valid ? CoreUtil.OK_STATUS : CoreUtil.errorStatus((String)wrongFileMessageFormat, (Object[])new Object[]{path});
    }

    public RemoteConnectionToolkitWizardPage(WizardContext context, PropertyDescriptor<IRemoteConnection> property, String message, String app) {
        super("CUDA Toolkits", "Configure CUDA Toolkit", null);
        if (context.getProperty(PROPERTY_DISCOVERED_TOOLKITS) == null) {
            context.setProperty(PROPERTY_DISCOVERED_TOOLKITS, (Object)new WritableMap(String.class, String[].class));
        }
        this.context = context;
        this.property = property;
        this.app = app;
        this.message = message;
        this.setDescription("Configure CUDA toolkit location on the remote system");
        this.setPageComplete(this.internalGetToolkit() != null);
        this.databinding = new DataBindingContext();
        this.databinding.bindValue(this.toolkit, (IObservableValue)new AbstractObservableValue(){

            protected Object doGetValue() {
                return RemoteConnectionToolkitWizardPage.this.internalGetToolkit();
            }

            protected void doSetValue(Object value) {
                RemoteConnectionToolkitWizardPage.this.setPageComplete(value != null);
                RemoteConnectionToolkitWizardPage.this.getContainer().updateButtons();
            }

            public Object getValueType() {
                return CudaToolkitWorkingCopy.class;
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
    }

    protected Object getConnectionWorkingCopy() {
        final IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
        if (connection != null) {
            if (this.toolkitWorkingCopies.containsKey(connection)) {
                return this.toolkitWorkingCopies.get(connection.getName());
            }
            try {
                ICudaToolkit toolkit = (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                    public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                        return service.getToolkit(connection.getName());
                    }
                });
                CudaToolkitWorkingCopy wc = new CudaToolkitWorkingCopy(toolkit);
                this.toolkitWorkingCopies.put(connection.getName(), wc);
                return wc;
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)"Unable to access toolkit for connection %s", (Object[])new Object[]{connection.getName()}));
                return null;
            }
        }
        return null;
    }

    protected void browseForToolkit() {
        CudaToolkitWorkingCopy toolkit = this.internalGetToolkit();
        final IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
        if (connection != null && toolkit != null) {
            String binDirectory = toolkit.getToolPath(ICudaToolkit.Tool.GdbServer);
            if (this.originalPath == null) {
                this.originalPath = binDirectory;
            }
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            connection.connect(IRemoteConnection.Service.Files, monitor);
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]), 2);
                        }
                    }
                });
                String newPath = connection.browse(this.getShell(), this.message, binDirectory);
                if (newPath != null && !CoreUtil.equals((Object)newPath, (Object)binDirectory)) {
                    toolkit.setBinDirectory(newPath);
                    this.locationFocusOut(newPath);
                }
                SWTUtil.updateTitle((WizardPage)this, (IStatus)this.validate());
            }
            catch (InvocationTargetException e) {
                Activator.log(e);
            }
            catch (InterruptedException e) {
                Activator.log(e);
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
    }

    protected void browseLibraryPath() {
        try {
            final IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
            CudaToolkitWorkingCopy toolkit = this.internalGetToolkit();
            if (connection != null && toolkit != null) {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            connection.connect(IRemoteConnection.Service.Files, monitor);
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle(CoreUtil.errorStatus((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]), 2);
                        }
                    }
                });
                String newPath = connection.browse(this.getShell(), "Select toolkit library folder", "");
                if (!CoreUtil.isNullOrEmpty((String)newPath)) {
                    toolkit.addLibraryPath(newPath);
                    this.postLibraryPathSelection(newPath);
                }
                SWTUtil.updateTitle((WizardPage)this, (IStatus)this.validate());
            }
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
    }

    private IStatus checkFiles(boolean requireFile, boolean requireExecutable, String wrongFileFormat, String ... paths) {
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
        if (this.isConnected(connection) && !CoreUtil.isNullOrEmpty((Object[])paths)) {
            int i = 0;
            IStatus[] statuses = new IStatus[paths.length];
            String[] stringArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                statuses[i++] = RemoteConnectionToolkitWizardPage.validatePath(connection, path, requireFile, requireExecutable, wrongFileFormat);
                ++n2;
            }
            if (statuses.length == 1) {
                return statuses[0];
            }
            return CoreUtil.getMostSevereStatus((IStatus[])statuses);
        }
        return CoreUtil.OK_STATUS;
    }

    public void createControl(Composite parent) {
        if (this.databinding != null) {
            this.databinding.dispose();
        }
        Composite composite_1 = new Composite(parent, 0);
        this.setControl((Control)composite_1);
        composite_1.setLayout((Layout)new GridLayout(4, false));
        Label lblCudagdbLocation = new Label(composite_1, 0);
        lblCudagdbLocation.setText("Toolkit path:");
        lblCudagdbLocation.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.pbLocation = new PageBook(composite_1, 0);
        this.location = new Text((Composite)this.pbLocation, 2048);
        this.location.addFocusListener((FocusListener)this);
        this.comboLocation = new Combo((Composite)this.pbLocation, 2048);
        this.comboLocation.addFocusListener((FocusListener)this);
        GridData gd_location = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_location.widthHint = 75;
        this.pbLocation.setLayoutData((Object)gd_location);
        this.pbLocation.showPage((Control)this.location);
        this.btnBrowse = new Button(composite_1, 0);
        this.btnBrowse.addSelectionListener((SelectionListener)this);
        this.btnBrowse.addFocusListener((FocusListener)this);
        this.btnBrowse.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnBrowse.setText("Browse...");
        this.btnDetect = new Button(composite_1, 0);
        this.btnDetect.addSelectionListener((SelectionListener)this);
        this.btnDetect.addFocusListener((FocusListener)this);
        this.btnDetect.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDetect.setText("Detect...");
        Label lblLibraryPaths = new Label(composite_1, 0);
        lblLibraryPaths.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblLibraryPaths.setText("Library paths:");
        this.libraryPaths = new TableViewer(composite_1, 67584);
        Table table = this.libraryPaths.getTable();
        GridData gd_table = new GridData(4, 4, true, true, 2, 4);
        gd_table.widthHint = 50;
        gd_table.heightHint = 20;
        table.setLayoutData((Object)gd_table);
        table.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 4) {
                    RemoteConnectionToolkitWizardPage.this.editPath();
                    e.doit = false;
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x100000B: {
                        RemoteConnectionToolkitWizardPage.this.editPath();
                        break;
                    }
                    case 8: 
                    case 127: {
                        RemoteConnectionToolkitWizardPage.this.deletePath();
                    }
                }
            }
        });
        this.libraryPaths.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return inputElement == null ? new Object[]{} : RemoteConnectionToolkitWizardPage.this.getLibraryPaths((String[])inputElement);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.libraryPaths.setLabelProvider((IBaseLabelProvider)new LibraryPathsContentProvider());
        this.libraryPaths.setCellModifier((ICellModifier)new LibraryPathCellModifier());
        this.libraryPaths.setCellEditors(new CellEditor[]{new RemotePathCellEditor((Composite)this.libraryPaths.getTable(), (IRunnableContext)this.getContainer(), this.property == null ? null : this.context.observeProperty(this.property))});
        this.libraryPaths.setColumnProperties(new String[]{"path"});
        this.btnBrowseLibrary = new Button(composite_1, 0);
        this.btnBrowseLibrary.addSelectionListener((SelectionListener)this);
        this.btnBrowseLibrary.setText("Browse...");
        new Label(composite_1, 0);
        this.btnDelete = new Button(composite_1, 0);
        this.btnDelete.addSelectionListener((SelectionListener)this);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnDelete.setText("Delete");
        new Label(composite_1, 0);
        this.btnMoveUp = new Button(composite_1, 0);
        this.btnMoveUp.addSelectionListener((SelectionListener)this);
        this.btnMoveUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnMoveUp.setImage(Images.List_Moveup.getImage());
        new Label(composite_1, 0);
        this.btnMoveDown = new Button(composite_1, 0);
        this.btnMoveDown.setImage(Images.List_Movedown.getImage());
        this.btnMoveDown.addSelectionListener((SelectionListener)this);
        this.btnMoveDown.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        Button customizeTools = new Button(composite_1, 0);
        customizeTools.setText("Customize Tools Locations...");
        customizeTools.setLayoutData((Object)GridDataFactory.defaultsFor((Control)customizeTools).span(4, 1).align(0x1000008, 0x1000000).create());
        customizeTools.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteConnectionToolkitWizardPage.this.customizeTools();
            }
        });
        IToolkitProperties[] iToolkitPropertiesArray = this.props;
        int n = this.props.length;
        int n2 = 0;
        while (n2 < n) {
            IToolkitProperties properties = iToolkitPropertiesArray[n2];
            properties.createControl(composite_1);
            ++n2;
        }
        new Label(parent, 0).setLayoutData((Object)GridDataFactory.defaultsFor((Control)lblCudagdbLocation).span(4, 1).create());
        this.connectionStateLabel = new ConnectionStateLabel(composite_1, this.context, this.property);
        this.setBindings();
    }

    protected void customizeTools() {
        new WizardDialog(this.getShell(), (IWizard)new CustomToolsWizard(this.getToolkit(), (IRemoteConnection)this.context.getProperty(this.property))).open();
    }

    protected void deletePath() {
        CudaToolkitWorkingCopy toolkit = this.internalGetToolkit();
        Object element = ((IStructuredSelection)this.libraryPaths.getSelection()).getFirstElement();
        if (toolkit != null && element instanceof String) {
            String nextSelection = (String)CoreUtil.pickNextSelection((Object[])toolkit.getLibraryPath(), (Object)((String)element));
            toolkit.removeLibraryPath((String)element);
            this.postLibraryPathSelection(nextSelection);
        }
    }

    protected void detectToolkits() {
        try {
            IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
            if (connection != null) {
                DetectRemoteToolkits toolkits = new DetectRemoteToolkits(connection);
                this.context.run(true, true, (IRunnableWithProgress)toolkits);
                if (toolkits.getStatus().isOK()) {
                    Map<String, String[]> dirs = toolkits.getBinDirs();
                    this.detected.clear();
                    this.detected.putAll(dirs);
                    String path = (String)this.locationObservable.getValue();
                    Map map = (Map)this.context.getProperty(PROPERTY_DISCOVERED_TOOLKITS);
                    String[] array = dirs.keySet().toArray(new String[map.size()]);
                    map.put(connection.getName(), array);
                    if (CoreUtil.isNullOrEmpty((String)path) && array.length > 0) {
                        path = array[0];
                    }
                    this.locationObservable.setValue((Object)path);
                } else {
                    StatusManager.getManager().handle(toolkits.getStatus(), 3);
                }
            }
        }
        catch (InvocationTargetException e) {
            Activator.log(e);
        }
        catch (InterruptedException e) {
            Activator.log(e);
        }
    }

    protected void editPath() {
        ISelection selection = this.libraryPaths.getSelection();
        Object selected = PLACEHOLDER;
        if (!selection.isEmpty()) {
            selected = ((IStructuredSelection)selection).getFirstElement();
        }
        this.libraryPaths.editElement(selected, 0);
    }

    private String[] filterNonexistent(IRemoteConnection connection, String[] paths, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Validating library path", (int)(paths.length * 30));
        LinkedList<String> linkedList = new LinkedList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (connection.isDirectory(path, (IProgressMonitor)subMonitor.newChild(30))) {
                linkedList.add(path);
            }
            ++n2;
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    public void focusGained(FocusEvent e) {
        if (e.widget == this.location || e.widget == this.comboLocation) {
            this.locationFocusIn();
        }
    }

    public void focusLost(FocusEvent e) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Control focusControl = RemoteConnectionToolkitWizardPage.this.getShell().getDisplay().getFocusControl();
                if (focusControl != RemoteConnectionToolkitWizardPage.this.location && focusControl != RemoteConnectionToolkitWizardPage.this.btnBrowse && focusControl != RemoteConnectionToolkitWizardPage.this.btnDetect) {
                    RemoteConnectionToolkitWizardPage.this.locationFocusOut((String)RemoteConnectionToolkitWizardPage.this.locationObservable.getValue());
                }
            }
        });
    }

    protected Object[] getLibraryPaths(String[] inputElement) {
        Object[] newArray = Arrays.copyOf(inputElement, inputElement.length + 1, Object[].class);
        newArray[newArray.length - 1] = PLACEHOLDER;
        return newArray;
    }

    private String[] getPaths(String cudaGdbServerPath) {
        Path path;
        if (this.detected.containsKey(cudaGdbServerPath)) {
            return this.detected.get(cudaGdbServerPath);
        }
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
        if (!CoreUtil.isNullOrEmpty((String)cudaGdbServerPath) && (path = new Path(cudaGdbServerPath)).segmentCount() > 2) {
            IPath basePath = path.removeLastSegments(1);
            String lib = basePath.append("lib").toString();
            if (!connection.isConnected(IRemoteConnection.Service.Files) || connection.isDirectory(lib, (IProgressMonitor)new NullProgressMonitor())) {
                String lib64 = basePath.append("lib64").toString();
                if (!connection.isConnected(IRemoteConnection.Service.Files) || connection.isDirectory(lib, (IProgressMonitor)new NullProgressMonitor())) {
                    return new String[]{lib64, lib};
                }
                return new String[]{lib};
            }
        }
        return null;
    }

    public CudaToolkitWorkingCopy getToolkit() {
        if (this.libraryPaths != null && this.libraryPaths.isCellEditorActive()) {
            ((RemotePathCellEditor)this.libraryPaths.getCellEditors()[0]).apply();
        }
        return this.internalGetToolkit();
    }

    private CudaToolkitWorkingCopy internalGetToolkit() {
        return (CudaToolkitWorkingCopy)((Object)this.toolkit.getValue());
    }

    private boolean isConnected(IRemoteConnection connection) {
        return connection != null && connection.isConnected(IRemoteConnection.Service.Files);
    }

    private boolean isValidCudaGdbserver(String newServerPath) {
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
        return !CoreUtil.isNullOrEmpty((String)newServerPath) && (connection == null || !connection.isConnected(IRemoteConnection.Service.Files) || connection.isFile(new Path(newServerPath).append(this.app).toString(), true, (IProgressMonitor)new NullProgressMonitor()));
    }

    private Font italicFont() {
        if (italic == null || italic.isDisposed()) {
            Table t = this.libraryPaths.getTable();
            Font font = t.getFont();
            FontData fontData = font.getFontData()[0];
            italic = new Font((Device)t.getDisplay(), fontData.getName(), fontData.getHeight(), 2 | fontData.getStyle());
        }
        return italic;
    }

    protected void locationFocusIn() {
        this.originalPath = this.location.getText();
    }

    protected void locationFocusOut(String newPath) {
        if (!CoreUtil.equals((Object)newPath, (Object)this.originalPath) && this.isValidCudaGdbserver(newPath)) {
            Object[] oldPaths = this.getPaths(this.originalPath);
            Object[] newPaths = this.getPaths(newPath);
            this.originalPath = newPath;
            if (!CoreUtil.isNullOrEmpty((Object[])newPaths) && !CoreUtil.equalsIgnoringOrder((Object[])oldPaths, (Object[])newPaths) && MessageDialog.openConfirm((Shell)this.getShell(), (String)"CUDA Toolkit Library Path", (String)"Do you want to update your toolkit library path with defaults based on the new toolkit location?")) {
                final IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
                if (connection != null && connection.isConnected(IRemoteConnection.Service.Files)) {
                    try {
                        this.getContainer().run(true, false, new IRunnableWithProgress((String[])newPaths, (String[])oldPaths){
                            private final /* synthetic */ String[] val$newPaths;
                            private final /* synthetic */ String[] val$oldPaths;
                            {
                                this.val$newPaths = stringArray;
                                this.val$oldPaths = stringArray2;
                            }

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                final String[] filtered = RemoteConnectionToolkitWizardPage.this.filterNonexistent(connection, this.val$newPaths, monitor);
                                RemoteConnectionToolkitWizardPage.this.context.getRealm().exec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RemoteConnectionToolkitWizardPage.this.internalGetToolkit().replacePaths(val$oldPaths, filtered);
                                    }
                                });
                            }
                        });
                        SWTUtil.updateTitle((WizardPage)this, (IStatus)this.validate());
                    }
                    catch (InvocationTargetException e) {
                        Activator.log(e);
                        this.internalGetToolkit().replacePaths((String[])oldPaths, (String[])newPaths);
                    }
                    catch (InterruptedException e) {
                        Activator.log(e);
                        this.internalGetToolkit().replacePaths((String[])oldPaths, (String[])newPaths);
                    }
                } else {
                    this.internalGetToolkit().replacePaths((String[])oldPaths, (String[])newPaths);
                }
            }
        }
    }

    private void movePath(int direction) {
        Object[] paths;
        CudaToolkitWorkingCopy toolkit = this.internalGetToolkit();
        Object selected = ((IStructuredSelection)this.libraryPaths.getSelection()).getFirstElement();
        if (toolkit != null && selected instanceof String && (paths = toolkit.getLibraryPath()) != null) {
            String path = (String)selected;
            int i = CoreUtil.indexOf((Object[])paths, (Object)path);
            int newIndex = i + direction;
            if (i >= 0 && newIndex >= 0 && newIndex < paths.length) {
                toolkit.swapLibraryPaths(i, newIndex);
            }
        }
    }

    protected void pathDown() {
        this.movePath(1);
    }

    protected void pathUp() {
        this.movePath(-1);
    }

    private void postLibraryPathSelection(String selection) {
        StructuredSelection sel = selection != null ? new StructuredSelection((Object)selection) : StructuredSelection.EMPTY;
        this.libraryPaths.getControl().getDisplay().asyncExec(new Runnable((IStructuredSelection)sel){
            private final /* synthetic */ IStructuredSelection val$sel;
            {
                this.val$sel = iStructuredSelection;
            }

            @Override
            public void run() {
                RemoteConnectionToolkitWizardPage.this.libraryPaths.setSelection((ISelection)this.val$sel);
            }
        });
    }

    private void setBindings() {
        DataBindingContext bindingContext = new DataBindingContext(SWTObservables.getRealm((Display)this.getContainer().getShell().getDisplay()));
        this.locationObservable = BeansObservables.observeDetailValue((IObservableValue)this.toolkit, (String)"binDirectory", String.class);
        bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.location, (int)24), this.locationObservable);
        bindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.comboLocation), this.locationObservable);
        bindingContext.bindValue((IObservableValue)new DetectedToolkitsTargetObservable(), (IObservableValue)new DetectedToolkitsObservable(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)this.comboLocation), (IObservableValue)new LocationComboObserver(), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
        this.libraryPathsObservable = BeansObservables.observeDetailValue((IObservableValue)this.toolkit, (String)"libraryPath", Object.class);
        bindingContext.bindValue(ViewersObservables.observeInput((Viewer)this.libraryPaths), this.libraryPathsObservable);
        IToolkitProperties[] iToolkitPropertiesArray = this.props;
        int n = this.props.length;
        int n2 = 0;
        while (n2 < n) {
            IToolkitProperties properties = iToolkitPropertiesArray[n2];
            properties.bind(bindingContext, this.context.observeProperty(this.property));
            ++n2;
        }
        DataBindingUtil.bindEnablement((DataBindingContext)bindingContext, (IObservableValue)this.toolkit, (Control[])new Control[]{this.location, this.btnBrowse, this.btnDetect, this.libraryPaths.getControl(), this.btnBrowseLibrary});
        IViewerObservableValue selectedPath = ViewersObservables.observeSingleSelection((Viewer)this.libraryPaths);
        DataBindingUtil.bindEnablement((DataBindingContext)bindingContext, (IObservableValue)selectedPath, (IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                return fromObject instanceof String;
            }
        }, (Control[])new Control[]{this.btnDelete});
        bindingContext.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.btnMoveDown), (IObservableValue)new EnablementObservable(this.libraryPathsObservable, (IObservableValue)selectedPath, false));
        bindingContext.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.btnMoveUp), (IObservableValue)new EnablementObservable(this.libraryPathsObservable, (IObservableValue)selectedPath, true));
        bindingContext.bindValue((IObservableValue)new PageTitleStatusObservable((WizardPage)this), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                return RemoteConnectionToolkitWizardPage.this.validate();
            }
        }, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        this.connectionStateLabel.bind(bindingContext);
    }

    protected IStatus validate() {
        IRemoteConnection connection = (IRemoteConnection)this.context.getProperty(this.property);
        if (connection == null) {
            return CoreUtil.errorStatus((String)"Remote system was not selected", (Object[])new Object[0]);
        }
        String path = (String)this.locationObservable.getValue();
        if (CoreUtil.isNullOrEmpty((String)path)) {
            return CoreUtil.errorStatus((String)"Toolkit binaries path was not specified", (Object[])new Object[0]);
        }
        if (connection.isConnected(IRemoteConnection.Service.Files)) {
            IStatus cudagdbserver = this.checkFiles(true, true, "'%s' does not exist", new Path(path).append(this.app).toString());
            if (cudagdbserver.getSeverity() != 4) {
                return CoreUtil.getMostSevereStatus((IStatus[])new IStatus[]{cudagdbserver, this.checkFiles(false, false, "'%s' is not a valid path", (String[])this.libraryPathsObservable.getValue())});
            }
            return cudagdbserver;
        }
        return CoreUtil.OK_STATUS;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.btnBrowse) {
            this.browseForToolkit();
        } else if (e.widget == this.btnDetect) {
            this.detectToolkits();
        } else if (e.widget == this.btnBrowseLibrary) {
            this.browseLibraryPath();
        } else if (e.widget == this.btnDelete) {
            this.deletePath();
        } else if (e.widget == this.btnMoveUp) {
            this.pathUp();
        } else if (e.widget == this.btnMoveDown) {
            this.pathDown();
        } else {
            Activator.log("Unknown button: %s", ((Button)e.widget).getText());
        }
    }

    private final class DetectedToolkitsObservable
    extends ComputedValue {
        private DetectedToolkitsObservable() {
        }

        protected Object calculate() {
            IRemoteConnection connection = (IRemoteConnection)RemoteConnectionToolkitWizardPage.this.context.getProperty(RemoteConnectionToolkitWizardPage.this.property);
            if (connection != null) {
                return ((ObservableMap)RemoteConnectionToolkitWizardPage.this.context.getProperty(PROPERTY_DISCOVERED_TOOLKITS)).get((Object)connection.getName());
            }
            return null;
        }
    }

    private final class DetectedToolkitsTargetObservable
    extends AbstractObservableValue {
        private DetectedToolkitsTargetObservable() {
        }

        protected Object doGetValue() {
            return null;
        }

        protected void doSetValue(Object value) {
            if (value != null) {
                String text = RemoteConnectionToolkitWizardPage.this.comboLocation.getText();
                RemoteConnectionToolkitWizardPage.this.comboLocation.setItems((String[])value);
                if (!CoreUtil.isNullOrEmpty((String)text)) {
                    RemoteConnectionToolkitWizardPage.this.comboLocation.setText(text);
                }
                RemoteConnectionToolkitWizardPage.this.pbLocation.showPage((Control)RemoteConnectionToolkitWizardPage.this.comboLocation);
            } else {
                RemoteConnectionToolkitWizardPage.this.pbLocation.showPage((Control)RemoteConnectionToolkitWizardPage.this.location);
            }
            RemoteConnectionToolkitWizardPage.this.pbLocation.getParent().layout();
        }

        public Object getValueType() {
            return String[].class;
        }
    }

    private static class EnablementObservable
    extends ComputedValue {
        private final IObservableValue array;
        private final boolean isUp;
        private final IObservableValue selection;

        public EnablementObservable(IObservableValue array, IObservableValue selection, boolean isUp) {
            super(Boolean.TYPE);
            this.array = array;
            this.selection = selection;
            this.isUp = isUp;
        }

        protected Object calculate() {
            Object selected;
            Object[] value = (String[])this.array.getValue();
            if (value != null && (selected = this.selection.getValue()) instanceof String) {
                int i = CoreUtil.indexOf((Object[])value, (Object)((String)selected));
                if (i >= 0 && (this.isUp ? i > 0 : i < value.length - 1)) {
                    return true;
                }
                return false;
            }
            return false;
        }
    }

    private final class LibraryPathCellModifier
    implements ICellModifier {
        private LibraryPathCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return element instanceof String ? (String)element : "";
        }

        public void modify(Object element, String property, Object value) {
            CudaToolkitWorkingCopy toolkit = RemoteConnectionToolkitWizardPage.this.internalGetToolkit();
            if (toolkit != null && element != null) {
                String selection;
                Object data = ((TableItem)element).getData();
                String newPath = (String)value;
                if (data instanceof String) {
                    if (CoreUtil.isNullOrEmpty((String)newPath)) {
                        selection = (String)CoreUtil.pickNextSelection((Object[])toolkit.getLibraryPath(), (Object)((String)data));
                        toolkit.removeLibraryPath((String)data);
                    } else {
                        toolkit.replaceLibraryPath((String)data, newPath);
                        selection = null;
                    }
                } else if (!CoreUtil.isNullOrEmpty((String)newPath)) {
                    toolkit.addLibraryPath(newPath);
                    selection = newPath;
                } else {
                    selection = null;
                }
                if (selection != null) {
                    RemoteConnectionToolkitWizardPage.this.postLibraryPathSelection(selection);
                }
            }
        }
    }

    private final class LibraryPathsContentProvider
    extends CellLabelProvider {
        private LibraryPathsContentProvider() {
        }

        public void update(ViewerCell cell) {
            Font font;
            Image image;
            String text;
            Object element = cell.getElement();
            if (element instanceof String) {
                text = element.toString();
                image = SWTUtil.getImage((String)"IMG_OBJ_FOLDER");
                font = null;
            } else {
                text = "Add new path";
                image = SWTUtil.getImage((String)"IMG_OBJ_ADD");
                font = RemoteConnectionToolkitWizardPage.this.italicFont();
            }
            cell.setText(text);
            cell.setImage(image);
            cell.setFont(font);
        }
    }

    public class LocationComboObserver
    extends AbstractObservableValue {
        protected Object doGetValue() {
            return null;
        }

        protected void doSetValue(Object value) {
            if (RemoteConnectionToolkitWizardPage.this.detected.containsKey(value)) {
                RemoteConnectionToolkitWizardPage.this.internalGetToolkit().replacePaths(null, (String[])RemoteConnectionToolkitWizardPage.this.detected.get(value));
                RemoteConnectionToolkitWizardPage.this.locationFocusIn();
            }
            super.doSetValue(value);
        }

        public Object getValueType() {
            return String.class;
        }
    }
}

