/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.connection;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.RemoteUtil;
import com.nvidia.cuda.ide.remote.internal.connection.Activator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IShellService;

public abstract class ShellOutputFilter
implements IHostShellOutputListener {
    private static final Pattern ECHO_COMMAND_ECHO_PATTERN = Pattern.compile(".*echo -n.*");
    public static final String END_MARKER = ">>>>> NSIGHT";
    private static final int MAX_COMMAND_STRING_LENGTH = 3000;
    private static final Pattern SHELL_READY_PATTERN = Pattern.compile(".*>$");
    public static final String START_MARKER = "<<<<< NSIGHT";
    private final Queue<String> ignored = new ConcurrentLinkedQueue<String>();
    protected final AtomicLong lastMessageTimestamp = new AtomicLong(0L);
    private final IHostShell shell;
    private State state = State.IGNORING_INPUT;
    private Pattern waitFor = null;

    public ShellOutputFilter(IHostShell shell) {
        this.shell = shell;
        shell.getStandardOutputReader().addOutputListener((IHostShellOutputListener)this);
    }

    public ShellOutputFilter(IShellService shellService, IProgressMonitor monitor) throws SystemMessageException {
        this(shellService.launchShell("", new String[0], monitor));
    }

    private String decorateCommand(String command, boolean rmMyself) {
        return "echo " + RemoteUtil.quote(START_MARKER) + ";" + command + ";" + this.postRunCommands(rmMyself);
    }

    public void exit() {
        this.shell.exit();
    }

    public IHostShell getShell() {
        return this.shell;
    }

    public void ignore(String s) {
        if (s.endsWith("\n")) {
            this.ignored.add(s.substring(0, s.length() - 1));
            this.ignored.add("");
        } else {
            this.ignored.add(s);
        }
    }

    protected abstract void inputEnd();

    protected boolean isLastLine(String string) {
        if (string.endsWith(END_MARKER)) {
            int prefixLength = string.length() - END_MARKER.length();
            if (prefixLength > 0) {
                this.stringReceived(string.substring(0, prefixLength));
            }
            this.inputEnd();
            return true;
        }
        return false;
    }

    protected String postRunCommands(boolean rmMyself) {
        return "echo " + RemoteUtil.quote(END_MARKER);
    }

    protected State processApplicationOutput(String string) {
        boolean inputEndEncountered = this.isLastLine(string);
        if (!inputEndEncountered) {
            if (this.ignored.isEmpty() || !this.ignored.poll().equals(string)) {
                this.stringReceived(string);
            }
            return State.PROCESSING_INPUT;
        }
        this.inputEnd();
        return State.IGNORING_INPUT;
    }

    protected State processBeforeApplicationInput(String input) {
        return input.equals(START_MARKER) ? State.PROCESSING_INPUT : State.IGNORING_INPUT;
    }

    protected State processInput(String input) {
        switch (this.state) {
            case IGNORING_INPUT: {
                return this.processBeforeApplicationInput(input);
            }
            case PROCESSING_INPUT: {
                return this.processApplicationOutput(input);
            }
        }
        throw new IllegalArgumentException(this.state.name());
    }

    protected final void run(String command) {
        if (command.length() > 3000) {
            String completeCommand = this.decorateCommand(command, true);
            this.runWithShellScript(completeCommand);
        } else {
            this.shell.writeToShell(this.decorateCommand(command, false));
        }
    }

    private synchronized void runWithShellScript(String completeCommand) {
        this.waitForConsole(SHELL_READY_PATTERN, 2000);
        String filename = String.format("/tmp/nsight-%h%h", this, completeCommand);
        int length = completeCommand.length();
        int start = 0;
        int end = 3000;
        while (end < length + 3000) {
            String c = end < length ? completeCommand.substring(start, end) : completeCommand.substring(start);
            String echo = String.format("echo -n %s >>%s", RemoteUtil.quote(c), filename);
            String command = String.format("sh -c %s", RemoteUtil.quote(echo));
            this.shell.writeToShell(command);
            this.waitForConsole(ECHO_COMMAND_ECHO_PATTERN, 2000);
            start = end;
            end += 3000;
        }
        this.shell.writeToShell(String.format("sh %s;exit", RemoteUtil.quote(filename)));
    }

    public synchronized void shellOutputChanged(IHostShellChangeEvent event) {
        IHostOutput[] lines;
        this.lastMessageTimestamp.set(System.currentTimeMillis());
        IHostOutput[] iHostOutputArray = lines = event.getLines();
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            IHostOutput line = iHostOutputArray[n2];
            String string = line.getString();
            if (this.waitFor != null && this.waitFor.matcher(string).matches()) {
                this.waitFor = null;
                this.notifyAll();
            }
            if (Activator.TRACE_REMOTE_CONSOLE && !CoreUtil.isNullOrEmpty((String)string)) {
                System.out.printf("[RSERemoteShell::shellOutputChanged] %s\n", string);
            }
            this.state = this.processInput(string);
            ++n2;
        }
    }

    protected abstract void stringReceived(String var1);

    private synchronized void waitForConsole(Pattern pattern, int timeout) {
        try {
            this.waitFor = pattern;
            this.wait(timeout);
            this.waitFor = null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum State {
        IGNORING_INPUT,
        PROCESSING_INPUT;

    }
}

