/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.remote.internal.connection;

import com.nvidia.common.toolkit.ToolkitVersion;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteShell;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;

public final class DetectRemoteToolkits
implements IRunnableWithProgress {
    private static final String COMPILER_DIRS_SEPARATOR = "----------- Library dirs below ------------";
    private final Map<String, String[]> binDirs = new LinkedHashMap<String, String[]>();
    private final IRemoteConnection connection;
    private IStatus status = CoreUtil.OK_STATUS;

    public DetectRemoteToolkits(IRemoteConnection connection) {
        this.connection = connection;
    }

    private void addIfProperToolkit(IRemoteShell shell, String bin) throws CoreException {
        String command;
        String[] paths;
        if (!this.binDirs.containsKey(bin) && !CoreUtil.isNullOrEmpty((String)bin) && (paths = this.getBinAndLibPaths(shell.run(command = String.format("(test -x \"%1$s/nvcc\" -a '!' -h \"%2$s\" && (\"%1$s/nvcc\" --version;echo \"----------- Library dirs below ------------\";ls -df1 \"%2$s/lib64\" \"%2$s/lib\" 2>/dev/null))", bin, new Path(bin).removeLastSegments(1).toString()), 15000, (IProgressMonitor)new NullProgressMonitor()))) != null) {
            this.binDirs.put(bin, paths);
        }
    }

    private void findNvccOnPath(IRemoteShell shell) throws CoreException {
        String[] path = shell.run("bash -i which nvcc", 15000, (IProgressMonitor)new NullProgressMonitor());
        if (path.length == 1) {
            this.addIfProperToolkit(shell, new Path(path[0]).removeLastSegments(1).toString());
        }
    }

    public Map<String, String[]> getBinDirs() {
        return this.binDirs;
    }

    public IStatus getStatus() {
        return this.status;
    }

    private String[] getBinAndLibPaths(String[] output) {
        boolean is55 = false;
        boolean paths = false;
        LinkedList<String> libraryPaths = new LinkedList<String>();
        String[] stringArray = output;
        int n = output.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            if (ToolkitVersion.current.matches(message)) {
                is55 = true;
            } else if (COMPILER_DIRS_SEPARATOR.equals(message)) {
                paths = true;
            } else if (paths) {
                libraryPaths.add(message);
            }
            ++n2;
        }
        return is55 ? libraryPaths.toArray(new String[libraryPaths.size()]) : null;
    }

    /*
     * Unable to fully structure code
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block11: {
            m = monitor == null ? new NullProgressMonitor() : monitor;
            m.beginTask("Detecting available toolkits", -1);
            if (m.isCanceled()) {
                return;
            }
            try {
                shell = this.connection.openShell((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                this.status = CoreUtil.errorStatus((Throwable)e, (String)"Unable to establish shell connection to \"%s\"", (Object[])new Object[]{this.connection.getName()});
                return;
            }
            if (m.isCanceled()) {
                return;
            }
            this.findNvccOnPath(shell);
            if (!m.isCanceled()) break block11;
            this.binDirs.clear();
lbl17:
            // 2 sources

            while (true) {
                shell.close();
                return;
            }
        }
        try {
            try {
                this.addIfProperToolkit(shell, ToolkitVersion.current.defaultBinPath);
                if (m.isCanceled()) {
                    this.binDirs.clear();
                    ** continue;
                }
                this.addIfProperToolkit(shell, "/usr/local/cuda/bin");
            }
            catch (CoreException e) {
                this.status = CoreUtil.errorStatus((Throwable)e, (String)"Unable to execute shell commands", (Object[])new Object[0]);
                shell.close();
            }
        }
        catch (Throwable var5_6) {
            shell.close();
            throw var5_6;
        }
        shell.close();
        m.done();
    }
}

