/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.cygwin;

import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.gnu.cygwin.CygwinPathResolver;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;

public class GnuCygwinConfigurationEnvironmentSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static final String PATH = "PATH";
    private static final String DELIMITER_UNIX = ":";
    private static final String PROPERTY_DELIMITER = "path.separator";
    private static final String PROPERTY_OSNAME = "os.name";
    private static final String LANG = "LANG";
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_MESSAGES = "LC_MESSAGES";

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (variableName == null) {
            return null;
        }
        if (!System.getProperty(PROPERTY_OSNAME).toLowerCase().startsWith("windows ")) {
            return null;
        }
        if (variableName.equalsIgnoreCase(PATH)) {
            String p = CygwinPathResolver.getBinPath();
            if (p != null) {
                return new BuildEnvVar(PATH, p.replace('/', '\\'), 3, System.getProperty(PROPERTY_DELIMITER, DELIMITER_UNIX));
            }
        } else if (variableName.equalsIgnoreCase(LANG)) {
            String langValue = System.getenv(LANG);
            if (langValue == null || langValue.length() == 0) {
                langValue = System.getenv(LC_ALL);
            }
            if (langValue == null || langValue.length() == 0) {
                langValue = System.getenv(LC_MESSAGES);
            }
            langValue = langValue != null && langValue.length() > 0 ? langValue.replaceFirst("([^.@]*)(\\..*)?(@.*)?", "$1.ISO-8859-1") : "C.ISO-8859-1";
            return new BuildEnvVar(LANG, langValue);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable varLang = this.getVariable(LANG, configuration, provider);
        IBuildEnvironmentVariable varPath = this.getVariable(PATH, configuration, provider);
        if (varPath != null) {
            return new IBuildEnvironmentVariable[]{varLang, varPath};
        }
        return new IBuildEnvironmentVariable[]{varLang};
    }
}

