/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.ICollectionConditionalExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.util.DirectedGraph;
import org.eclipse.birt.data.engine.impl.util.DirectedGraphEdge;
import org.eclipse.birt.data.engine.impl.util.GraphNode;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapExpressionCompiler {
    public static String getReferencedScriptObject(IBaseExpression expr, String objectName) {
        Collection<IScriptExpression> testExpr;
        if (expr == null || "constant".equals(expr.getScriptId())) {
            return null;
        }
        if (expr instanceof IScriptExpression) {
            return OlapExpressionCompiler.getReferencedScriptObject((IScriptExpression)expr, objectName);
        }
        if (expr instanceof IConditionalExpression) {
            String dimName = null;
            IScriptExpression expr1 = ((IConditionalExpression)expr).getExpression();
            dimName = OlapExpressionCompiler.getReferencedScriptObject(expr1, objectName);
            if (dimName != null) {
                return dimName;
            }
            IBaseExpression op1 = ((IConditionalExpression)expr).getOperand1();
            dimName = OlapExpressionCompiler.getReferencedScriptObject(op1, objectName);
            if (dimName != null) {
                return dimName;
            }
            IBaseExpression op2 = ((IConditionalExpression)expr).getOperand2();
            dimName = OlapExpressionCompiler.getReferencedScriptObject(op2, objectName);
            return dimName;
        }
        if (expr instanceof IExpressionCollection) {
            IExpressionCollection combinedExpr = (IExpressionCollection)expr;
            Object[] exprs = combinedExpr.getExpressions().toArray();
            int i = 0;
            while (i < exprs.length) {
                String o = OlapExpressionCompiler.getReferencedScriptObject((IBaseExpression)exprs[i], objectName);
                if (o != null) {
                    return o;
                }
                ++i;
            }
        } else if (expr instanceof ICollectionConditionalExpression && (testExpr = ((ICollectionConditionalExpression)((Object)expr)).getExpr()).size() > 0) {
            return OlapExpressionCompiler.getReferencedScriptObject(testExpr.iterator().next(), objectName);
        }
        return null;
    }

    private static String getReferencedScriptObject(IScriptExpression expr, String objectName) {
        if (expr == null) {
            return null;
        }
        return OlapExpressionCompiler.getReferencedScriptObject(expr.getText(), objectName);
    }

    public static String getReferencedScriptObject(String expr, String objectName) {
        if (expr == null) {
            return null;
        }
        try {
            Context cx = Context.enter();
            CompilerEnvirons ce = new CompilerEnvirons();
            Parser p = new Parser(ce, cx.getErrorReporter());
            ScriptOrFnNode tree = p.parse(expr, null, 0);
            String string = OlapExpressionCompiler.getScriptObjectName((Node)tree, objectName);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
        finally {
            Context.exit();
        }
    }

    public static Set getReferencedDimLevel(IBaseExpression expr, List bindings) throws DataException {
        return OlapExpressionCompiler.getReferencedDimLevel(expr, bindings, false);
    }

    public static Set getReferencedDimLevel(IBaseExpression expr, List bindings, boolean onlyFromDirectReferenceExpr) throws DataException {
        if (expr instanceof IScriptExpression) {
            return OlapExpressionCompiler.getReferencedDimLevel((IScriptExpression)expr, bindings, onlyFromDirectReferenceExpr);
        }
        if (expr instanceof IConditionalExpression) {
            IBaseExpression op2;
            HashSet result = new HashSet();
            IScriptExpression expr1 = ((IConditionalExpression)expr).getExpression();
            result.addAll(OlapExpressionCompiler.getReferencedDimLevel(expr1, bindings, onlyFromDirectReferenceExpr));
            IBaseExpression op1 = ((IConditionalExpression)expr).getOperand1();
            if (op1 != null) {
                result.addAll(OlapExpressionCompiler.getReferencedDimLevel(op1, bindings, onlyFromDirectReferenceExpr));
            }
            if ((op2 = ((IConditionalExpression)expr).getOperand2()) != null) {
                result.addAll(OlapExpressionCompiler.getReferencedDimLevel(op2, bindings, onlyFromDirectReferenceExpr));
            }
            return result;
        }
        if (expr instanceof IExpressionCollection) {
            HashSet result = new HashSet();
            Object[] ops = ((IExpressionCollection)expr).getExpressions().toArray();
            int i = 0;
            while (i < ops.length) {
                result.addAll(OlapExpressionCompiler.getReferencedDimLevel((IBaseExpression)ops[i], bindings, onlyFromDirectReferenceExpr));
                ++i;
            }
            return result;
        }
        return Collections.EMPTY_SET;
    }

    private static Set getReferencedDimLevel(IScriptExpression expr, List bindings, boolean onlyFromDirectReferenceExpr) throws DataException {
        if (expr == null || expr.getText() == null || expr.getText().length() == 0 || "constant".equals(expr.getScriptId())) {
            return new HashSet();
        }
        try {
            HashSet result = new HashSet();
            Context cx = Context.enter();
            CompilerEnvirons ce = new CompilerEnvirons();
            Parser p = new Parser(ce, cx.getErrorReporter());
            ScriptOrFnNode tree = p.parse(expr.getText(), null, 0);
            OlapExpressionCompiler.populateDimLevels(null, (Node)tree, result, bindings, onlyFromDirectReferenceExpr);
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            Context.exit();
        }
    }

    private static void populateDimLevels(Node grandpa, Node n, Set result, List bindings, boolean onlyFromDirectReferenceExpr) throws DataException {
        if (n == null) {
            return;
        }
        if (onlyFromDirectReferenceExpr && n.getType() == 135) {
            if (n.getFirstChild() == null || n.getFirstChild().getType() != 133) {
                return;
            }
            if (n.getFirstChild().getFirstChild() == null || n.getFirstChild().getFirstChild().getType() != 33 && n.getFirstChild().getFirstChild().getType() != 36) {
                return;
            }
        }
        if (n.getFirstChild() != null && (n.getType() == 33 || n.getType() == 36)) {
            if (n.getFirstChild().getFirstChild() != null && (n.getFirstChild().getFirstChild().getType() == 33 || n.getFirstChild().getFirstChild().getType() == 36)) {
                String attr;
                String levelName;
                String dimName;
                DimLevel dimLevel;
                Node dim = n.getFirstChild().getFirstChild();
                if ("dimension".equals(dim.getFirstChild().getString()) && !result.contains(dimLevel = new DimLevel(dimName = dim.getLastChild().getString(), levelName = dim.getNext().getString(), attr = n.getLastChild().getString()))) {
                    result.add(dimLevel);
                }
            } else if (n.getFirstChild() != null && n.getFirstChild().getType() == 39) {
                String bindingName;
                IBinding binding;
                if ("dimension".equals(n.getFirstChild().getString())) {
                    if (n.getLastChild() != null && n.getNext() != null) {
                        DimLevel dimLevel;
                        String dimName = n.getLastChild().getString();
                        String levelName = n.getNext().getString();
                        String attr = null;
                        if (grandpa != null && grandpa.getNext() != null && grandpa.getNext().getType() == 41) {
                            attr = grandpa.getNext().getString();
                        }
                        if (!result.contains(dimLevel = new DimLevel(dimName, levelName, attr))) {
                            result.add(dimLevel);
                        }
                    }
                } else if (("data".equals(n.getFirstChild().getString()) || "row".equals(n.getFirstChild().getString())) && n.getLastChild() != null && (binding = OlapExpressionCompiler.getBinding(bindings, bindingName = n.getLastChild().getString())) != null) {
                    result.addAll(OlapExpressionCompiler.getReferencedDimLevel(binding.getExpression(), bindings, onlyFromDirectReferenceExpr));
                }
            }
        }
        OlapExpressionCompiler.populateDimLevels(grandpa, n.getFirstChild(), result, bindings, onlyFromDirectReferenceExpr);
        if (n.getLastChild() != n.getFirstChild()) {
            OlapExpressionCompiler.populateDimLevels(grandpa, n.getLastChild(), result, bindings, onlyFromDirectReferenceExpr);
        }
        if (n.getNext() != n.getFirstChild() && n.getNext() != n.getLastChild()) {
            OlapExpressionCompiler.populateDimLevels(grandpa, n.getNext(), result, bindings, onlyFromDirectReferenceExpr);
        }
    }

    private static IBinding getBinding(List bindings, String bindingName) throws DataException {
        int i = 0;
        while (i < bindings.size()) {
            if (((IBinding)bindings.get(i)).getBindingName().equals(bindingName)) {
                return (IBinding)bindings.get(i);
            }
            ++i;
        }
        return null;
    }

    private static String getScriptObjectName(Node n, String objectName) {
        if (n == null) {
            return null;
        }
        String result = null;
        if (n.getType() == 39 && objectName.equals(n.getString())) {
            Node dimNameNode = n.getNext();
            if (dimNameNode == null || dimNameNode.getType() != 41) {
                return null;
            }
            return dimNameNode.getString();
        }
        result = OlapExpressionCompiler.getScriptObjectName(n.getFirstChild(), objectName);
        if (result == null) {
            result = OlapExpressionCompiler.getScriptObjectName(n.getLastChild(), objectName);
        }
        if (result == null) {
            result = OlapExpressionCompiler.getScriptObjectName(n.getNext(), objectName);
        }
        return result;
    }

    public static void validateDependencyCycle(Set<IBinding> bindings) throws DataException {
        HashSet<DirectedGraphEdge> edges = new HashSet<DirectedGraphEdge>();
        for (IBinding binding : bindings) {
            List references = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data");
            for (String reference : references) {
                DirectedGraphEdge edge = new DirectedGraphEdge(new GraphNode(binding.getBindingName()), new GraphNode(reference));
                edges.add(edge);
            }
        }
        DirectedGraph dg = new DirectedGraph(edges);
        try {
            dg.validateCycle();
        }
        catch (DirectedGraph.CycleFoundException e) {
            throw new DataException("data.engine.ColumnBindingCycle", e.getNode().getValue());
        }
    }
}

