/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.group;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SimpleSmartCache;
import org.eclipse.birt.data.engine.executor.transform.FilterUtil;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.group.AggrValuesUpdator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfo;
import org.eclipse.birt.data.engine.executor.transform.group.GroupInfoUpdator;
import org.eclipse.birt.data.engine.executor.transform.group.GroupRange;
import org.eclipse.birt.data.engine.executor.transform.group.IncrementalUpdateCaculator;
import org.eclipse.birt.data.engine.odi.IQuery;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.FilterPassController;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalUpdateGroupFilter
extends IncrementalUpdateCaculator {
    private IQuery.GroupSpec[] groupSpecs;
    private FilterPassController filterPassCtrl;
    private ScriptContext scriptCtx;
    private SimpleSmartCache resultSetCache;

    public IncrementalUpdateGroupFilter(ResultSetPopulator populator) throws DataException {
        super(populator);
        this.scriptCtx = this.populator.getSession().getEngineContext().getScriptContext();
        this.groupSpecs = populator.getQuery().getGrouping();
        this.populateFilterExpression();
    }

    public void doFilters() throws DataException {
        if (!this.doFiltering) {
            return;
        }
        int i = 1;
        while (i <= this.groupSpecs.length) {
            List filters = this.groupSpecs[i - 1].getFilters();
            if (filters != null && filters.size() != 0) {
                this.populator.getResultIterator().first(0);
                this.resultSetCache = new SimpleSmartCache(this.populator.getSession(), this.populator.getEventHandler(), this.populator.getResultSetMetadata());
                if (FilterUtil.hasMutipassFilters(filters)) {
                    ArrayList<IFilterDefinition> singlePassFilter = new ArrayList<IFilterDefinition>();
                    ArrayList<IFilterDefinition> multiPassFilter = new ArrayList<IFilterDefinition>();
                    for (Object filter : filters) {
                        if (FilterUtil.isFilterNeedMultiPass((IFilterDefinition)filter)) {
                            multiPassFilter.add((IFilterDefinition)filter);
                            continue;
                        }
                        singlePassFilter.add((IFilterDefinition)filter);
                    }
                    if (singlePassFilter.size() > 0) {
                        this.doSinglePassFilter(i, singlePassFilter);
                        this.setFilteringResults();
                        this.resultSetCache = new SimpleSmartCache(this.populator.getSession(), this.populator.getEventHandler(), this.populator.getResultSetMetadata());
                    }
                    this.doMultiPassFilter(i, multiPassFilter);
                } else {
                    this.doSinglePassFilter(i, filters);
                }
                this.setFilteringResults();
                this.restFilters(filters);
            }
            ++i;
        }
        this.populator.getResultIterator().first(0);
    }

    private void restFilters(List<IFilterDefinition> filters) {
        int j = 0;
        while (j < filters.size()) {
            IFilterDefinition fd = filters.get(j);
            if (FilterUtil.isFilterNeedMultiPass(fd)) {
                fd.getExpression().setHandle(null);
            }
            ++j;
        }
    }

    private void populateFilterExpression() throws DataException {
        ArrayList<Integer> levelList = new ArrayList<Integer>();
        ArrayList<IBaseExpression> exprsList = new ArrayList<IBaseExpression>();
        int i = 0;
        while (i < this.groupSpecs.length) {
            List groupFilters = this.groupSpecs[i].getFilters();
            if (groupFilters != null) {
                String name = this.groupSpecs[i].getName();
                int j = 0;
                while (j < groupFilters.size()) {
                    if (!((IFilterDefinition)groupFilters.get(j)).updateAggregation()) {
                        IBaseExpression expr = ((IFilterDefinition)groupFilters.get(j)).getExpression();
                        expr.setGroupName(name);
                        exprsList.add(expr);
                        levelList.add(i + 1);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (exprsList.size() > 0) {
            this.doFiltering = true;
            this.populator.getGroupProcessorManager().setExpressionProcessor(this.populator.getExpressionProcessor());
            this.populator.getGroupProcessorManager().calculateExpressionList(exprsList, levelList, 3);
            this.filterPassCtrl = new FilterPassController();
        }
    }

    private void seekToGroup(int groupLevel, int groupIdx) throws DataException {
        this.populator.getResultIterator().first(0);
        int i = 0;
        while (i < groupIdx) {
            this.populator.getResultIterator().last(groupLevel);
            this.populator.getResultIterator().next();
            ++i;
        }
    }

    private void doSinglePassFilter(int level, List<IFilterDefinition> filters) throws DataException {
        this.doFilterPass(level, filters, this.groupSize[level - 1]);
    }

    private void doMultiPassFilter(int level, List<IFilterDefinition> filters) throws DataException {
        if (level > 1) {
            int currentGroupIndex = 0;
            int i = 0;
            while (i < this.groupSize[level - 2]) {
                int count = this.groupUpdators[level - 2].getChildCount(i);
                this.filterPassCtrl.setPassLevel(1);
                this.filterPassCtrl.setRowCount(count);
                this.doEvaluatePass(level, filters, count);
                this.filterPassCtrl.setPassLevel(2);
                this.seekToGroup(level, currentGroupIndex);
                this.doFilterPass(level, filters, count);
                this.filterPassCtrl.setPassLevel(0);
                this.filterPassCtrl.setRowCount(-1);
                this.filterPassCtrl.setSecondPassRowCount(0);
                currentGroupIndex += count;
                ++i;
            }
        } else {
            this.filterPassCtrl.setPassLevel(1);
            this.filterPassCtrl.setRowCount(this.groupSize[level - 1]);
            this.doEvaluatePass(level, filters, this.groupSize[level - 1]);
            this.filterPassCtrl.setPassLevel(2);
            this.seekToGroup(level, 0);
            this.doFilterPass(level, filters, this.groupSize[level - 1]);
            this.filterPassCtrl.setPassLevel(0);
            this.filterPassCtrl.setRowCount(-1);
            this.filterPassCtrl.setSecondPassRowCount(0);
        }
    }

    private void doEvaluatePass(int level, List<IFilterDefinition> filters, int count) throws DataException {
        int i = 0;
        while (i < count) {
            this.populator.getResultIterator().last(level);
            this.evaluateFilters(filters);
            this.populator.getResultIterator().next();
            ++i;
        }
    }

    private void doFilterPass(int level, List<IFilterDefinition> filters, int count) throws DataException {
        int i = 0;
        while (i < count) {
            this.populator.getResultIterator().first(level);
            boolean accept = this.evaluateFilters(filters);
            int gIdx = this.getCurrentGroupIndex(level);
            if (accept) {
                this.acceptGroup(level, gIdx);
            } else {
                this.filterGroup(level, gIdx);
            }
            ++i;
        }
    }

    private void setFilteringResults() throws DataException {
        List<GroupInfo>[] currentGroupInfo = this.getGroups();
        this.populator.setCache(this.resultSetCache);
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().setResultSetCache(this.resultSetCache);
        this.populator.getGroupProcessorManager().getGroupCalculationUtil().getGroupInformationUtil().setGroups(currentGroupInfo);
        this.populator.getGroupProcessorManager().setExpressionProcessor(this.populator.getExpressionProcessor());
        this.resultSetCache = null;
        this.populator.getResultIterator().clearAggrValueHolder();
        AggrValuesUpdator[] aggrs = this.aggrValuesUpdators;
        this.aggrValuesUpdators = new AggrValuesUpdator[aggrs.length];
        int i = 0;
        while (i < aggrs.length) {
            this.populator.getResultIterator().addAggrValueHolder(aggrs[i]);
            this.aggrValuesUpdators[i] = new AggrValuesUpdator(aggrs[i], this.populator);
            ++i;
        }
        this.originGroups = currentGroupInfo;
        this.groupSize = new int[this.originGroups.length];
        i = 0;
        while (i < this.originGroups.length) {
            this.groupUpdators[i] = new GroupInfoUpdator(i, this.tempDir, this.originGroups[i], this.getLastGroupIndex(i), this.aggrValuesUpdators);
            this.groupSize[i] = this.originGroups[i].size();
            ++i;
        }
        this.filterPassCtrl.setPassLevel(0);
        this.filterPassCtrl.setRowCount(-1);
        this.filterPassCtrl.setSecondPassRowCount(0);
    }

    private void acceptGroup(int level, int groupIndex) throws DataException {
        this.groupUpdators[level - 1].onGroup(groupIndex);
        GroupRange childChunck = this.groupUpdators[level - 1].getChildRange();
        int i = level - 2;
        while (i >= 0) {
            this.groupUpdators[i].onGroup(this.getCurrentGroupIndex(i + 1));
            --i;
        }
        i = level;
        while (i < this.groupUpdators.length) {
            childChunck = this.groupUpdators[i].acceptGroupRange(childChunck);
            ++i;
        }
        i = childChunck.first;
        while (i < childChunck.length + childChunck.first) {
            assert (i == this.populator.getResultIterator().getCurrentResultIndex());
            IResultObject res = this.populator.getResultIterator().getCurrentResult();
            this.resultSetCache.add(res);
            this.acceptAggrValues(i);
            this.populator.getResultIterator().next();
            ++i;
        }
    }

    private void filterGroup(int level, int groupIndex) throws DataException {
        this.groupUpdators[level - 1].filterGroup(groupIndex);
        GroupRange chunk = this.groupUpdators[level - 1].getChildRange();
        int pRemoved = 1;
        int i = level;
        while (i < this.groupUpdators.length) {
            this.groupUpdators[i].increaseParentIndex(pRemoved);
            pRemoved = chunk.length;
            chunk = this.groupUpdators[i].filterGroupRange(chunk);
            ++i;
        }
        i = level - 2;
        while (i >= 0) {
            if (this.groupUpdators[i].notOnGroup(this.getCurrentGroupIndex(i + 1)) < 0) break;
            if (i < this.groupUpdators.length - 1) {
                this.groupUpdators[i + 1].increaseParentIndex();
            }
            --i;
        }
        this.populator.getResultIterator().last(level);
        this.populator.getResultIterator().next();
    }

    private boolean evaluateFilters(List<IFilterDefinition> filters) throws DataException {
        int j = 0;
        while (j < filters.size()) {
            Object result = this.evaluteFilterExpression(filters.get(j));
            try {
                if (!DataTypeUtil.toBoolean((Object)result).booleanValue()) {
                    return false;
                }
            }
            catch (BirtException e) {
                throw new DataException("data.engine.DataConversionError", e);
            }
            ++j;
        }
        return true;
    }

    private Object evaluteFilterExpression(IFilterDefinition filter) throws DataException {
        IBaseExpression expr = filter.getExpression();
        FilterUtil.prepareFilterExpression(this.tempDir, expr, this.filterPassCtrl, this.populator.getEventHandler().getExecutorHelper());
        Object result = ScriptEvalUtil.evalExpr(expr, this.scriptCtx.newContext((Object)this.populator.getGroupProcessorManager().getExpressionProcessor().getScope()), ScriptExpression.defaultID, 0);
        if (result == null) {
            Object info = null;
            info = expr instanceof IScriptExpression ? ((IScriptExpression)expr).getText() : expr;
            throw new DataException("data.engine.BadFilterExpr", info);
        }
        return result;
    }
}

