/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.aggregation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.cache.BasicCachedList;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.aggregation.IProgressiveAggregationHelper;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.odi.IAggrDefnManager;
import org.eclipse.birt.data.engine.odi.IAggrInfo;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressiveAggregationHelper
implements IProgressiveAggregationHelper {
    private IAggrDefnManager manager;
    private List[] currentRoundAggrValue;
    private Object[][] aggrArgs;
    private int currentAggrCount;
    private Set<String> aggrNames;
    private List<Accumulator> accumulators;
    private Scriptable currentScope;
    private ScriptContext sc;
    private DummyJSResultSetRow jsRow;
    private IExecutorHelper helper;

    public ProgressiveAggregationHelper(IAggrDefnManager manager, String tempDir, Scriptable currentScope, ScriptContext sc, IExecutorHelper helper) throws DataException {
        this.manager = manager;
        this.currentRoundAggrValue = new List[0];
        this.accumulators = new ArrayList<Accumulator>();
        this.sc = sc;
        try {
            this.currentScope = ((IDataScriptEngine)this.sc.getScriptEngine("javascript")).getJSContext(sc).initStandardObjects();
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        this.currentScope.setParentScope(currentScope);
        this.jsRow = new DummyJSResultSetRow();
        this.currentScope.put("row", this.currentScope, (Object)this.jsRow);
        this.currentScope.put("dataSetRow", this.currentScope, (Object)this.jsRow);
        this.populateAggregations(tempDir);
        this.helper = helper;
    }

    private void populateAggregations(String tempDir) throws DataException {
        this.aggrNames = new HashSet<String>();
        this.currentAggrCount = this.manager.getAggrCount();
        if (this.currentAggrCount > 0) {
            this.currentRoundAggrValue = new List[this.currentAggrCount];
            this.aggrArgs = new Object[this.currentAggrCount][];
            int i = 0;
            while (i < this.currentAggrCount) {
                this.currentRoundAggrValue[i] = new BasicCachedList(tempDir, DataEngineSession.getCurrentClassLoader());
                IAggrInfo aggrInfo = this.manager.getAggrDefn(i);
                this.aggrArgs[i] = new Object[aggrInfo.getAggregation().getParameterDefn().length];
                this.aggrNames.add(this.manager.getAggrDefn(i).getName());
                this.accumulators.add(aggrInfo.getAggregation().newAccumulator());
                ++i;
            }
        }
    }

    @Override
    public void onRow(int startingGroupLevel, int endingGroupLevel, IResultObject ro, int currentRowIndex) throws DataException {
        this.jsRow.currentRow = ro;
        int i = 0;
        while (i < this.manager.getAggrCount()) {
            this.onRow(i, startingGroupLevel, endingGroupLevel, ro, currentRowIndex);
            ++i;
        }
    }

    @Override
    public void close() throws DataException {
        this.currentScope.delete("row");
    }

    private void onRow(int aggrIndex, int startingGroupLevel, int endingGroupLevel, IResultObject ro, int currentRowIndex) throws DataException {
        boolean isRunning;
        IAggrInfo aggrInfo = this.getAggrInfo(aggrIndex);
        Accumulator acc = this.accumulators.get(aggrIndex);
        IParameterDefn[] argDefs = aggrInfo.getAggregation().getParameterDefn();
        if (startingGroupLevel <= aggrInfo.getGroupLevel()) {
            acc.start();
        }
        boolean accepted = true;
        if (aggrInfo.getFilter() != null) {
            try {
                Object filterResult = ExprEvaluateUtil.evaluateValue(aggrInfo.getFilter(), currentRowIndex, ro, this.currentScope, this.sc);
                accepted = filterResult == null ? true : DataTypeUtil.toBoolean((Object)filterResult);
            }
            catch (BirtException e) {
                this.currentRoundAggrValue[aggrIndex].add(e);
            }
        }
        if (accepted) {
            IBaseExpression[] arguments = aggrInfo.getArgument();
            if (!this.isFunctionCount(aggrInfo) && arguments == null) {
                DataException e = new DataException("data.engine.WrongNumAggrArgs", aggrInfo.getName());
                this.currentRoundAggrValue[aggrIndex].add(e);
            }
            try {
                int optionalAgrsNum = 0;
                int i = 0;
                while (i < argDefs.length) {
                    if (argDefs[i].isOptional()) {
                        ++optionalAgrsNum;
                    }
                    if (aggrInfo.getArgument() == null || i >= arguments.length + optionalAgrsNum) {
                        throw new DataException("data.aggregation.argumentError", new Object[]{argDefs[i].getName(), aggrInfo.getName()});
                    }
                    if (this.isEmptyAggrArgument(aggrInfo)) {
                        this.aggrArgs[aggrIndex] = null;
                    } else {
                        this.evaluateArgsValue(aggrIndex, aggrInfo, i, argDefs[i], currentRowIndex, ro);
                    }
                    ++i;
                }
                if (aggrInfo.getArgument() == null || !this.isValidArgumentNumber(aggrInfo.getArgument().length, argDefs.length, optionalAgrsNum)) {
                    DataException e = new DataException("data.engine.WrongNumAggrArgs", aggrInfo.getName());
                    this.currentRoundAggrValue[aggrIndex].add(e);
                }
                acc.onRow(this.aggrArgs[aggrIndex]);
            }
            catch (DataException e) {
                this.currentRoundAggrValue[aggrIndex].add(e);
            }
        }
        boolean bl = isRunning = aggrInfo.getAggregation().getType() == 1;
        if (isRunning) {
            Object value = acc.getValue();
            this.currentRoundAggrValue[aggrIndex].add(value);
        }
        if (endingGroupLevel <= aggrInfo.getGroupLevel()) {
            acc.finish();
            if (!isRunning) {
                Object value = acc.getValue();
                this.currentRoundAggrValue[aggrIndex].add(value);
            }
        }
    }

    private boolean isValidArgumentNumber(int aggrArgNumb, int argDefsLength, int optionalNum) {
        return aggrArgNumb >= argDefsLength - optionalNum && aggrArgNumb <= argDefsLength;
    }

    private boolean isEmptyAggrArgument(IAggrInfo aggrInfo) {
        return aggrInfo.getArgument().length == 0 || aggrInfo.getArgument()[0] == null || ((IScriptExpression)aggrInfo.getArgument()[0]).getText() == null || ((IScriptExpression)aggrInfo.getArgument()[0]).getText().trim().length() == 0;
    }

    private boolean isInvalidArgumentNum(IAggrInfo aggrInfo, IParameterDefn[] argDefs) {
        aggrInfo.getArgument();
        return aggrInfo.getArgument() == null || aggrInfo.getArgument().length != argDefs.length && (aggrInfo.getArgument().length != argDefs.length - 1 || !argDefs[0].isOptional());
    }

    private void evaluateArgsValue(int aggrIndex, IAggrInfo aggrInfo, int i, IParameterDefn paramDefn, int currentResultIndex, IResultObject currentRo) throws DataException {
        if (i >= aggrInfo.getArgument().length) {
            return;
        }
        IBaseExpression argExpr = aggrInfo.getArgument()[i];
        if (!paramDefn.isOptional()) {
            if (!this.isFunctionCount(aggrInfo) && this.isEmptyScriptExpression(argExpr)) {
                throw new DataException("data.engine.AggregationBinding.EmptyArgument", new Object[]{paramDefn.getName(), aggrInfo.getName()});
            }
        } else if (argExpr == null || ((IScriptExpression)argExpr).getText() == null || ((IScriptExpression)argExpr).getText().trim().length() == 0) {
            this.aggrArgs[aggrIndex][i] = null;
            return;
        }
        try {
            this.aggrArgs[aggrIndex][i] = ExprEvaluateUtil.evaluateValue(argExpr, currentResultIndex, currentRo, this.currentScope, this.sc);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private boolean isEmptyScriptExpression(IBaseExpression argExpr) {
        IScriptExpression expr = (IScriptExpression)argExpr;
        return expr == null || expr.getText() == null || expr.getText().trim().length() == 0;
    }

    private boolean isFunctionCount(IAggrInfo aggrInfo) {
        return aggrInfo.getAggregation().getParameterDefn().length == 0;
    }

    private IAggrInfo getAggrInfo(int i) throws DataException {
        return this.manager.getAggrDefn(i);
    }

    @Override
    public Object getLatestAggrValue(String name) throws DataException {
        List currentValues = this.currentRoundAggrValue[this.manager.getAggrDefnIndex(name)];
        if (currentValues.isEmpty()) {
            return null;
        }
        return currentValues.get(currentValues.size() - 1);
    }

    @Override
    public Object getAggrValue(String name, IResultIterator ri) throws DataException {
        IAggrInfo aggrInfo = this.manager.getAggrDefn(name);
        if (this.currentRoundAggrValue[this.manager.getAggrDefnIndex(name)].isEmpty()) {
            return this.manager.getAggrDefn(name).getAggregation().getDefaultValue();
        }
        int groupIndex = aggrInfo.getAggregation().getType() == 0 ? (aggrInfo.getGroupLevel() == 0 ? 0 : ri.getCurrentGroupIndex(aggrInfo.getGroupLevel())) : ri.getCurrentResultIndex();
        return this.currentRoundAggrValue[this.manager.getAggrDefnIndex(name)].get(groupIndex);
    }

    @Override
    public List getAggrValues(String name) throws DataException {
        return this.currentRoundAggrValue[this.manager.getAggrDefnIndex(name)];
    }

    @Override
    public boolean hasAggr(String name) throws DataException {
        return this.manager.getAggrDefnIndex(name) != -1;
    }

    @Override
    public Set<String> getAggrNames() throws DataException {
        return this.aggrNames;
    }

    @Override
    public IAggrInfo getAggrInfo(String aggrName) throws DataException {
        if (this.hasAggr(aggrName)) {
            return this.manager.getAggrDefn(aggrName);
        }
        return null;
    }

    private class DummyJSResultSetRow
    extends ScriptableObject {
        private IResultObject currentRow;

        private DummyJSResultSetRow() {
        }

        public Object get(int index, Scriptable start) {
            return this.get(String.valueOf(index), start);
        }

        public Object get(String name, Scriptable start) {
            try {
                if ("_outer".equalsIgnoreCase(name)) {
                    if (ProgressiveAggregationHelper.this.helper.getParent() != null) {
                        return ProgressiveAggregationHelper.this.helper.getParent().getScriptable();
                    }
                    throw Context.reportRuntimeError((String)DataResourceHandle.getInstance().getMessage("data.engine.NoOuterResultsExist"));
                }
                if (this.currentRow != null) {
                    return this.currentRow.getFieldValue(name);
                }
            }
            catch (DataException dataException) {
                return null;
            }
            return null;
        }

        public String getClassName() {
            return "row";
        }
    }
}

