/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultObject
implements IResultObject {
    private IResultClass resultClass;
    private Object[] fields;

    public ResultObject(IResultClass resultClass, Object[] fields) {
        if (resultClass == null || fields == null) {
            throw new NullPointerException("ResultClass and/or fields should not be null.");
        }
        assert (resultClass.getFieldCount() == fields.length);
        this.resultClass = resultClass;
        try {
            if (resultClass.hasAnyTYpe()) {
                int i = 1;
                while (i <= resultClass.getFieldCount()) {
                    if (resultClass.getFieldValueClass(i).getName().equals(DataType.AnyType.class.getName()) && fields[i - 1] != null) {
                        ((ResultClass)resultClass).getFieldMetaData(i).setDataType(fields[i - 1].getClass());
                    }
                    ++i;
                }
            }
            this.fields = resultClass.hasClobOrBlob() ? this.convertClobAndBlob(fields, resultClass.getClobFieldIndexes(), resultClass.getBlobFieldIndexes()) : fields;
        }
        catch (DataException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    private Object[] convertClobAndBlob(Object[] fields, int[] clobIndex, int[] blobIndex) throws DataException {
        int i = 0;
        while (i < clobIndex.length) {
            if (fields[clobIndex[i]] != null && fields[clobIndex[i]] instanceof IClob) {
                fields[clobIndex[i]] = this.getClobValue((IClob)fields[clobIndex[i]]);
            }
            ++i;
        }
        i = 0;
        while (i < blobIndex.length) {
            if (fields[blobIndex[i]] != null && fields[blobIndex[i]] instanceof IBlob) {
                fields[blobIndex[i]] = this.getBlobValue((IBlob)fields[blobIndex[i]]);
            }
            ++i;
        }
        return fields;
    }

    private String getClobValue(IClob clob) throws DataException {
        try {
            int len = (int)clob.length();
            return clob.getSubString(1L, len);
        }
        catch (OdaException e) {
            throw new DataException("data.engine.opencloberror", e);
        }
    }

    private byte[] getBlobValue(IBlob blob) throws DataException {
        try {
            int len = (int)blob.length();
            return blob.getBytes(1L, len);
        }
        catch (OdaException e) {
            throw new DataException("data.engine.openbloberror", e);
        }
    }

    public IResultClass getResultClass() {
        return this.resultClass;
    }

    public Object getFieldValue(String fieldName) throws DataException {
        int fieldIndex = this.resultClass.getFieldIndex(fieldName);
        if (fieldIndex < 1) {
            throw new DataException("data.engine.InvalidFieldName", fieldName);
        }
        return this.getFieldValue(fieldIndex);
    }

    public Object getFieldValue(int fieldIndex) throws DataException {
        return this.fields[fieldIndex - 1];
    }

    public void setCustomFieldValue(String fieldName, Object value) throws DataException {
        int idx = this.resultClass.getFieldIndex(fieldName);
        this.setCustomFieldValue(idx, value);
    }

    public void setCustomFieldValue(int fieldIndex, Object value) throws DataException {
        if (!this.resultClass.isCustomField(fieldIndex)) {
            throw new DataException("data.engine.InvalidCustomFieldIdx", fieldIndex);
        }
        this.fields[fieldIndex - 1] = value;
        if (this.resultClass.getFieldValueClass(fieldIndex).getName().equals(DataType.AnyType.class.getName()) && value != null) {
            ((ResultClass)this.resultClass).getFieldMetaData(fieldIndex).setDataType(value.getClass());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.fields.length * 10);
        int i = 0;
        while (i < this.fields.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.fields[i] == null ? "null" : this.fields[i].toString());
            ++i;
        }
        return buf.toString();
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof IResultObject)) {
            return false;
        }
        IResultObject ob2 = (IResultObject)ob;
        int fieldCount = this.getResultClass().getFieldCount();
        if (fieldCount != ob2.getResultClass().getFieldCount()) {
            return false;
        }
        int i = 0;
        while (i < fieldCount) {
            try {
                Object value1 = this.getFieldValue(i + 1);
                Object value2 = ob2.getFieldValue(i + 1);
                if (CompareUtil.compare(value1, value2) != 0) {
                    return false;
                }
            }
            catch (DataException dataException) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        int i = 0;
        while (i < this.fields.length) {
            result = 37 * result + this.fields[i].hashCode();
            ++i;
        }
        return result;
    }
}

