/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.views.signals;

import java.util.Arrays;
import org.eclipse.cdt.debug.core.model.ICSignal;
import org.eclipse.cdt.debug.internal.ui.CDebugImages;
import org.eclipse.cdt.debug.internal.ui.views.signals.SignalsViewer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.internal.ui.model.elements.ElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreePath;

public class SignalLabelProvider
extends ElementLabelProvider {
    protected String getLabel(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        String[] columns = presentationContext.getColumns();
        int columnIdx = columns != null ? Arrays.asList(columns).indexOf(columnId) : 0;
        String label = this.getColumnText(element, columnIdx);
        return label != null ? label : "";
    }

    protected ImageDescriptor getImageDescriptor(TreePath elementPath, IPresentationContext presentationContext, String columnId) throws CoreException {
        Object element = elementPath.getLastSegment();
        if (element instanceof ICSignal) {
            int columnIdx;
            String[] columns = presentationContext.getColumns();
            int n = columnIdx = columns != null ? Arrays.asList(columns).indexOf(columnId) : 0;
            if (columnIdx == 0) {
                return CDebugImages.DESC_OBJS_SIGNAL;
            }
        }
        return super.getImageDescriptor(elementPath, presentationContext, columnId);
    }

    private String getColumnText(Object element, int columnIndex) {
        if (element instanceof ICSignal) {
            try {
                switch (columnIndex) {
                    case 0: {
                        return ((ICSignal)element).getName();
                    }
                    case 1: {
                        return ((ICSignal)element).isPassEnabled() ? SignalsViewer.YES_VALUE : SignalsViewer.NO_VALUE;
                    }
                    case 2: {
                        return ((ICSignal)element).isStopEnabled() ? SignalsViewer.YES_VALUE : SignalsViewer.NO_VALUE;
                    }
                    case 3: {
                        return ((ICSignal)element).getDescription();
                    }
                }
            }
            catch (DebugException debugException) {}
        }
        return null;
    }
}

