/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.commands;

import java.util.ArrayList;
import org.eclipse.cdt.debug.core.model.ICVariable;
import org.eclipse.cdt.debug.internal.ui.views.memory.AddMemoryBlocks;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

public class ViewMemoryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            ArrayList list = new ArrayList();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof ICVariable)) continue;
                list.add(obj);
            }
            ICVariable[] variables = list.toArray(new ICVariable[list.size()]);
            this.showInMemoryView(variables);
        }
        return null;
    }

    private void showInMemoryView(ICVariable[] variables) {
        try {
            IWorkbenchPage page = CDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewPart newView = page.showView("org.eclipse.debug.ui.MemoryView", null, 1);
            IMemoryRenderingSite memSite = (IMemoryRenderingSite)newView;
            new AddMemoryBlocks().addMemoryBlocksForVariables(variables, memSite);
        }
        catch (ClassCastException e) {
            CDebugUIPlugin.log(e);
        }
        catch (PartInitException e) {
            CDebugUIPlugin.log(e);
        }
        catch (DebugException e) {
            CDebugUIPlugin.log(e);
        }
    }
}

