/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.chart.AbstractOccupancyChart;

public final class SharedMemoryBoundOccupancyChart
extends AbstractOccupancyChart {
    private final String[] points;
    private final Double[] warpsActual;
    private final Double[] warpsTheoretical;

    public SharedMemoryBoundOccupancyChart(TimelineIntervalKernel kernel, OccupancyCalculator calculator, boolean highlight) throws ViperException {
        super(calculator.getComputeLimits(), highlight);
        int allocSize = this.limits.sharedMemAllocUnitSize;
        this.points = new String[this.limits.sharedMemPerSM / allocSize + 1];
        this.warpsActual = new Double[this.points.length];
        this.warpsTheoretical = new Double[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            Double warps = calculator.getWarpsPerSMForSharedMemoryUsage(i * allocSize).doubleValue();
            this.points[i] = String.format("%dk", i * allocSize / 1024);
            this.warpsActual[i] = null;
            this.warpsTheoretical[i] = warps;
            ++i;
        }
        int sharedMemoryUsed = (kernel.getStaticSharedMemory() + kernel.getDynamicSharedMemory()) / allocSize;
        this.warpsActual[sharedMemoryUsed] = this.warpsTheoretical[sharedMemoryUsed];
    }

    public String[] getLabels() {
        return this.points;
    }

    public String getTitle() {
        return ViperMessages.Chart_Shared_Memory_Title;
    }

    @Override
    public String getXAxisTitle() {
        return ViperMessages.Chart_Shared_Memory_XAxis;
    }

    @Override
    public String getYAxisTitle() {
        return null;
    }

    @Override
    public Integer getVerticalLineStep() {
        return 1024 / this.limits.sharedMemAllocUnitSize;
    }

    @Override
    public boolean isZeroBased() {
        return true;
    }

    @Override
    protected Double[] getActualPlotData() {
        return this.warpsActual;
    }

    @Override
    protected Double[] getTheoreticalPlotData() {
        return this.warpsTheoretical;
    }
}

