/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.ui.ImportMultipleFilesControl;
import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ImportNvprofSingleProcessPage
extends WizardPage
implements Listener {
    private Text timelinePath;
    private ImportMultipleFilesControl multipleFilesControl;

    public ImportNvprofSingleProcessPage(String pageName) {
        super(pageName);
        this.setTitle(ViperMessages.ImportNvprof_WizardPageSingle_Title);
        this.setDescription(ViperMessages.ImportNvprof_WizardPageSingle_Message);
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        Composite mainComposite = new Composite(parent, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout mainLayout = new GridLayout(3, false);
        mainComposite.setLayout((Layout)mainLayout);
        Label label = new Label(mainComposite, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText("Timeline data file: ");
        this.timelinePath = new Text(mainComposite, 2052);
        this.timelinePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timelinePath.setMessage(ViperMessages.ImportNvprof_Timeline_Message);
        this.timelinePath.addListener(24, (Listener)this);
        final Button browseButton = new Button(mainComposite, 8);
        browseButton.setText("Browse...");
        browseButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filename;
                Path path = new Path(ImportNvprofSingleProcessPage.this.timelinePath.getText());
                if (path.toFile().exists()) {
                    String prefPath = null;
                    prefPath = path.toFile().isDirectory() ? path.toOSString() : path.toFile().getParent().toString();
                    Activator.getDefault().getPreferenceStore().setValue("ImportPath", prefPath);
                }
                if ((filename = LocalFileSystem.browseForFileOpen(browseButton.getShell(), "Nvprof Data Files - Select nvprof profile file containing timeline data", null, "ImportPath")) != null) {
                    ImportNvprofSingleProcessPage.this.timelinePath.setText(filename);
                }
            }
        });
        Label multipleFilesLable = new Label(mainComposite, 0);
        multipleFilesLable.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 3, 1));
        multipleFilesLable.setText("Event/Metric data files:");
        this.multipleFilesControl = new ImportMultipleFilesControl(mainComposite, 8);
        this.multipleFilesControl.setLayoutData(new GridData(4, 4, false, true, 3, 1));
        this.setControl((Control)mainComposite);
    }

    public void handleEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.timelinePath) {
            File file = new File(this.timelinePath.getText());
            if (file != null && file.isFile()) {
                this.setErrorMessage(null);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(ViperMessages.ImportNvprof_FileError_Message);
                this.setPageComplete(false);
            }
        }
    }

    public String getTimelineFilePath() {
        return this.timelinePath.getText();
    }

    public String[] getAdditionalFilePaths() {
        return this.multipleFilesControl.getMultipleFilesListControl().getItems();
    }

    public boolean isCurrent() {
        return this.isCurrentPage();
    }
}

