/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.model.Executable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ExecutableOptionsPropertyControl
extends Composite {
    private Button profileOnStartButton;
    private Text timeOutText;
    private Button concurrentKernelButton;
    private Button environmentProfilingButton;
    private Button uvmProfilingButton;
    private Button apiTraceButton;
    private Button appReplayButton;
    private Executable executable;

    public ExecutableOptionsPropertyControl(Composite parent, int style) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout mainLayout = new GridLayout(3, false);
        mainLayout.marginWidth = 0;
        mainLayout.marginHeight = 0;
        this.setLayout((Layout)mainLayout);
        this.addTimeoutControl();
        this.addProfileOnStartButton();
        this.addConcurrentKernelButton();
        this.addApiTraceButton();
        this.addEnvironmentProfileButton();
        this.addUvmButton();
        this.addApplicationReplayButton();
    }

    public void disableApplicationReplay() {
        if (this.appReplayButton != null) {
            this.appReplayButton.setEnabled(false);
        }
    }

    private void addApplicationReplayButton() {
        this.appReplayButton = new Button((Composite)this, 32);
        this.appReplayButton.setText(ViperMessages.NewSession_Wizard_AppReplay_Label);
        this.appReplayButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.appReplayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExecutableOptionsPropertyControl.this.executable.setApplicationReplay(ExecutableOptionsPropertyControl.this.appReplayButton.getSelection());
            }
        });
        this.appReplayButton.setSelection(false);
    }

    private void addUvmButton() {
        this.uvmProfilingButton = new Button((Composite)this, 32);
        String uvmLabel = ViperMessages.NewSession_Wizard_UvmProfiling_Label;
        this.uvmProfilingButton.setText(uvmLabel);
        this.uvmProfilingButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.uvmProfilingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExecutableOptionsPropertyControl.this.executable.setUvmProfiling(ExecutableOptionsPropertyControl.this.uvmProfilingButton.getSelection());
            }
        });
        this.uvmProfilingButton.setSelection(true);
    }

    private void addEnvironmentProfileButton() {
        this.environmentProfilingButton = new Button((Composite)this, 32);
        this.environmentProfilingButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.environmentProfilingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                ExecutableOptionsPropertyControl.this.executable.setEnvironmentProfiling(ExecutableOptionsPropertyControl.this.environmentProfilingButton.getSelection());
            }
        });
        this.environmentProfilingButton.setSelection(false);
    }

    private void addApiTraceButton() {
        this.apiTraceButton = new Button((Composite)this, 32);
        this.apiTraceButton.setText(ViperMessages.NewSession_Wizard_APITrace_Label);
        this.apiTraceButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.apiTraceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutableOptionsPropertyControl.this.executable.setApiTrace(ExecutableOptionsPropertyControl.this.apiTraceButton.getSelection());
            }
        });
        this.apiTraceButton.setSelection(true);
    }

    private void addConcurrentKernelButton() {
        this.concurrentKernelButton = new Button((Composite)this, 32);
        this.concurrentKernelButton.setText(ViperMessages.NewSession_Wizard_ConcurrentKernels_Label);
        this.concurrentKernelButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.concurrentKernelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutableOptionsPropertyControl.this.executable.setConcurrentKernel(ExecutableOptionsPropertyControl.this.concurrentKernelButton.getSelection());
            }
        });
        this.concurrentKernelButton.setSelection(true);
    }

    private void addProfileOnStartButton() {
        this.profileOnStartButton = new Button((Composite)this, 32);
        this.profileOnStartButton.setText(ViperMessages.NewSession_Wizard_ProfilingEnabledOnStart_Label);
        this.profileOnStartButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.profileOnStartButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutableOptionsPropertyControl.this.executable.setProfileOnStart(ExecutableOptionsPropertyControl.this.profileOnStartButton.getSelection());
            }
        });
        this.profileOnStartButton.setSelection(true);
    }

    private void addTimeoutControl() {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(ViperMessages.NewSession_Wizard_TimeOut_Label);
        this.timeOutText = new Text((Composite)this, 2052);
        this.timeOutText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timeOutText.setMessage(ViperMessages.Execution_TimeOut_Message);
        this.timeOutText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.isEmpty() ? true : e.text.matches("[0-9]+");
            }
        });
        this.timeOutText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String timeOut = ExecutableOptionsPropertyControl.this.timeOutText.getText();
                if (timeOut.isEmpty()) {
                    ExecutableOptionsPropertyControl.this.executable.setTimeOut(-1);
                } else {
                    ExecutableOptionsPropertyControl.this.executable.setTimeOut(Integer.parseInt(timeOut));
                }
            }
        });
        Label labelUnit = new Label((Composite)this, 0);
        labelUnit.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        labelUnit.setText(ViperMessages.NewSession_Wizard_TimeOut_Unit_Label);
    }

    private void disableForMacOS(Executable exe, Button button, String label) {
        button.setEnabled(true);
        try {
            FileSystem filesystem = FileSystem.getFilesystem(exe.getConnectionName());
            if (filesystem.isLocal() && "macosx".equals(Platform.getOS())) {
                button.setEnabled(false);
                button.setSelection(false);
                label = String.valueOf(label) + " [not supported on Mac OSX]";
            }
        }
        catch (ConnectionNotFoundException e) {
            throw new IllegalStateException(e);
        }
        button.setText(label);
    }

    private void updateUvmProfilingLabel(Executable exe) {
        this.disableForMacOS(exe, this.uvmProfilingButton, ViperMessages.NewSession_Wizard_UvmProfiling_Label);
        if (!this.uvmProfilingButton.getEnabled()) {
            exe.setUvmProfiling(false);
        }
    }

    private void updateEnvProfilingLabel(Executable exe) {
        this.disableForMacOS(exe, this.environmentProfilingButton, ViperMessages.NewSession_Wizard_EnvironmentProfiling_Label);
    }

    public void setInput(Executable executable) {
        this.executable = executable;
        this.updateEnvProfilingLabel(executable);
        this.updateUvmProfilingLabel(executable);
    }

    public Text getTimeOutText() {
        return this.timeOutText;
    }

    public void refresh() {
        if (this.executable == null) {
            this.timeOutText.setText(null);
            this.profileOnStartButton.setSelection(false);
            this.concurrentKernelButton.setSelection(false);
            this.apiTraceButton.setSelection(false);
            this.environmentProfilingButton.setSelection(false);
            this.uvmProfilingButton.setSelection(false);
            this.appReplayButton.setSelection(false);
        } else {
            this.profileOnStartButton.setSelection(this.executable.isProfileOnStart());
            this.concurrentKernelButton.setSelection(this.executable.isConcurrentKernel());
            this.apiTraceButton.setSelection(this.executable.isApiTrace());
            this.environmentProfilingButton.setSelection(this.executable.isEnvironmentProfiling());
            this.uvmProfilingButton.setSelection(this.executable.isUvmProfiling());
            this.appReplayButton.setSelection(this.executable.isApplicationReplay());
            if (this.executable.getTimeOut() < 1) {
                this.timeOutText.setText("");
            } else {
                this.timeOutText.setText(Integer.toString(this.executable.getTimeOut()));
            }
        }
    }
}

