/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.ui.ViperViewerBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class CudaViewer
extends ViperViewerBase {
    private long maxInstExecuted = -1L;
    private long avgInstExecuted = -1L;
    private int maxExecCountLine = -1;
    private Map<Integer, Long> instExecutedMap;
    private Map<Integer, Long> threadInstExecutedMap;
    private Map<Integer, Long> notPredOffThreadsMap;
    private String cudaFileName;
    private int lastHighlightedLine = -1;

    public CudaViewer(SourceSassEditor editor, Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(editor, parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    @Override
    public void highlightLine(int line) {
        StyledText textWidget = this.getTextWidget();
        if (this.lastHighlightedLine != -1) {
            textWidget.setLineBackground(this.lastHighlightedLine, 1, textWidget.getBackground());
        }
        if (line != -1) {
            textWidget.setLineBackground(line, 1, Display.getDefault().getSystemColor(32));
        }
        this.lastHighlightedLine = line;
    }

    private void initInstructionExecuted() {
        AnalysisResultInstructionExecution analysisResult = this.editor.getSourceSassModel().getAnalysisResultInstructionExecution();
        if (analysisResult != null) {
            HashMap<Integer, Long> locatorInstExecMap = new HashMap<Integer, Long>();
            for (ICuptiActivitySourceLevelResult sResult : analysisResult.getSourceLevelResults()) {
                if (!(sResult instanceof CuptiActivityInstructionExecution)) continue;
                CuptiActivityInstructionExecution activity = (CuptiActivityInstructionExecution)sResult;
                int locatorId = activity.getSourceLocatorId();
                long instExec = activity.executed;
                if (locatorInstExecMap.containsKey(locatorId)) {
                    instExec += ((Long)locatorInstExecMap.get(locatorId)).longValue();
                }
                locatorInstExecMap.put(locatorId, instExec);
            }
            int avgInstCnt = 0;
            long totalInstExec = 0L;
            for (Long value : locatorInstExecMap.values()) {
                if (value > this.maxInstExecuted) {
                    this.maxInstExecuted = value;
                }
                if (value <= 0L) continue;
                totalInstExec += value.longValue();
                ++avgInstCnt;
            }
            this.avgInstExecuted = avgInstCnt == 0 ? 0L : totalInstExec / (long)avgInstCnt;
        }
    }

    @Override
    public long getMaxInstructionExecuted() {
        if (this.maxInstExecuted == -1L) {
            this.initInstructionExecuted();
        }
        return this.maxInstExecuted;
    }

    @Override
    public long getAverageNonZeroInstructionExecuted() {
        if (this.avgInstExecuted == -1L) {
            this.initInstructionExecuted();
        }
        return this.avgInstExecuted;
    }

    @Override
    public long getInstructionExecuted(int line) {
        if (this.instExecutedMap == null) {
            this.calculateAggregates();
        }
        if (this.instExecutedMap != null && this.instExecutedMap.containsKey(line)) {
            return this.instExecutedMap.get(line);
        }
        return -1L;
    }

    @Override
    public long getThreadInstructionExecuted(int line) {
        if (this.threadInstExecutedMap == null) {
            this.calculateAggregates();
        }
        if (this.threadInstExecutedMap != null && this.threadInstExecutedMap.containsKey(line)) {
            return this.threadInstExecutedMap.get(line);
        }
        return -1L;
    }

    @Override
    public long getNoPredicateOff(int line) {
        if (this.notPredOffThreadsMap == null) {
            this.calculateAggregates();
        }
        if (this.notPredOffThreadsMap != null && this.notPredOffThreadsMap.containsKey(line)) {
            return this.notPredOffThreadsMap.get(line);
        }
        return -1L;
    }

    private void calculateAggregates() {
        int line = 0;
        while (line < this.getDocument().getNumberOfLines()) {
            List<Integer> sassLines = this.editor.getSassLines(line);
            long aggredateInstExec = 0L;
            long aggredateThreadsExec = 0L;
            long aggredateNotPredOff = 0L;
            if (sassLines != null && sassLines.size() > 0) {
                for (Integer sassLine : sassLines) {
                    long noPredOff;
                    long threadsExec;
                    long instExec = this.editor.getInstructionExecutedSass(sassLine);
                    if (instExec > 0L) {
                        aggredateInstExec += instExec;
                    }
                    if ((threadsExec = this.editor.getThreadInstExecutedSass(sassLine)) > 0L) {
                        aggredateThreadsExec += threadsExec;
                    }
                    if ((noPredOff = this.editor.getNoPredicateOffSass(sassLine)) <= 0L) continue;
                    aggredateNotPredOff += noPredOff;
                }
                if (aggredateInstExec > 0L) {
                    if (this.instExecutedMap == null) {
                        this.instExecutedMap = new HashMap<Integer, Long>();
                    }
                    this.instExecutedMap.put(line, aggredateInstExec);
                }
                if (aggredateThreadsExec > 0L) {
                    if (this.threadInstExecutedMap == null) {
                        this.threadInstExecutedMap = new HashMap<Integer, Long>();
                    }
                    this.threadInstExecutedMap.put(line, aggredateThreadsExec);
                }
                if (aggredateNotPredOff > 0L) {
                    if (this.notPredOffThreadsMap == null) {
                        this.notPredOffThreadsMap = new HashMap<Integer, Long>();
                    }
                    this.notPredOffThreadsMap.put(line, aggredateNotPredOff);
                }
            }
            ++line;
        }
    }

    public void clear() {
        this.lastHighlightedLine = -1;
        this.instExecutedMap = null;
        this.threadInstExecutedMap = null;
        this.notPredOffThreadsMap = null;
        this.maxExecCountLine = -1;
    }

    public void setFileName(String cudaFileName) {
        this.cudaFileName = cudaFileName;
    }

    public String getFileName() {
        return this.cudaFileName;
    }

    private int getMaxInstExecutedLine() {
        if (this.maxExecCountLine == -1) {
            if (this.instExecutedMap == null) {
                this.calculateAggregates();
            }
            long max = 0L;
            if (this.instExecutedMap != null) {
                for (Map.Entry<Integer, Long> entry : this.instExecutedMap.entrySet()) {
                    if (entry.getValue() <= max) continue;
                    max = entry.getValue();
                    this.maxExecCountLine = entry.getKey();
                }
            }
        }
        return this.maxExecCountLine;
    }

    public void selectMaxExecCountLine() {
        try {
            int maxCountLine = this.getMaxInstExecutedLine();
            int lineStart = this.getDocument().getLineOffset(maxCountLine);
            int lineEnd = this.getDocument().getLineLength(maxCountLine) - 1;
            this.revealRange(lineStart, lineEnd);
            this.setSelectedRange(lineStart, lineEnd);
        }
        catch (BadLocationException e) {
            ViperExceptionHandler.logError(e.getMessage());
        }
    }

    @Override
    public void highlightCorrespondingLines(int line) {
        this.editor.highlightSassLines(line);
    }
}

