/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.parts;

import com.nvidia.viper.model.ContainerState;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.model.VerticalRuler;
import com.nvidia.viper.parts.VerticalRulerReorderDragTracker;
import com.nvidia.viper.parts.VerticalRulerResizeDragTracker;
import com.nvidia.viper.parts.VerticalRulerSelectTracker;
import com.nvidia.viper.ui.TimelineFigure;
import com.nvidia.viper.ui.VerticalRulerFigure;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.AbstractTool;

public class VerticalRulerEditPart
extends AbstractGraphicalEditPart
implements ISessionPropertyChangeListener {
    private static final Point UNKNOWN_MOUSE_LOCATION = new Point(-1, -1);
    private Point mouseLocation = new Point(UNKNOWN_MOUSE_LOCATION);
    private boolean resizeOnSelect = false;
    private Timeline hoverTimeline;
    private Timeline reorderTimeline;

    protected VerticalRuler getCastedModel() {
        return (VerticalRuler)this.getModel();
    }

    protected IFigure createFigure() {
        VerticalRulerFigure f = new VerticalRulerFigure();
        f.setPreferredSize(this.getFigureSize());
        f.setTimelines(this.getCastedModel().getSession().getVisibleTimelines(), this.getViewer().getControl().getFont());
        f.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseMoved(MouseEvent me) {
                VerticalRulerEditPart.this.mouseLocation.setLocation(me.x, me.y);
                VerticalRulerEditPart.this.updateDrag();
                VerticalRulerEditPart.this.setHighlighted(VerticalRulerEditPart.this.hoverTimeline);
            }

            public void mouseExited(MouseEvent me) {
                VerticalRulerEditPart.this.mouseLocation.setLocation(UNKNOWN_MOUSE_LOCATION);
                VerticalRulerEditPart.this.updateDrag();
                VerticalRulerEditPart.this.setHighlighted(null);
            }
        });
        return f;
    }

    protected Dimension getFigureSize() {
        int totalHeight = 0;
        for (Timeline tl : this.getCastedModel().getSession().getVisibleTimelines()) {
            totalHeight += TimelineFigure.getScaledTimelineHeight(tl);
        }
        return new Dimension(TimelineFigure.getScaledValue(this.getCastedModel().getWidth()), totalHeight);
    }

    protected VerticalRulerFigure getVerticalRulerFigure() {
        return (VerticalRulerFigure)this.getFigure();
    }

    protected void createEditPolicies() {
    }

    protected void refreshVisuals() {
        this.getFigure().repaint();
    }

    protected void setHighlighted(Timeline timeline) {
        this.getCastedModel().getSession().setPrimaryHighlighted(new TimelineIntervalPair(timeline, null));
    }

    public void handleSelection(AbstractTool.Input input) {
        Timeline tl = this.getVerticalRulerFigure().getTimelineExpandCollapseAt(this.mouseLocation);
        if (tl != null) {
            ContainerState newState;
            switch (tl.getContainerState()) {
                case CLOSED: {
                    newState = tl.getChildrenFiltered(false).isEmpty() || tl.getChildrenFiltered(true).isEmpty() ? ContainerState.OPEN_ALL : ContainerState.OPEN_NON_FILTERED;
                    break;
                }
                case OPEN_NON_FILTERED: {
                    newState = ContainerState.OPEN_ALL;
                    break;
                }
                default: {
                    newState = ContainerState.CLOSED;
                }
            }
            tl.setContainerState(newState);
        } else {
            tl = this.getVerticalRulerFigure().getTimelineFilterUnfilterAt(this.mouseLocation);
            if (tl != null) {
                Timeline container;
                boolean newState;
                boolean shiftSelection = input.isShiftKeyDown();
                boolean bl = newState = !tl.isFiltered();
                if (shiftSelection && (container = tl.getParent()) != null) {
                    for (Timeline peer : container.getChildrenFiltered(!newState)) {
                        if (!peer.getKind().isFilterable()) continue;
                        peer.setFiltered(newState);
                    }
                }
                tl.setFiltered(newState);
            } else {
                tl = this.getVerticalRulerFigure().getTimelineAt(this.mouseLocation);
                this.setSelectedTimeline(tl, false);
            }
        }
    }

    public void setSelectedTimeline(Timeline timeline, boolean disableToggle) {
        if (!disableToggle) {
            TimelineIntervalPair selectedPair = this.getCastedModel().getSession().getPrimarySelected();
            Timeline selectedTimeline = selectedPair == null ? null : selectedPair.getTimeline();
            timeline = selectedTimeline != timeline ? timeline : null;
        }
        this.getCastedModel().getSession().setPrimarySelected(new TimelineIntervalPair(timeline, null), true);
    }

    protected void updateDrag() {
        this.resizeOnSelect = this.getVerticalRulerFigure().isOverRightBorder(this.mouseLocation);
        this.reorderTimeline = this.hoverTimeline = this.getVerticalRulerFigure().getTimelineAt(this.mouseLocation);
        if (!(this.reorderTimeline == null || this.reorderTimeline.getKind().canReorder() && this.getVerticalRulerFigure().getTimelineFilterUnfilterAt(this.mouseLocation) == null)) {
            this.reorderTimeline = null;
        }
        this.getVerticalRulerFigure().setCursor(this.resizeOnSelect ? Cursors.SIZEWE : Cursors.ARROW);
    }

    public DragTracker getDragTracker(Request request) {
        if (!request.getType().equals("selection")) {
            return null;
        }
        if (this.resizeOnSelect) {
            return new VerticalRulerResizeDragTracker(this, this.getCastedModel(), 100);
        }
        if (this.reorderTimeline != null && this.hoverTimeline.getKind().canReorder() && this.getVerticalRulerFigure().getTimelineExpandCollapseAt(this.mouseLocation) == null && this.getVerticalRulerFigure().getTimelineFilterUnfilterAt(this.mouseLocation) == null) {
            return new VerticalRulerReorderDragTracker(this, this.hoverTimeline);
        }
        return new VerticalRulerSelectTracker(this);
    }

    public InsertLocation setInsertLocation(Timeline timeline, Point startLoc, Point insertLoc) {
        InsertLocation insert = this.findInsertLocation(timeline, startLoc, insertLoc);
        int insertY = this.getVerticalRulerFigure().setInsertLocation(insert);
        this.refreshVisuals();
        if (insertY != -1) {
            this.getCastedModel().getSession().setVerticalReveal(insertY);
        }
        return insert;
    }

    protected InsertLocation findInsertLocation(Timeline timeline, Point startLoc, Point insertLoc) {
        if (timeline == null) {
            return null;
        }
        List<Timeline> siblings = timeline.getParent() == null ? timeline.getSession().getTopLevelTimelines() : timeline.getParent().getChildren();
        Timeline closest = null;
        boolean before = false;
        int distance = Integer.MAX_VALUE;
        for (Timeline sibling : siblings) {
            int center;
            int delta;
            Rectangle bounds = this.getVerticalRulerFigure().getTimelineLabelBounds(sibling);
            if (bounds == null || (delta = Math.abs(insertLoc.y - (center = bounds.y + (bounds.height >> 1)))) >= distance) continue;
            distance = delta;
            closest = sibling;
            boolean bl = before = center > insertLoc.y;
        }
        if (closest == null) {
            return null;
        }
        return new InsertLocation(closest, before);
    }

    public void reorderTimeline(Timeline timeline, InsertLocation insertLocation) {
        this.getVerticalRulerFigure().setInsertLocation(null);
        this.refreshVisuals();
        if (timeline != null && insertLocation != null && insertLocation.timeline.getParent() != null && timeline != insertLocation.timeline) {
            if (insertLocation.before) {
                insertLocation.timeline.getParent().insertChild(timeline, insertLocation.timeline);
            } else {
                insertLocation.timeline.getParent().appendChild(timeline, insertLocation.timeline);
            }
        }
    }

    public void activate() {
        super.activate();
        this.getCastedModel().addPropertyChangeListener(this);
        this.getCastedModel().getSession().addPropertyChangeListener(this);
    }

    public void deactivate() {
        super.deactivate();
        this.setModel(null);
        if (this.getCastedModel() != null) {
            this.getCastedModel().removePropertyChangeListener(this);
            if (this.getCastedModel().getSession() != null) {
                this.getCastedModel().getSession().removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("session:timelines".equals(propertyName) || "session:timeline".equals(propertyName)) {
            VerticalRulerFigure figure = this.getVerticalRulerFigure();
            figure.setTimelines(this.getCastedModel().getSession().getVisibleTimelines(), figure.getFont());
            TimelineIntervalPair pair = this.getCastedModel().getSession().getPrimarySelected();
            this.getVerticalRulerFigure().setSelectedTimeline(pair == null || pair.getInterval() != null ? null : pair.getTimeline());
            this.refresh();
        } else if ("session:sInterval".equals(propertyName)) {
            TimelineIntervalPair pair = ((Session)model).getPrimarySelected();
            this.getVerticalRulerFigure().setSelectedTimeline(pair == null || pair.getInterval() != null ? null : pair.getTimeline());
            this.refreshVisuals();
        } else if ("vruler:width".equals(propertyName)) {
            this.figure.setPreferredSize(this.getFigureSize());
        }
    }

    public class InsertLocation {
        public Timeline timeline;
        public boolean before;

        public InsertLocation(Timeline timeline, boolean before) {
            this.timeline = timeline;
            this.before = before;
        }
    }
}

