/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityName;
import com.nvidia.viper.activity.CuptiActivityObjectKind;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineContext;
import com.nvidia.viper.model.TimelineIntervalAPI;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineKind;

public class TimelineStream
extends Timeline
implements IModel {
    private final int deviceId;
    private final int contextId;
    private final int streamId;
    private final String defaultStreamName = "Default";

    public TimelineStream(int deviceId, int contextId, int streamId) {
        super(String.valueOf(streamId), TimelineKind.STREAM);
        this.deviceId = deviceId;
        this.contextId = contextId;
        this.streamId = streamId;
    }

    @Override
    public String getDisplayName(boolean verbose) {
        String customName = this.getCustomName();
        if (customName == null) {
            TimelineContext contextTL = (TimelineContext)this.getAncestor(TimelineKind.CONTEXT);
            if (contextTL.getDefaultStreamId() == -1) {
                if (this.streamId == 1 || this.streamId == 2) {
                    return "Default";
                }
                return "Stream " + super.getDisplayName(verbose);
            }
            if (contextTL.getDefaultStreamId() == this.streamId) {
                return "Default";
            }
            return "Stream " + super.getDisplayName(verbose);
        }
        if (customName.startsWith("Default")) {
            return customName;
        }
        return "Stream " + customName;
    }

    public int getId() {
        return this.streamId;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            if (this.getCustomName() != null) {
                CuptiActivityName nameActivity = new CuptiActivityName(CuptiActivityObjectKind.CUPTI_ACTIVITY_OBJECT_STREAM.getCode(), 0, 0, this.deviceId, this.contextId, this.getId(), this.getCustomName());
                nameActivity.appendToPDM(pdm.getNativeHandle());
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }

    public int getProcessId() {
        for (ITimelineInterval interval : this.getIntervals()) {
            TimelineIntervalHierarchy oldest;
            if (!(interval instanceof TimelineIntervalHierarchy) || !((oldest = ((TimelineIntervalHierarchy)interval).getOldestAncestor()) instanceof TimelineIntervalAPI)) continue;
            return ((TimelineIntervalAPI)oldest).getProcessId();
        }
        return -1;
    }
}

