/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityMarker;
import com.nvidia.viper.activity.CuptiActivityMarkerData;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalKind;

public class TimelineIntervalRange
extends TimelineIntervalBase {
    protected CuptiActivityMarker start;
    protected CuptiActivityMarker end;
    private CuptiActivityMarkerData data;

    public TimelineIntervalRange(CuptiActivityMarker start, CuptiActivityMarker end, CuptiActivityMarkerData data) {
        this.start = start;
        this.end = end;
        this.data = data;
    }

    @Override
    public TimelineIntervalKind getKind() {
        return TimelineIntervalKind.RANGE;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.start.name;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        if (this.data != null && CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB.isSet(this.data.flags)) {
            return ViperColors.getMarkerGradientColors(this.data.color, true);
        }
        return null;
    }

    @Override
    public long getStart() {
        return this.start.timestamp;
    }

    @Override
    public long getEnd() {
        return this.end.timestamp;
    }

    public CuptiActivityMarkerData getMarkerData() {
        return this.data;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.start.appendToPDM(pdm.getNativeHandle());
            this.end.appendToPDM(pdm.getNativeHandle());
            if (this.data != null) {
                this.data.appendToPDM(pdm.getNativeHandle());
            }
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

