/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityEnvironment;
import com.nvidia.viper.activity.CuptiActivityEnvironmentKind;
import com.nvidia.viper.activity.CuptiEnvironmentClocksThrottleReason;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalKind;

public class TimelineIntervalEnvironment
extends TimelineIntervalBase {
    protected CuptiActivityEnvironment activity;

    public TimelineIntervalEnvironment(CuptiActivityEnvironment activity) {
        this.activity = activity;
    }

    public CuptiActivityEnvironmentKind getEnvironmentKind() {
        return this.activity.getEnvironmentKind();
    }

    public int getSmClock() {
        return this.activity.smClock;
    }

    public int getMemoryClock() {
        return this.activity.memoryClock;
    }

    public int getPcieLinkGen() {
        return this.activity.pcieLinkGen;
    }

    public int getPcieLinkWidth() {
        return this.activity.pcieLinkWidth;
    }

    public CuptiEnvironmentClocksThrottleReason[] getClocksThrottleReasons() {
        return this.activity.getClocksThrottleReasons();
    }

    public int getGpuTemperature() {
        return this.activity.gpuTemperature;
    }

    public int getPower() {
        return this.activity.power;
    }

    public int getPowerLimit() {
        return this.activity.powerLimit;
    }

    public int getFanSpeed() {
        return this.activity.fanSpeed;
    }

    @Override
    public TimelineIntervalKind getKind() {
        switch (this.activity.getEnvironmentKind()) {
            case CUPTI_ACTIVITY_ENVIRONMENT_SPEED: {
                return TimelineIntervalKind.ENVIRONMENT_SPEED;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE: {
                return TimelineIntervalKind.ENVIRONMENT_TEMP;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_POWER: {
                return TimelineIntervalKind.ENVIRONMENT_POWER;
            }
            case CUPTI_ACTIVITY_ENVIRONMENT_COOLING: {
                return TimelineIntervalKind.ENVIRONMENT_COOLING;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.activity.getEnvironmentKind().getName();
    }

    @Override
    public long getStart() {
        return this.activity.timestamp;
    }

    @Override
    public long getEnd() {
        return this.activity.timestamp;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

