/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.model.ContainerState;
import com.nvidia.viper.model.Event;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.ModelWithProperties;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.model.TimelineKind;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.gef.Disposable;
import org.eclipse.swt.graphics.Color;

public class Timeline
extends ModelWithProperties
implements IModel,
Disposable {
    public static final String PROPERTY_DISPLAYNAME = "timeline:displayname";
    public static final String PROPERTY_BGCOLOR = "timeline:bgcolor";
    public static final String PROPERTY_CHILDREN = "timeline:children";
    public static final String PROPERTY_VISIBLE = "timeline:visible";
    public static final String PROPERTY_FILTERED = "timeline:filtered";
    public static final String PROPERTY_INTERVALEVENT = "timeline:ievent";
    public static final String PROPERTY_INTERVALMETRIC = "timeline:imetric";
    protected static final int MAX_TIMELINE_HEIGHT = 160;
    protected static final int MAX_INTERVAL_ROWS = 64;
    protected static final int MIN_INTERVAL_ROW_HEIGHT = 1;
    public static final int MAX_INTERVAL_ROW_HEIGHT = 18;
    protected static final int DEFAULT_INTERVAL_ROW_MARGIN = 1;
    private final String name;
    private String customName;
    private final TimelineKind kind;
    private Session session;
    private long duration = 0L;
    private long maxIntervalExtendedDuration = 0L;
    private int intervalRowHeight = 18;
    private int intervalRowInnerMargin = 1;
    private int timelineOuterMargin = 1;
    private int numIntervalRows = 1;
    private Color backgroundColor = ViperColors.TIMELINE_DEFAULT_BGCOLOR;
    private boolean filtered = false;
    private boolean visible = true;
    private ContainerState containerState = ContainerState.OPEN_ALL;
    private Timeline parent = null;
    private List<Timeline> children = null;
    protected List<ITimelineInterval> intervals = new ArrayList<ITimelineInterval>();
    private ITimelineInterval[] sortedIntervals = null;
    private ITimelineInterval[] sortedVisibleIntervals = null;
    private HashMap<ITimelineInterval, Integer> intervalRows = new HashMap();
    private ViperColors.GradientColors intervalColors;

    public Timeline(String name, TimelineKind kind) {
        this.name = name;
        this.kind = kind;
    }

    public void dispose() {
        this.removeAllPropertyChangeListeners();
        this.session = null;
        this.parent = null;
        this.children = null;
        this.sortedIntervals = null;
        this.sortedVisibleIntervals = null;
        this.intervals = new ArrayList<ITimelineInterval>();
        this.intervalRows = new HashMap();
    }

    public final String getName() {
        return this.name;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public String getIdentifyingName() {
        return this.customName != null ? this.customName : this.name;
    }

    public String getDisplayName(boolean verbose) {
        return this.getIdentifyingName();
    }

    public TimelineKind getKind() {
        return this.kind;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public long getDuration() {
        return this.duration;
    }

    private int getHeight() {
        return this.timelineOuterMargin * 2 + this.numIntervalRows * this.intervalRowHeight + (this.numIntervalRows - 1) * this.intervalRowInnerMargin;
    }

    public int getTimelineOuterMargin() {
        return this.timelineOuterMargin;
    }

    public int getNumIntervalRows() {
        return this.numIntervalRows;
    }

    public int getIntervalRowHeight() {
        return this.intervalRowHeight;
    }

    public int getIntervalRowInnerMargin() {
        return this.intervalRowInnerMargin;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (!backgroundColor.equals((Object)this.backgroundColor)) {
            this.backgroundColor = backgroundColor;
            this.firePropertyChange(PROPERTY_BGCOLOR);
        }
    }

    public Timeline getParent() {
        return this.parent;
    }

    public List<Timeline> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.children);
    }

    public boolean appendChild(Timeline child) {
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        if (this.children == null) {
            this.children = new LinkedList<Timeline>();
        }
        this.children.add(child);
        child.parent = this;
        this.firePropertyChange(PROPERTY_CHILDREN);
        return true;
    }

    public boolean appendChild(Timeline child, Timeline after) {
        if (this.children == null || this.children.indexOf(after) == -1) {
            return false;
        }
        if (child == after) {
            return true;
        }
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        int afterIdx = this.children.indexOf(after);
        if (this.children == null) {
            this.children = new LinkedList<Timeline>();
        }
        this.children.add(afterIdx + 1, child);
        child.parent = this;
        this.firePropertyChange(PROPERTY_CHILDREN);
        return true;
    }

    public boolean insertChild(Timeline child) {
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        if (this.children == null) {
            this.children = new LinkedList<Timeline>();
        }
        this.children.add(0, child);
        child.parent = this;
        this.firePropertyChange(PROPERTY_CHILDREN);
        return true;
    }

    public boolean insertChild(Timeline child, Timeline before) {
        if (this.children == null || this.children.indexOf(before) == -1) {
            return false;
        }
        if (child == before) {
            return true;
        }
        if (child.parent != null) {
            child.parent.removeChild(child);
        }
        int beforeIdx = this.children.indexOf(before);
        if (this.children == null) {
            this.children = new LinkedList<Timeline>();
        }
        this.children.add(beforeIdx, child);
        child.parent = this;
        this.firePropertyChange(PROPERTY_CHILDREN);
        return true;
    }

    public boolean removeChild(Timeline child) {
        if (child.parent != this || this.children == null) {
            return false;
        }
        boolean ret = this.children.remove(child);
        if (ret) {
            child.parent = null;
        }
        this.firePropertyChange(PROPERTY_CHILDREN);
        return ret;
    }

    public Timeline getAncestor(TimelineKind kind) {
        if (this.parent != null) {
            if (this.parent.kind.equals((Object)kind)) {
                return this.parent;
            }
            return this.parent.getAncestor(kind);
        }
        return null;
    }

    public List<Timeline> getDescendants() {
        ArrayList<Timeline> ctls = new ArrayList<Timeline>();
        for (Timeline child : this.getChildren()) {
            ctls.add(child);
            child.collectDescendants(null, ctls);
        }
        return ctls;
    }

    public List<Timeline> getDescendants(TimelineKind kind) {
        return this.getDescendants(Arrays.asList(kind));
    }

    public List<Timeline> getDescendants(Collection<TimelineKind> kinds) {
        ArrayList<Timeline> ctls = new ArrayList<Timeline>();
        for (Timeline child : this.getChildren()) {
            if (kinds.contains((Object)child.kind)) {
                ctls.add(child);
            }
            child.collectDescendants(kinds, ctls);
        }
        return ctls;
    }

    private void collectDescendants(Collection<TimelineKind> kinds, List<Timeline> ctls) {
        for (Timeline child : this.getChildren()) {
            if (kinds == null || kinds.contains((Object)child.kind)) {
                ctls.add(child);
            }
            child.collectDescendants(kinds, ctls);
        }
    }

    public List<Timeline> getChildrenFiltered(boolean filtered) {
        ArrayList<Timeline> ctls = new ArrayList<Timeline>();
        for (Timeline child : this.getChildren()) {
            if (child.isFiltered() != filtered) continue;
            ctls.add(child);
        }
        return ctls;
    }

    public boolean isContainer() {
        return this.children != null && !this.children.isEmpty();
    }

    public boolean contains(Timeline other) {
        if (this.children == null) {
            return false;
        }
        for (Timeline child : this.children) {
            if (child != other && !child.contains(other)) continue;
            return true;
        }
        return false;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public void setFiltered(boolean filtered) {
        if (this.filtered != filtered) {
            this.filtered = filtered;
            this.firePropertyChange(PROPERTY_FILTERED);
            if (this.parent != null) {
                this.parent.refreshDescendantVisibility(true);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (this.visible != visible) {
            this.visible = visible;
            this.firePropertyChange(PROPERTY_VISIBLE);
        }
    }

    public boolean refreshDescendantVisibility(boolean deferredNotification) {
        boolean changed = false;
        try {
            if (deferredNotification) {
                Timeline.disableAllNotifications();
            }
            changed = this.refreshDescendantVisibility();
        }
        finally {
            if (deferredNotification) {
                Timeline.enableAllNotifications();
                if (changed && this.getSession() != null) {
                    this.getSession().fireGlobalVisibilityChange();
                }
            }
        }
        return changed;
    }

    public boolean refreshDescendantVisibility() {
        boolean changed = false;
        if (!this.getChildren().isEmpty()) {
            boolean newFilteredVisible = this.visible && this.containerState.isFilteredVisible();
            boolean newNonFilteredVisible = this.visible && this.containerState.isNonFilteredVisible();
            for (Timeline child : this.getChildren()) {
                if (child.isFiltered()) {
                    if (child.isVisible() != newFilteredVisible) {
                        child.setVisible(newFilteredVisible);
                        changed = true;
                    }
                } else if (child.isVisible() != newNonFilteredVisible) {
                    child.setVisible(newNonFilteredVisible);
                    changed = true;
                }
                changed |= child.refreshDescendantVisibility();
            }
        }
        return changed;
    }

    public ContainerState getContainerState() {
        if (this.isContainer()) {
            return this.containerState;
        }
        return ContainerState.OPEN_ALL;
    }

    public void setContainerState(ContainerState state) {
        if (this.isContainer() && state != this.containerState) {
            this.containerState = state;
            this.refreshDescendantVisibility(true);
        }
    }

    public int getVisibleIntervalRow(ITimelineInterval interval) {
        Integer row = this.intervalRows.get(interval);
        return row == null ? 0 : row;
    }

    public ViperColors.GradientColors getIntervalColors(ITimelineInterval interval) {
        ViperColors.GradientColors colors = interval.getColor(this.intervalColors);
        if (colors != null) {
            return colors;
        }
        return interval.getKind().getColors();
    }

    public void setIntervalColors(ViperColors.GradientColors intervalColors) {
        this.intervalColors = intervalColors;
    }

    public int getIntervalAlpha(ITimelineInterval interval) {
        Collection<ITimelineInterval> selected;
        if (this.getKind().isGhostWhenFiltered()) {
            Timeline primary = interval.getPrimaryTimeline();
            if (primary == null) {
                primary = this;
            }
            if (primary.isFiltered()) {
                return 50;
            }
        }
        if ((selected = this.getSession().getAllSelectedIntervals()) != null && !selected.contains(interval)) {
            return 50;
        }
        return -1;
    }

    public void addInterval(ITimelineInterval interval) {
        this.intervals.add(interval);
        this.sortedIntervals = null;
        this.sortedVisibleIntervals = null;
        this.duration = Math.max(this.duration, interval.getExtendedEnd());
    }

    public boolean removeInterval(ITimelineInterval interval) {
        if (this.intervals.remove(interval)) {
            this.sortedIntervals = null;
            this.sortedVisibleIntervals = null;
            return true;
        }
        return false;
    }

    public boolean removeIntervals(TimelineIntervalKind ... kinds) {
        HashSet<TimelineIntervalKind> kindSet = new HashSet<TimelineIntervalKind>(Arrays.asList(kinds));
        int removeCnt = 0;
        Iterator<ITimelineInterval> iter = this.intervals.iterator();
        while (iter.hasNext()) {
            ITimelineInterval interval = iter.next();
            if (!kindSet.contains((Object)interval.getKind())) continue;
            iter.remove();
            this.sortedIntervals = null;
            this.sortedVisibleIntervals = null;
            ++removeCnt;
        }
        return removeCnt > 0;
    }

    public ITimelineInterval getVisibleInterval(long time) {
        ITimelineInterval[] visible = this.getSortedVisibleIntervals();
        int index = Arrays.binarySearch(visible, new CompareTimelineInterval(time, time + 1L), new IntervalComparator());
        if (index >= 0) {
            return visible[index];
        }
        return null;
    }

    public int getNumIntervals() {
        return this.intervals.size();
    }

    public List<ITimelineInterval> getIntervals() {
        ITimelineInterval[] visible = this.getSortedIntervals();
        return Collections.unmodifiableList(Arrays.asList(visible));
    }

    public int getNumVisibleIntervals() {
        ITimelineInterval[] visible = this.getSortedVisibleIntervals();
        return visible.length;
    }

    public List<ITimelineInterval> getVisibleIntervals() {
        ITimelineInterval[] visible = this.getSortedVisibleIntervals();
        return Collections.unmodifiableList(Arrays.asList(visible));
    }

    public IntervalRange getVisibleIntervals(long start, long end) {
        ITimelineInterval tl;
        ITimelineInterval[] visible;
        int index;
        long searchTime = start;
        if (this.numIntervalRows > 1 || this instanceof TimelineDevice) {
            searchTime = Math.max(1L, start - this.maxIntervalExtendedDuration - 1L);
        }
        if ((index = Arrays.binarySearch(visible = this.getSortedVisibleIntervals(), new CompareTimelineInterval(searchTime, end), new IntervalComparator())) < 0) {
            index = -index - 1;
        }
        int startIndex = -1;
        index = Math.max(0, index - 1);
        while (index < visible.length) {
            tl = visible[index];
            if (tl.getStart() > start) break;
            if ((this.kind.usesExtendedEnd() ? tl.getExtendedEnd() : tl.getEnd()) >= start) {
                startIndex = index;
                break;
            }
            ++index;
        }
        if (startIndex == -1) {
            if (index == visible.length) {
                return IntervalRange.EMPTY_RANGE;
            }
            tl = visible[index];
            if (end < tl.getStart()) {
                return IntervalRange.EMPTY_RANGE;
            }
            startIndex = index;
        }
        int endIndex = startIndex + 1;
        while (endIndex < visible.length) {
            ITimelineInterval tl2 = visible[endIndex];
            if (tl2.getStart() > end) break;
            ++endIndex;
        }
        return new IntervalRange(visible, startIndex, endIndex);
    }

    public ITimelineInterval[] getAdjacentVisibleIntervals(long time) {
        int lowIndex;
        ITimelineInterval border;
        int highIndex;
        ITimelineInterval[] visible = this.getSortedVisibleIntervals();
        int index = Arrays.binarySearch(visible, new CompareTimelineInterval(time, time + 1L), new IntervalComparator());
        if (index >= 0) {
            return new ITimelineInterval[2];
        }
        index = -index - 1;
        ITimelineInterval highBorder = null;
        int n = highIndex = index < visible.length ? index : -1;
        if (highIndex != -1 && (border = visible[highIndex]).getStart() > time) {
            highBorder = border;
        }
        ITimelineInterval lowBorder = null;
        int n2 = lowIndex = index >= 1 ? index - 1 : -1;
        if (lowIndex != -1) {
            ITimelineInterval border2 = visible[lowIndex];
            if ((this.kind.usesExtendedEnd() ? border2.getExtendedEnd() : border2.getEnd()) < time) {
                lowBorder = border2;
            }
        }
        return new ITimelineInterval[]{lowBorder, highBorder};
    }

    private ITimelineInterval[] getSortedIntervals() {
        if (this.sortedIntervals == null) {
            this.sortedIntervals = this.intervals.toArray(new ITimelineInterval[0]);
            Arrays.sort(this.sortedIntervals, new IntervalComparator());
        }
        return this.sortedIntervals;
    }

    private ITimelineInterval[] getSortedVisibleIntervals() {
        if (this.sortedVisibleIntervals == null) {
            return this.getSortedIntervals();
        }
        return this.sortedVisibleIntervals;
    }

    public Set<Event> getEvents() {
        HashSet<Event> events = new HashSet<Event>();
        for (ITimelineInterval interval : this.intervals) {
            events.addAll(interval.getEvents());
        }
        return events;
    }

    public Set<Metric> getAggregateMetrics() {
        HashSet<Metric> metrics = new HashSet<Metric>();
        for (ITimelineInterval interval : this.intervals) {
            metrics.addAll(interval.getAggregateMetrics());
        }
        return metrics;
    }

    public void updateDurations() {
        this.maxIntervalExtendedDuration = 0L;
        this.duration = 0L;
        for (ITimelineInterval interval : this.intervals) {
            this.maxIntervalExtendedDuration = Math.max(this.maxIntervalExtendedDuration, interval.getExtendedDuration());
            this.duration = Math.max(this.duration, interval.getExtendedEnd());
        }
    }

    public void setVisibleIntervals(Collection<ITimelineInterval> visibleIntervals) {
        if (visibleIntervals == null) {
            if (this.sortedVisibleIntervals == null) {
                return;
            }
            this.sortedVisibleIntervals = null;
        } else {
            this.sortedVisibleIntervals = visibleIntervals.toArray(new ITimelineInterval[0]);
            Arrays.sort(this.sortedVisibleIntervals, new IntervalComparator());
        }
        this.assignVisibleIntervalRows();
        this.firePropertyChange(PROPERTY_VISIBLE);
    }

    public void assignVisibleIntervalRows() {
        this.timelineOuterMargin = 1;
        this.intervalRows.clear();
        this.numIntervalRows = 1;
        this.intervalRowHeight = 18;
        int n = this.intervalRowInnerMargin = TimelineKind.KERNELS.equals((Object)this.getKind()) ? 0 : 1;
        if (this.getKind().supportsMultipleIntervalRows()) {
            ITimelineInterval[] intervals;
            Vector<Long> rowLastTime = new Vector<Long>(64);
            rowLastTime.add(-1L);
            ITimelineInterval[] iTimelineIntervalArray = intervals = this.getSortedVisibleIntervals();
            int n2 = intervals.length;
            int n3 = 0;
            while (n3 < n2) {
                block7: {
                    ITimelineInterval interval = iTimelineIntervalArray[n3];
                    int row = 0;
                    while (row < this.numIntervalRows) {
                        if (row == 63 || interval.getStart() >= (Long)rowLastTime.get(row)) {
                            if (row > 0) {
                                this.intervalRows.put(interval, row);
                            }
                            rowLastTime.set(row, this.kind.usesExtendedEnd() ? interval.getExtendedEnd() : interval.getEnd());
                            break block7;
                        }
                        ++row;
                    }
                    this.intervalRows.put(interval, this.numIntervalRows);
                    ++this.numIntervalRows;
                    rowLastTime.add(this.kind.usesExtendedEnd() ? interval.getExtendedEnd() : interval.getEnd());
                }
                ++n3;
            }
            if (this.getHeight() > 160) {
                double rowHeight = (160 - this.timelineOuterMargin * 2 - this.intervalRowInnerMargin * (this.numIntervalRows - 1)) / this.numIntervalRows;
                if (rowHeight < 1.0) {
                    this.intervalRowInnerMargin = 0;
                    rowHeight = (160 - this.timelineOuterMargin * 2) / this.numIntervalRows;
                }
                this.intervalRowHeight = rowHeight < 1.0 ? 1 : (int)Math.floor(rowHeight);
            }
        }
    }

    public void fireIntervalEventChange(ITimelineInterval interval) {
        this.firePropertyChange(PROPERTY_INTERVALEVENT);
    }

    public void fireIntervalMetricChange(ITimelineInterval interval) {
        this.firePropertyChange(PROPERTY_INTERVALMETRIC);
    }

    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        for (ITimelineInterval interval : this.intervals) {
            interval.appendToPDM(pdm);
        }
    }

    public void dump(PrintStream out, int indent) {
        int i = 0;
        while (i < indent) {
            out.append(' ');
            ++i;
        }
        out.println(this.toString());
        for (Timeline child : this.getChildren()) {
            child.dump(out, indent + 2);
        }
    }

    public String toString() {
        return this.getDisplayName(true);
    }

    private class CompareTimelineInterval
    extends TimelineIntervalBase {
        long start;
        long end;

        public CompareTimelineInterval(long start, long end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public TimelineIntervalKind getKind() {
            return TimelineIntervalKind.UNKNOWN;
        }

        @Override
        public long getStart() {
            return this.start;
        }

        @Override
        public long getEnd() {
            return this.end;
        }
    }

    public static class IntervalComparator
    implements Comparator<ITimelineInterval> {
        @Override
        public int compare(ITimelineInterval o1, ITimelineInterval o2) {
            long res = o1.getStart() - o2.getStart();
            if (res < 0L) {
                return -1;
            }
            if (res > 0L) {
                return 1;
            }
            return 0;
        }
    }

    public static class IntervalRange {
        public static final IntervalRange EMPTY_RANGE = new IntervalRange(null, 0, 0);
        private int startIndex;
        private int endIndex;
        private ITimelineInterval[] intervals;

        private IntervalRange(ITimelineInterval[] intervals, int startIndex, int endIndex) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.intervals = intervals;
        }

        public boolean isEmpty() {
            return this.startIndex >= this.endIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getSize() {
            return this.endIndex - this.startIndex;
        }

        public ITimelineInterval getInterval(int idx) throws ArrayIndexOutOfBoundsException {
            if (idx < this.startIndex || idx >= this.endIndex) {
                throw new ArrayIndexOutOfBoundsException();
            }
            return this.intervals[idx];
        }
    }
}

