/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityFunction;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityModule;
import com.nvidia.viper.editor.CudaFunction;
import com.nvidia.viper.jni.NativeUtils;
import com.nvidia.viper.model.ProfileDataModel;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.Disposable;

public class CudaFunctionManager
implements Disposable {
    private List<CuptiActivityModule> moduleList;
    private Map<Integer, CuptiActivityFunction> functionIdMap = new HashMap<Integer, CuptiActivityFunction>();
    private Map<CuptiActivityFunction, CudaFunction> functionMap;
    private final String BIN_FILE_NAME = "module";
    private final String BIN_FILE_EXT = "cubin";
    private int nextFunctionId = 0;
    private int nextModuleId = 0;
    private IPath cubinsLocation = null;

    public CudaFunctionManager() {
        this.moduleList = new ArrayList<CuptiActivityModule>();
        this.functionMap = new HashMap<CuptiActivityFunction, CudaFunction>();
    }

    private int getUniqueFunctionId() {
        int uniqueId = this.nextFunctionId;
        while (uniqueId < Integer.MAX_VALUE) {
            if (!this.functionIdMap.containsKey(uniqueId)) break;
            ++uniqueId;
        }
        ++this.nextFunctionId;
        return uniqueId;
    }

    private boolean isDuplicateModuleId(int moduleId) {
        for (CuptiActivityModule module : this.moduleList) {
            if (module.id != moduleId) continue;
            return true;
        }
        return false;
    }

    private int getUniqueModuleId() {
        int uniqueId = this.nextModuleId;
        while (uniqueId < Integer.MAX_VALUE) {
            if (!this.isDuplicateModuleId(uniqueId)) break;
            ++uniqueId;
        }
        ++this.nextModuleId;
        return uniqueId;
    }

    public CuptiActivityFunction createFunction(String functionName, int contextId, int moduleId, int funcIndex) {
        CuptiActivityFunction function = new CuptiActivityFunction(CuptiActivityKind.CUPTI_ACTIVITY_KIND_FUNCTION, this.getUniqueFunctionId(), contextId, moduleId, funcIndex, functionName);
        this.addFunction(function);
        return function;
    }

    public CuptiActivityFunction getFunction(String functionName, int moduleId) {
        for (Map.Entry<Integer, CuptiActivityFunction> entry : this.functionIdMap.entrySet()) {
            CuptiActivityFunction function = entry.getValue();
            if (!function.name.equals(functionName) || function.moduleId != moduleId) continue;
            return function;
        }
        return null;
    }

    public CuptiActivityModule createModule(int contextId, int cubinSize, byte[] cubin) {
        CuptiActivityModule module = new CuptiActivityModule(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MODULE, this.getUniqueModuleId(), contextId, cubinSize, cubin);
        this.addModule(module);
        return module;
    }

    public CuptiActivityModule getModule(int cubinSize, byte[] cubin) {
        for (CuptiActivityModule module : this.moduleList) {
            if (module.cubinSize != cubinSize || !this.isSameModule(cubin, module.cubin, cubinSize)) continue;
            return module;
        }
        return null;
    }

    public void dispose() {
        this.functionIdMap.clear();
        this.moduleList.clear();
        this.functionIdMap = null;
        this.moduleList = null;
        this.cubinsLocation = null;
    }

    public Collection<CuptiActivityFunction> getFunctions() {
        return Collections.unmodifiableCollection(this.functionIdMap.values());
    }

    public Collection<CudaFunction> getCudaFunctions() {
        return Collections.unmodifiableCollection(this.functionMap.values());
    }

    public CuptiActivityFunction getFunction(int id) {
        return this.functionIdMap.get(id);
    }

    public CuptiActivityModule getModule(int moduleId, int contextId) {
        for (CuptiActivityModule module : this.moduleList) {
            if (module.id != moduleId || module.contextId != contextId) continue;
            return module;
        }
        return null;
    }

    public void addFunction(CuptiActivityFunction function) {
        this.functionIdMap.put(function.id, function);
        this.nextFunctionId = Math.max(this.nextFunctionId, function.id + 1);
    }

    public void addModule(CuptiActivityModule module) {
        this.moduleList.add(module);
        this.nextModuleId = Math.max(this.nextModuleId, module.id + 1);
    }

    private boolean isSameModule(byte[] cubin1, byte[] cubin2, int cubinSize) {
        int i = 0;
        while (i < cubinSize) {
            if (cubin1[i] != cubin2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        for (CuptiActivityFunction function : this.functionIdMap.values()) {
            try {
                function.appendToPDM(pdm.getNativeHandle());
            }
            catch (Exception e) {
                if (e instanceof ViperException) {
                    throw (ViperException)e;
                }
                throw new ViperException(e);
            }
        }
        for (CuptiActivityModule module : this.moduleList) {
            try {
                module.appendToPDM(pdm.getNativeHandle());
            }
            catch (Exception e) {
                if (e instanceof ViperException) {
                    throw (ViperException)e;
                }
                throw new ViperException(e);
            }
        }
    }

    public void resetForNewTimeline() {
        this.functionIdMap.clear();
        this.moduleList.clear();
        this.functionMap.clear();
        this.cubinsLocation = null;
    }

    public CudaFunction getCudaFunction(CuptiActivityFunction function) {
        CudaFunction cudaFunction = this.functionMap.get(function);
        if (cudaFunction != null) {
            return cudaFunction;
        }
        CuptiActivityModule module = this.getModule(function.moduleId, function.contextId);
        Process p = this.parseFunction(module, function.index);
        try {
            this.parseFile(p, function);
        }
        catch (IOException iOException) {
            ViperExceptionHandler.logError("Error in reading the output");
        }
        return this.functionMap.get(function);
    }

    private Process parseFunction(CuptiActivityModule module, int funcIndex) {
        String cubinName;
        try {
            cubinName = this.writeFile(module);
        }
        catch (ViperException viperException) {
            ViperExceptionHandler.logError("Failed to write the module bytes to the file");
            return null;
        }
        try {
            return this.disassembleFunction(cubinName, funcIndex);
        }
        catch (CoreException e) {
            ViperExceptionHandler.logError("Failed to get nvdisasm binary", e);
            return null;
        }
        catch (IOException e) {
            ViperExceptionHandler.logError("Failed to run nvdisasm", e);
            return null;
        }
    }

    private void parseFile(Process p, CuptiActivityFunction function) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        block0: while ((line = reader.readLine()) != null) {
            if (!line.startsWith(function.name)) continue;
            CudaFunction cudaFunction = new CudaFunction();
            this.functionMap.put(function, cudaFunction);
            cudaFunction.appendSass(String.valueOf(function.name) + ":", -1);
            boolean flagSassInstruction = false;
            while ((line = reader.readLine()) != null) {
                String trimmedLine = line.trim();
                if (flagSassInstruction && trimmedLine.equals("")) break block0;
                if (trimmedLine.startsWith(".L_")) {
                    cudaFunction.appendSass(trimmedLine, -1);
                    continue;
                }
                if (!trimmedLine.startsWith("/*")) continue;
                String pcString = "";
                int index = 2;
                while (trimmedLine.charAt(index) != '*') {
                    pcString = String.valueOf(pcString) + trimmedLine.charAt(index);
                    ++index;
                }
                if (trimmedLine.charAt(index) != '*' || trimmedLine.charAt(index + 1) != '/') continue;
                Integer pcOffset = new Integer(Integer.parseInt(pcString.toLowerCase().replaceAll("[\\W]", ""), 16));
                String sassInstruction = trimmedLine.substring(index += 2).trim();
                cudaFunction.appendSass(sassInstruction, pcOffset);
                flagSassInstruction = true;
            }
            break block0;
        }
    }

    private Process disassembleFunction(String cubinName, int funcIndex) throws CoreException, IOException {
        File nvdisasmFile = NativeUtils.getTool(ICudaToolkit.Tool.Nvdisasm);
        String nvdisasm = nvdisasmFile.getAbsolutePath();
        Process p = Runtime.getRuntime().exec(new String[]{nvdisasm, "-c", "-ndf", "-fun", Integer.toString(funcIndex), cubinName});
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(CuptiActivityModule module) throws ViperException {
        CudaFunctionManager cudaFunctionManager = this;
        synchronized (cudaFunctionManager) {
            if (this.cubinsLocation == null) {
                this.cubinsLocation = TemporaryDirs.modules.newSubfolder();
            }
        }
        IPath cubinFile = this.cubinsLocation.append("module" + module.id + "." + "cubin");
        try {
            if (!cubinFile.toFile().exists()) {
                BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(cubinFile.toFile()));
                ((OutputStream)output).write(module.cubin);
                ((OutputStream)output).close();
            }
            return cubinFile.toString();
        }
        catch (IOException e) {
            throw new ViperException(e);
        }
    }
}

