/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.editor.ViperAnnotation;
import com.nvidia.viper.ui.ViperViewerBase;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class InstExecutedColumn
extends AbstractRulerColumn {
    private ViperViewerBase viewer;
    private DefaultToolTip toolTip;
    private int MIN_COLUMN_WIDTH = 4;
    public static final String INST_EXECUTED_COLUMN_WIDTH = "InstExecutedColumn:width";
    public static final String COLUMN_HEADER = "Exec Count";
    private PropertyChangeSupport listeners = new PropertyChangeSupport((Object)this);
    private Control control;

    public InstExecutedColumn() {
        this.setWidth(this.MIN_COLUMN_WIDTH);
    }

    public InstExecutedColumn(int width) {
        this.setWidth(width);
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.control = super.createControl(parentRuler, parentControl);
        this.viewer = (ViperViewerBase)parentRuler.getTextViewer();
        this.toolTip = new DefaultToolTip(this.control);
        this.control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int lineNumber = InstExecutedColumn.this.toDocumentLineNumber(e.y);
                long per = InstExecutedColumn.this.viewer.getInstExecutedPercent(lineNumber);
                if (per >= 0L) {
                    InstExecutedColumn.this.toolTip.activate();
                    InstExecutedColumn.this.toolTip.setText(String.format(ViperMessages.ExecCountBar_Tooltip, per, InstExecutedColumn.this.viewer.getMaxInstructionExecuted()));
                    InstExecutedColumn.this.toolTip.setShift(new Point(10, 0));
                } else {
                    InstExecutedColumn.this.toolTip.deactivate();
                }
            }
        });
        if (parentRuler != null) {
            this.viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    InstExecutedColumn.this.updateWidth();
                }
            });
        }
        return this.control;
    }

    public void updateWidth() {
        if (this.control != null && !this.control.isDisposed()) {
            long maxInstExecuted = this.viewer.getMaxInstructionExecuted();
            int numDigits = String.valueOf(maxInstExecuted).length();
            if (numDigits < this.MIN_COLUMN_WIDTH) {
                numDigits = this.MIN_COLUMN_WIDTH;
            }
            GC gc = new GC((Drawable)this.control);
            try {
                gc.setFont(this.control.getFont());
                char[] nines = new char[numDigits + 1];
                Arrays.fill(nines, '9');
                String nineString = new String(nines);
                Point cellSize = gc.stringExtent(nineString);
                Point headerSize = gc.stringExtent(COLUMN_HEADER);
                int width = cellSize.x > headerSize.x ? cellSize.x : headerSize.x + 10;
                this.setWidth(width);
                this.firePropertyChange(INST_EXECUTED_COLUMN_WIDTH);
            }
            finally {
                gc.dispose();
            }
            this.redraw();
        }
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        String text;
        long count;
        int width;
        super.paintLine(gc, modelLine, widgetLine, linePixel, lineHeight);
        long maxInstExecuted = this.viewer.getMaxInstructionExecuted();
        int columnWidth = this.getWidth();
        if (maxInstExecuted > 0L && (width = (int)((double)(count = this.viewer.getInstructionExecuted(widgetLine)) / (double)maxInstExecuted * (double)columnWidth)) > 1) {
            gc.setBackground(ViperColors.COLOR_EXEC_COUNT_BACKGROUND);
            gc.fillRectangle(columnWidth - width, linePixel - 1, width, lineHeight - 1);
            Color foregroundColor = this.getForegroundColor(widgetLine);
            if (foregroundColor != null) {
                Color fore = gc.getForeground();
                gc.setForeground(foregroundColor);
                gc.setLineWidth(3);
                gc.drawLine(columnWidth - 1, lineHeight + linePixel, columnWidth - 1, linePixel);
                gc.setForeground(fore);
            }
        }
        if ((text = this.getComputeText(widgetLine)) != null) {
            Point textSize = gc.stringExtent(text);
            gc.drawString(text, columnWidth - textSize.x, linePixel, true);
        }
    }

    private Color getForegroundColor(int lineNum) {
        Color color = null;
        IAnnotationModel annotationModel = this.viewer.getAnnotationModel();
        if (annotationModel != null) {
            Iterator ite = annotationModel.getAnnotationIterator();
            while (ite.hasNext()) {
                ViperAnnotation annotation = (ViperAnnotation)((Object)ite.next());
                if (annotation.getLine() != lineNum) continue;
                color = annotation.getColor();
                break;
            }
        }
        return color;
    }

    private String getComputeText(int line) {
        long count;
        if (this.viewer != null && (count = this.viewer.getInstructionExecuted(line)) >= 0L) {
            return String.valueOf(Long.toString(count)) + " ";
        }
        return null;
    }

    public void addListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName) {
        this.listeners.firePropertyChange(propertyName, null, null);
    }
}

