/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.model.SassInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CudaFunction {
    private List<SassInstruction> sassInstructions = new ArrayList<SassInstruction>();
    private Map<Integer, SassInstruction> pcOffsetMap = new HashMap<Integer, SassInstruction>();

    public void appendSass(String sass, int pcOffset) {
        SassInstruction sassInstruction = new SassInstruction(sass, pcOffset, -1);
        this.sassInstructions.add(sassInstruction);
        if (pcOffset >= 0) {
            this.pcOffsetMap.put(pcOffset, sassInstruction);
        }
    }

    public boolean updateSourceLocator(AnalysisResultSourceLevel sourceLevelRecord, int functionId) {
        boolean functionIdPresent = false;
        block0: for (ICuptiActivitySourceLevelResult slresult : sourceLevelRecord.getSourceLevelResults()) {
            if (!(slresult instanceof CuptiActivityInstructionExecution)) continue;
            CuptiActivityInstructionExecution activity = (CuptiActivityInstructionExecution)slresult;
            int i = 0;
            while (i < this.sassInstructions.size()) {
                if (activity.functionId == functionId && activity.pcOffset == this.sassInstructions.get(i).getPcOffset()) {
                    functionIdPresent = true;
                    this.sassInstructions.get(i).setSourcelocatorid(activity.getSourceLocatorId());
                    continue block0;
                }
                ++i;
            }
        }
        return functionIdPresent;
    }

    public List<SassInstruction> getSassInstructions() {
        return this.sassInstructions;
    }
}

