/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultKernelMemory;
import com.nvidia.viper.analysis.AnalysisResultLocalMemoryOverhead;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.PCIeCalculator;
import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKind;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KernelInstanceMemoryAnalysis
extends AnalysisBase {
    private static final double BAD_LOCAL_MEMORY_OVERHEAD = 20.0;
    private boolean needNoData;

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        Analysis analysis = session.getAnalysis();
        if (analysis != null) {
            TimelineIntervalKernel interval = AnalysisStage.getHostLaunchedKernel(analysis.getActiveScopeInterval());
            if (interval == null || generateAllResults) {
                results.add(new AnalysisResult(AnalysisDescriptor.KERNEL_MEMORY_NO_KERNEL));
            }
            if (interval instanceof TimelineIntervalKernel) {
                this.needNoData = false;
                TimelineIntervalKernel kernel = interval;
                ret = true;
                ret &= this.runMemoryAnalysis(session, results, kernel, generateAllResults);
                ret &= this.runLocalMemoryAnalysis(session, results, kernel, generateAllResults);
                if (this.needNoData) {
                    AnalysisResultIntervalNoData noDataMemory = new AnalysisResultIntervalNoData(session, AnalysisDescriptor.KERNEL_MEMORY_NO_DATA);
                    noDataMemory.addInterval(kernel, null);
                    results.add(noDataMemory);
                }
            }
        }
        return ret;
    }

    protected boolean runMemoryAnalysis(Session session, List<AnalysisResult> results, TimelineIntervalKernel kernel, boolean generateAllResults) {
        boolean ret = false;
        Timeline timeline = kernel.getPrimaryTimeline();
        TimelineDevice device = (TimelineDevice)timeline.getAncestor(TimelineKind.DEVICE);
        AnalysisResultKernelMemory.MemoryUnit[] availMems = AnalysisResultKernelMemory.MemoryUnit.getMemoryUnits(device.getComputeCapabilityMajor(), device.getComputeCapabilityMinor());
        HashMap<AnalysisResultKernelMemory.MemoryUnit, Number> memMap = new HashMap<AnalysisResultKernelMemory.MemoryUnit, Number>();
        HashMap<String, Number> metricsMap = new HashMap<String, Number>();
        AnalysisResultKernelMemory.MemoryUnit[] memoryUnitArray = availMems;
        int n = availMems.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisResultKernelMemory.MemoryUnit mu = memoryUnitArray[n2];
            this.getMemAggregateMetricValue(memMap, metricsMap, kernel, mu, mu.getUtilizationMetricName(), mu.getMetricNames());
            ++n2;
        }
        if (memMap.size() != availMems.length) {
            this.needNoData = true;
            ret = false;
        } else {
            PCIeCalculator pcie = null;
            if (memMap.containsKey((Object)AnalysisResultKernelMemory.MemoryUnit.SYSMEM)) {
                pcie = new PCIeCalculator(session.getAnalysis(), device);
                memMap.put(AnalysisResultKernelMemory.MemoryUnit.SYSMEM, pcie.getScaledUtilization((Number)memMap.get((Object)AnalysisResultKernelMemory.MemoryUnit.SYSMEM)));
            }
            Number dramReadTransactions = (Number)metricsMap.get("dram_read_transactions");
            Number dramWriteTransactions = (Number)metricsMap.get("dram_write_transactions");
            Number sramReadTransactions = (Number)metricsMap.get("sysmem_read_transactions");
            Number sramWriteTransactions = (Number)metricsMap.get("sysmem_write_transactions");
            Number l2ReadTransactions = (Number)metricsMap.get("l2_read_transactions");
            Number l2WriteTransactions = (Number)metricsMap.get("l2_write_transactions");
            Number l2L1ReadTransactions = this.getAggregateMetricValue(kernel, "l2_l1_read_transactions");
            Number l2L1WriteTransactions = this.getAggregateMetricValue(kernel, "l2_l1_write_transactions");
            Number l2TexReadTransactions = this.getAggregateMetricValue(kernel, "l2_tex_read_transactions");
            Number l2TexWriteTransactions = this.getAggregateMetricValue(kernel, "l2_tex_write_transactions");
            Number l2AtomicTransactions = this.getAggregateMetricValue(kernel, "l2_atomic_transactions");
            Number ncL2ReadTransactions = this.getAggregateMetricValue(kernel, "nc_l2_read_transactions");
            Number texTransactions = (Number)metricsMap.get("tex_cache_transactions");
            Number sharedReadTransactions = (Number)metricsMap.get("shared_load_transactions");
            Number sharedWriteTransactions = (Number)metricsMap.get("shared_store_transactions");
            Number localReadTransactions = this.getAggregateMetricValue(kernel, "local_load_transactions");
            Number localWriteTransactions = this.getAggregateMetricValue(kernel, "local_store_transactions");
            Number globalReadTransactions = (Number)metricsMap.get("gld_transactions");
            Number globalWriteTransactions = (Number)metricsMap.get("gst_transactions");
            Number atomicTransactions = this.getAggregateMetricValue(kernel, "atomic_transactions");
            Number eccTransactions = this.getAggregateMetricValue(kernel, "ecc_transactions");
            Number dramReadThroughput = (Number)metricsMap.get("dram_read_throughput");
            Number dramWriteThroughput = (Number)metricsMap.get("dram_write_throughput");
            Number sramReadThroughput = (Number)metricsMap.get("sysmem_read_throughput");
            Number sramWriteThroughput = (Number)metricsMap.get("sysmem_write_throughput");
            Number l2ReadThroughput = (Number)metricsMap.get("l2_read_throughput");
            Number l2WriteThroughput = (Number)metricsMap.get("l2_write_throughput");
            Number l2L1ReadThroughput = this.getAggregateMetricValue(kernel, "l2_l1_read_throughput");
            Number l2L1WriteThroughput = this.getAggregateMetricValue(kernel, "l2_l1_write_throughput");
            Number l2TexReadThroughput = this.getAggregateMetricValue(kernel, "l2_texture_read_throughput");
            Number l2TexWriteThroughput = this.getAggregateMetricValue(kernel, "l2_tex_write_throughput");
            Number l2AtomicThroughput = this.getAggregateMetricValue(kernel, "l2_atomic_throughput");
            Number ncL2ReadThroughput = this.getAggregateMetricValue(kernel, "nc_l2_read_throughput");
            Number texThroughput = (Number)metricsMap.get("tex_cache_throughput");
            Number sharedReadThroughput = (Number)metricsMap.get("shared_load_throughput");
            Number sharedWriteThroughput = (Number)metricsMap.get("shared_store_throughput");
            Number localReadThroughput = this.getAggregateMetricValue(kernel, "local_load_throughput");
            Number localWriteThroughput = this.getAggregateMetricValue(kernel, "local_store_throughput");
            Number globalReadThroughput = (Number)metricsMap.get("gld_throughput");
            Number globalWriteThroughput = (Number)metricsMap.get("gst_throughput");
            Number eccThroughput = this.getAggregateMetricValue(kernel, "ecc_throughput");
            Number atomicThroughput = this.getAggregateMetricValue(kernel, "atomic_throughput");
            AnalysisResultKernelMemory memoryResult = new AnalysisResultKernelMemory(kernel, pcie, dramReadTransactions, dramWriteTransactions, sramReadTransactions, sramWriteTransactions, l2ReadTransactions, l2WriteTransactions, l2L1ReadTransactions, l2L1WriteTransactions, l2TexReadTransactions, l2TexWriteTransactions, l2AtomicTransactions, ncL2ReadTransactions, sharedReadTransactions, sharedWriteTransactions, localReadTransactions, localWriteTransactions, globalReadTransactions, globalWriteTransactions, texTransactions, atomicTransactions, eccTransactions, dramReadThroughput, dramWriteThroughput, sramReadThroughput, sramWriteThroughput, l2ReadThroughput, l2WriteThroughput, l2L1ReadThroughput, l2L1WriteThroughput, l2TexReadThroughput, l2TexWriteThroughput, l2AtomicThroughput, ncL2ReadThroughput, sharedReadThroughput, sharedWriteThroughput, localReadThroughput, localWriteThroughput, globalReadThroughput, globalWriteThroughput, texThroughput, atomicThroughput, eccThroughput);
            AnalysisResultKernelMemory.MemoryUnit[] memoryUnitArray2 = availMems;
            int n3 = availMems.length;
            int n4 = 0;
            while (n4 < n3) {
                AnalysisResultKernelMemory.MemoryUnit mu = memoryUnitArray2[n4];
                this.setMemUtil(memoryResult, memMap, mu);
                ++n4;
            }
            results.add(memoryResult);
            ret = true;
        }
        return ret;
    }

    protected boolean runLocalMemoryAnalysis(Session session, List<AnalysisResult> results, TimelineIntervalKernel kernel, boolean generateAllResults) {
        boolean ret = true;
        Timeline timeline = kernel.getPrimaryTimeline();
        TimelineDevice device = (TimelineDevice)timeline.getAncestor(TimelineKind.DEVICE);
        if (AnalysisResultKernelMemory.MemoryUnit.isLocalMemoryAnalysisAvailable(device.getComputeCapabilityMajor(), device.getComputeCapabilityMinor())) {
            Number lmemOverhead = this.getAggregateMetricValue(kernel, "local_memory_overhead");
            if (lmemOverhead == null) {
                this.needNoData = true;
                ret = false;
            } else {
                double overhead = lmemOverhead.doubleValue();
                if (overhead >= 20.0 || generateAllResults) {
                    AnalysisResultLocalMemoryOverhead lmemResult = new AnalysisResultLocalMemoryOverhead(kernel, overhead);
                    results.add(lmemResult);
                }
            }
        }
        return ret;
    }

    private void getMemAggregateMetricValue(Map<AnalysisResultKernelMemory.MemoryUnit, Number> muMap, Map<String, Number> metricsMap, TimelineIntervalKernel kernel, AnalysisResultKernelMemory.MemoryUnit mu, String metricName, List<String> metricNames) {
        Number val = this.getAggregateMetricValue(kernel, metricName);
        if (val != null) {
            muMap.put(mu, val);
        }
        for (String metric : metricNames) {
            val = this.getAggregateMetricValue(kernel, metric);
            if (val == null) continue;
            metricsMap.put(metric, val);
        }
    }

    private void setMemUtil(AnalysisResultKernelMemory result, Map<AnalysisResultKernelMemory.MemoryUnit, Number> memMap, AnalysisResultKernelMemory.MemoryUnit mu) {
        Number util = memMap.get((Object)mu);
        if (util != null) {
            CuptiMetricValueUtilizationLevel level = CuptiMetricValueUtilizationLevel.valueOf(util.intValue());
            if (level == null) {
                ViperExceptionHandler.logError((Object)((Object)mu) + ": unexpected utilization level " + util);
                level = CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_IDLE;
            }
            result.setMemoryUnitUtilization(mu, level);
        }
    }
}

