/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultIntervalNoData;
import com.nvidia.viper.analysis.AnalysisResultKernelAchievedOccupancy;
import com.nvidia.viper.analysis.AnalysisResultKernelGridSize;
import com.nvidia.viper.analysis.AnalysisResultKernelOccupancy;
import com.nvidia.viper.analysis.AnalysisResultKernelStall;
import com.nvidia.viper.analysis.AnalysisResultOccupancyCharts;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.analysis.OccupancyCalculator;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Metric;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineKind;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class KernelInstanceLatencyAnalysis
extends AnalysisBase {
    private static final double LOW_ACHIEVED_THRESHOLD = 0.6;

    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = true;
        Analysis analysis = session.getAnalysis();
        if (analysis != null) {
            TimelineIntervalKernel interval = AnalysisStage.getHostLaunchedKernel(analysis.getActiveScopeInterval());
            if (interval == null || generateAllResults) {
                results.add(new AnalysisResult(AnalysisDescriptor.KERNEL_LATENCY_NO_KERNEL));
            }
            if (interval instanceof TimelineIntervalKernel) {
                TimelineIntervalKernel kernel = interval;
                Timeline timeline = kernel.getPrimaryTimeline();
                Timeline device = timeline.getAncestor(TimelineKind.DEVICE);
                ret &= this.analyzeKernelLatency(session, kernel, (TimelineDevice)device, results, generateAllResults);
            }
        }
        return ret;
    }

    private boolean analyzeKernelLatency(Session session, TimelineIntervalKernel kernel, TimelineDevice deviceTimeline, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        Number achievedOccupancy = this.getAggregateMetricValue(kernel, "achieved_occupancy");
        if (achievedOccupancy == null) {
            achievedOccupancy = this.deriveAggregateMetricValue(kernel, "achieved_occupancy", true);
        }
        Number slotUtilization = this.getAggregateMetricValue(kernel, "issue_slot_utilization");
        AnalysisResultKernelStall.StallKind[] availStalls = AnalysisResultKernelStall.StallKind.getStallKinds(deviceTimeline.getComputeCapabilityMajor(), deviceTimeline.getComputeCapabilityMinor());
        HashMap<AnalysisResultKernelStall.StallKind, Number> stallMap = new HashMap<AnalysisResultKernelStall.StallKind, Number>();
        AnalysisResultKernelStall.StallKind[] stallKindArray = availStalls;
        int n = availStalls.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisResultKernelStall.StallKind kind = stallKindArray[n2];
            this.getStallAggregateMetricValue(stallMap, kernel, kind, kind.getStallMetricName());
            ++n2;
        }
        if (achievedOccupancy == null || slotUtilization == null) {
            AnalysisResultIntervalNoData noDataSM = new AnalysisResultIntervalNoData(session, AnalysisDescriptor.KERNEL_LATENCY_NO_DATA);
            noDataSM.addInterval(kernel, null);
            results.add(noDataSM);
            ret = false;
        } else {
            OccupancyCalculator calculator = new OccupancyCalculator(kernel, deviceTimeline);
            boolean isLowAchieved = this.isLowAchievedOccupancy(achievedOccupancy, calculator.getTheoreticOccupancy());
            if (isLowAchieved || generateAllResults) {
                if (calculator.isGridSizeLimited() || generateAllResults) {
                    AnalysisResultKernelGridSize gridSize = new AnalysisResultKernelGridSize(deviceTimeline, kernel);
                    results.add(gridSize);
                }
                if (!calculator.isGridSizeLimited() || generateAllResults) {
                    Metric activityMetric = this.getMetric(kernel, "sm_efficiency_instance");
                    AnalysisResultKernelAchievedOccupancy badAchieved = new AnalysisResultKernelAchievedOccupancy(AnalysisDescriptor.KERNEL_LATENCY_BAD_ACHIEVED, deviceTimeline, kernel, achievedOccupancy.doubleValue(), activityMetric);
                    results.add(badAchieved);
                }
            } else {
                Metric activityMetric = this.getMetric(kernel, "sm_efficiency_instance");
                AnalysisResultKernelAchievedOccupancy achieved = new AnalysisResultKernelAchievedOccupancy(AnalysisDescriptor.KERNEL_LATENCY_ACHIEVED_OCCUPANCY, deviceTimeline, kernel, achievedOccupancy.doubleValue(), activityMetric);
                if (achieved.getSMActivity() != null) {
                    results.add(achieved);
                }
            }
            if (stallMap.size() == availStalls.length) {
                AnalysisDescriptor desc = AnalysisDescriptor.KERNEL_LATENCY_NOSTALL;
                if (!isLowAchieved && slotUtilization.doubleValue() / 100.0 < 0.6 && calculator.getTheoreticOccupancy() >= 0.5) {
                    desc = AnalysisDescriptor.KERNEL_LATENCY_STALL;
                }
                AnalysisResultKernelStall stall = new AnalysisResultKernelStall(desc, kernel);
                for (AnalysisResultKernelStall.StallKind kind : stallMap.keySet()) {
                    stall.setStallPercentage(kind, ((Number)stallMap.get((Object)kind)).doubleValue());
                }
                results.add(stall);
            }
            results.add(new AnalysisResultKernelOccupancy(deviceTimeline, kernel, calculator, achievedOccupancy.doubleValue()));
            results.add(new AnalysisResultOccupancyCharts(kernel, calculator));
            ret = true;
        }
        return ret;
    }

    private void getStallAggregateMetricValue(Map<AnalysisResultKernelStall.StallKind, Number> stallMap, TimelineIntervalKernel kernel, AnalysisResultKernelStall.StallKind kind, String metricName) {
        Number val = this.getAggregateMetricValue(kernel, metricName);
        if (val != null) {
            stallMap.put(kind, val);
        }
    }

    public boolean isLowAchievedOccupancy(Number achievedOccupancy, Number theoreticalOccupancy) {
        if (achievedOccupancy == null || theoreticalOccupancy == null) {
            return false;
        }
        return achievedOccupancy.doubleValue() < theoreticalOccupancy.doubleValue() * 0.6;
    }
}

