/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityBase;
import com.nvidia.viper.activity.CuptiActivityKind;
import com.nvidia.viper.activity.CuptiActivityUvmCounterKind;
import com.nvidia.viper.activity.CuptiActivityUvmCounterScope;
import com.nvidia.viper.activity.ICuptiActivity;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;

public class CuptiActivityUvmCounter
extends CuptiActivityBase
implements ICuptiActivity {
    public int kind;
    private int uvmCounterKind;
    private int uvmCounterScope;
    public int deviceId;
    public long timestamp;
    public long value;
    public int processId;

    public CuptiActivityUvmCounter() {
        this.kind = CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID.getCode();
    }

    public CuptiActivityUvmCounter(CuptiActivityKind activityKind, CuptiActivityUvmCounterKind counterKind, CuptiActivityUvmCounterScope counterScope, int deviceId, int processId, long timestamp, long value) {
        this.kind = activityKind.getCode();
        this.uvmCounterKind = counterKind.getCode();
        this.uvmCounterScope = counterScope.getCode();
        this.deviceId = deviceId;
        this.processId = processId;
        this.timestamp = timestamp;
        this.value = value;
    }

    @Override
    public boolean isValid() {
        return this.timestamp != 0L;
    }

    @Override
    public CuptiActivityKind getKind() {
        return CuptiActivityKind.valueOf(this.kind);
    }

    @Override
    public int getKindCode() {
        return this.kind;
    }

    @Override
    public void appendToPDM(long hPdm) throws CuptiException {
        NativeCupti.cuptiPDMAppendActivity(hPdm, this);
    }

    public CuptiActivityUvmCounterKind getUvmCounterKind() {
        return CuptiActivityUvmCounterKind.valueOf(this.uvmCounterKind);
    }

    public CuptiActivityUvmCounterScope getUvmCounterScope() {
        return CuptiActivityUvmCounterScope.valueOf(this.uvmCounterScope);
    }
}

