/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.common.util.SWTUtil;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.actions.RunnerAction;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.ProfileRunner;
import com.nvidia.viper.ui.ViperMessageDialog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.Disposable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class RunProfileAction
extends RunnerAction
implements Disposable {
    private Session session;
    private Expert expert;
    private final boolean showExpertView;
    private final boolean showSettingsDialog;

    public RunProfileAction(Session session, Expert expert, boolean showExpertView, boolean showSettingsDialog) {
        super(showSettingsDialog ? ViperMessages.ConfigureMetricEvent_Label : ViperMessages.RunExpert_Label, showSettingsDialog ? ViperImages.DESC_EDIT_EXPERT : ViperImages.DESC_RUN_EXPERT);
        this.setToolTipText(showSettingsDialog ? ViperMessages.ConfigureMetricEvent_Tooltip : ViperMessages.RunExpert_Tooltip);
        this.setId(showSettingsDialog ? "com.nvidia.viper.runexpert.dialog" : "com.nvidia.viper.runexpert");
        this.session = session;
        this.expert = expert != null ? expert : (session != null ? session.getExpert() : null);
        this.showExpertView = showExpertView;
        this.showSettingsDialog = showSettingsDialog;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.session = null;
        this.expert = null;
    }

    public void run() {
        IDevicesData data = this.getDevicesData();
        if (data == null) {
            return;
        }
        final ProfileRunner runner = new ProfileRunner(this.session, this.expert, data, ViperMessages.Expert_Progress_Message, this.showSettingsDialog, true);
        boolean ret = runner.runWithJob();
        if (ret && this.showExpertView) {
            new Thread("Expert Completion Waiter"){

                @Override
                public void run() {
                    final IStatus status = runner == null ? Status.OK_STATUS : runner.waitForCompletion();
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (status != Status.OK_STATUS && status != Status.CANCEL_STATUS) {
                                Exception e = status.getException() instanceof Exception ? (Exception)status.getException() : null;
                                ViperExceptionHandler.handle(ViperMessages.Launch_Fail_Title, status.getMessage(), e);
                            } else if (status == Status.OK_STATUS) {
                                try {
                                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.nvidia.viper.expertview");
                                }
                                catch (PartInitException partInitException) {
                                    ViperExceptionHandler.logError("unable to show expert view");
                                }
                            }
                        }
                    });
                }
            }.start();
        } else if (!ret && runner.getSettingDialogCode() == 1024 && this.session.needToGenerateTimeline()) {
            new RunAnalysisAction(this.session, true, RunAnalysisAction.ShowMode.GUIDED).run();
        }
    }

    private IDevicesData getDevicesData() {
        try {
            FileSystem system = FileSystem.getFilesystem(this.session);
            try {
                return system.getDeviceData(false);
            }
            catch (DeviceListNotReadyException deviceListNotReadyException) {
                if (ViperMessageDialog.openQuestion(SWTUtil.getShell(), ViperMessages.RemoteDevices_Message_Title, ViperMessages.RemoteDevices_Connect_Prompt)) {
                    return system.getDeviceData(true);
                }
                return null;
            }
        }
        catch (ViperException e1) {
            ViperExceptionHandler.handle(ViperMessages.RemoteDevices_Message_Title, "Unable to obtain devices list", e1);
            return null;
        }
        catch (DeviceListNotReadyException deviceListNotReadyException) {
            return null;
        }
    }

    public void setActiveSession(Session activeSession) {
        this.session = activeSession;
        this.expert = activeSession != null ? activeSession.getExpert() : null;
    }
}

