/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.ActiveEditorAction;
import com.nvidia.viper.fs.LocalFileSystem;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import java.io.File;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CloneSessionAction
extends ActiveEditorAction {
    private IWorkbenchWindow window;

    public CloneSessionAction(IWorkbenchWindow window) {
        super(ViperMessages.CloneSession_Label, window);
        this.window = window;
        this.setToolTipText(ViperMessages.CloneSession_Tooltip);
        this.setId("com.nvidia.viper.sessionclone");
    }

    public void run() {
        super.run();
        String filename = LocalFileSystem.browseForFileSave(this.window.getShell(), "Clone Session", null, "SaveDialogPath");
        if (filename != null) {
            try {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                SessionEditor editor = (SessionEditor)activePage.getActiveEditor();
                Session session = CloneSessionAction.cloneSession(filename, editor.getSession());
                SessionEditor newEditor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(session), "com.nvidia.viper.sessioneditor");
                newEditor.scaleToFit();
                newEditor.setDirty(false);
            }
            catch (Exception e2) {
                ViperException e2;
                if (!(e2 instanceof ViperException)) {
                    e2 = new ViperException(e2);
                }
                ViperExceptionHandler.handle(ViperMessages.Clone_Fail_Title, ViperMessages.Clone_Fail_Message, e2);
            }
        }
    }

    public static Session cloneSession(String filename, Session existingSession) throws ViperException {
        File file = new File(filename);
        FileUtils.saveSession(file, existingSession);
        Session session = FileUtils.loadSession(file);
        session.setDirty(false);
        return session;
    }

    @Override
    protected void updateState() {
        super.updateState();
        this.setEnabled(this.getActiveEditor() != null && this.getActiveEditor() instanceof SessionEditor);
    }
}

