/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.IProfilingData;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SessionFilter;
import com.nvidia.viper.model.SourceLevelResult;
import com.nvidia.viper.ui.LargeDataMessageDialog;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ProfileResultManager {
    private Vector<List<SinglePassProfileData>> perPassProfileDatas = new Vector(32);
    private Vector<File> perPassProfileFiles = new Vector(32);
    private Vector<SessionFilter> perPassScopes = new Vector(32);

    public void add(String deviceType, Map<ITimelineInterval, Set<IProfilingData>> eventAndMetrics) throws ViperException {
        for (List<SinglePassProfileData> dataList : this.perPassProfileDatas) {
            for (SinglePassProfileData data : dataList) {
                if (!deviceType.equals(data.getDeviceType())) continue;
                throw new ViperException("unexpected repeat of device \"" + deviceType + "\"");
            }
        }
        int pass = 0;
        Set<IProfilingData> globalData = eventAndMetrics.get(Expert.NULL_INTERVAL);
        if (globalData == null) {
            globalData = Collections.emptySet();
        }
        for (Map.Entry<ITimelineInterval, Set<IProfilingData>> entry : eventAndMetrics.entrySet()) {
            Set<IProfilingData> filtered;
            ITimelineInterval interval;
            if (entry.getKey() == Expert.NULL_INTERVAL) {
                interval = null;
                filtered = globalData;
            } else {
                interval = entry.getKey();
                filtered = new HashSet<IProfilingData>((Collection)entry.getValue());
                filtered.removeAll(globalData);
                if (filtered.isEmpty()) continue;
            }
            SinglePassProfileData data = new SinglePassProfileData(deviceType, filtered, interval);
            this.addForPass(pass++, interval == null ? null : new SessionFilter(interval), data);
        }
    }

    private void addForPass(int pass, SessionFilter scope, SinglePassProfileData data) {
        List<SinglePassProfileData> passDatas;
        if (this.perPassProfileDatas.size() <= pass) {
            this.perPassProfileDatas.setSize(pass + 1);
        }
        if ((passDatas = this.perPassProfileDatas.get(pass)) == null) {
            passDatas = new LinkedList<SinglePassProfileData>();
            this.perPassProfileDatas.set(pass, passDatas);
        }
        this.perPassScopes.add(scope);
        passDatas.add(data);
    }

    public int getNumPasses() {
        return this.perPassProfileDatas.size();
    }

    public List<SinglePassProfileData> getPassProfileData(int pass) {
        if (pass >= this.perPassProfileDatas.size()) {
            return null;
        }
        return this.perPassProfileDatas.get(pass);
    }

    public void setPassProfileFile(int pass, File profileFile) {
        if (this.perPassProfileFiles.size() <= pass) {
            this.perPassProfileFiles.setSize(pass + 1);
        }
        this.perPassProfileFiles.set(pass, profileFile);
    }

    public SessionFilter getPassScope(int pass) {
        return this.perPassScopes.get(pass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateSession(final Session session) throws ViperException {
        try {
            boolean completeProfileData = true;
            boolean completeMerge = true;
            int i = 0;
            while (i < this.getNumPasses()) {
                block25: {
                    if (this.perPassProfileFiles.size() <= i) break;
                    File profileFile = this.perPassProfileFiles.get(i);
                    List<SinglePassProfileData> datas = this.perPassProfileDatas.get(i);
                    if (profileFile != null && profileFile.exists() && profileFile.isFile()) {
                        final ProfileDataModel[] pdms = new ProfileDataModel[1];
                        try {
                            block24: {
                                pdms[0] = new ProfileDataModel();
                                try {
                                    if (System.getenv("__LARGE_PDM") != null) {
                                        pdms[0].readUsingCorrelationId(profileFile, session);
                                    } else {
                                        pdms[0].read(profileFile);
                                    }
                                }
                                catch (ViperException e) {
                                    if (e.getMessage().endsWith("LoadPdmCancel")) {
                                        throw e;
                                    }
                                    completeProfileData = false;
                                    Throwable cause = e.getCause();
                                    if (cause instanceof CuptiException && CUptiResult.CUPTI_ERROR_NOT_COMPATIBLE.equals((Object)((CuptiException)cause).getCuptiResult())) break block24;
                                    if (pdms[0] != null) {
                                        pdms[0].dispose();
                                    }
                                    break block25;
                                }
                            }
                            final HashSet<SourceLevelResult> slrs = new HashSet<SourceLevelResult>();
                            ITimelineInterval interval = null;
                            for (SinglePassProfileData data : datas) {
                                for (IProfilingData pdata : data.getEventsMetrics()) {
                                    if (!(pdata instanceof SourceLevelResult)) continue;
                                    slrs.add((SourceLevelResult)pdata);
                                }
                                ITimelineInterval target = data.getInterval();
                                if (interval == null) {
                                    interval = target;
                                    continue;
                                }
                                if (target == null || interval.equals(target)) continue;
                                ViperExceptionHandler.logError("single pass cannot analyse more then one interval");
                            }
                            final SessionFilter scope = interval != null ? new SessionFilter(interval) : null;
                            final boolean[] mergeTimelines = new boolean[1];
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        mergeTimelines[0] = session.mergeTimelines(pdms[0], scope, true, true, true, slrs);
                                    }
                                    catch (ViperException e) {
                                        if (!e.getMessage().endsWith("LoadPdmCancel")) {
                                            ViperExceptionHandler.handle(ViperMessages.LoadExpertEvents_Fail_Title, ViperMessages.LoadExpertEvents_Fail_Message, e);
                                        }
                                    }
                                    catch (OutOfMemoryError e) {
                                        ViperExceptionHandler.logError("Out of memory error", e);
                                        LargeDataMessageDialog.show();
                                    }
                                }
                            });
                            if (!mergeTimelines[0]) {
                                completeMerge = false;
                            }
                        }
                        catch (OutOfMemoryError e) {
                            throw e;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                ++i;
            }
            if (completeProfileData) {
                if (completeMerge) return;
            }
            String msg = "";
            if (!completeProfileData) {
                msg = String.valueOf(msg) + "One or more sets of profile data are incomplete. This may prevent event, metric and source-level results from being assigned to some kernels. To make sure that all profile data is flushed before the application terminates, be sure the application calls cudaDeviceReset() or cuProfilerStop() before exiting.\n";
            }
            if (!completeMerge) {
                msg = String.valueOf(msg) + "Some collected events, metrics or source-level results could not be associated with the session timeline. This may prevent event, metric and source-level results from being assigned to some kernels.\n";
            }
            if (msg.isEmpty()) return;
            final String message = msg;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Unable To Calculate All Metrics", message);
                }
            });
            return;
        }
        catch (ViperException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }

    public static class SinglePassProfileData {
        private final String deviceType;
        private final Set<IProfilingData> eventsMetrics;
        private ITimelineInterval interval;

        public SinglePassProfileData(String deviceType, Set<IProfilingData> eventsMetrics, ITimelineInterval interval) {
            this.deviceType = deviceType;
            this.interval = interval;
            this.eventsMetrics = eventsMetrics;
        }

        public ITimelineInterval getInterval() {
            return this.interval;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public Set<IProfilingData> getEventsMetrics() {
            return this.eventsMetrics;
        }
    }
}

