/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import java.text.NumberFormat;

public class FrequencyFormatter {
    public static final String FORMAT_HZ = "Hz";
    public static final String FORMAT_KHZ = "KHz";
    public static final String FORMAT_MHZ = "MHz";
    public static final String FORMAT_GHZ = "GHz";
    private String format = null;
    private long divisor = 1L;
    private static NumberFormat formatter = NumberFormat.getInstance();

    static {
        formatter.setMaximumFractionDigits(3);
    }

    public FrequencyFormatter() {
    }

    public FrequencyFormatter(long frequency) {
        this.initFormat(frequency);
    }

    public String format(long frequency) {
        return this.format(frequency, true);
    }

    public String format(long frequency, boolean group) {
        if (this.format == null) {
            this.initFormat(frequency);
        }
        formatter.setGroupingUsed(group);
        double fsize = (double)frequency / (double)this.divisor;
        return String.valueOf(formatter.format(fsize)) + " " + this.format;
    }

    protected void initFormat(long ns) {
        if (ns < 1000L) {
            this.format = FORMAT_HZ;
            this.divisor = 1L;
        } else if (ns < 1000000L) {
            this.format = FORMAT_KHZ;
            this.divisor = 1000L;
        } else if (ns < 1000000000L) {
            this.format = FORMAT_MHZ;
            this.divisor = 1000000L;
        } else {
            this.format = FORMAT_GHZ;
            this.divisor = 1000000000L;
        }
    }
}

