/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.jni.CuException;
import com.nvidia.viper.jni.CuptiEvent;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.CuptiMetric;
import com.nvidia.viper.jni.NativeCuda;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Device;
import com.nvidia.viper.model.DeviceDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class DeviceManager {
    private static Map<String, DeviceDescriptor> deviceDescriptors = new HashMap<String, DeviceDescriptor>();
    private static Map<Integer, Device> devices = new HashMap<Integer, Device>();

    static {
        int failCnt = 0;
        try {
            int deviceCnt = !NativeCuda.hasCudaCapableDevices() ? 0 : NativeCuda.cuDeviceGetCount();
            int i = 0;
            while (i < deviceCnt) {
                List<CuptiMetric> metrics;
                List<CuptiEvent> events;
                int minor;
                int major;
                String name;
                int cuDevice;
                boolean fail;
                block17: {
                    fail = false;
                    cuDevice = NativeCuda.cuDeviceGet(i);
                    name = "<unknown>";
                    try {
                        name = NativeCuda.cuDeviceGetName(cuDevice);
                    }
                    catch (CuException e) {
                        fail = true;
                        ViperExceptionHandler.logError("failed to get device name", e);
                    }
                    major = -1;
                    try {
                        major = NativeCuda.cuDeviceComputeCapabilityMajor(cuDevice);
                    }
                    catch (Exception e) {
                        fail = true;
                        ViperExceptionHandler.logError("failed to get device compute capability", e);
                    }
                    minor = -1;
                    try {
                        minor = NativeCuda.cuDeviceComputeCapabilityMinor(cuDevice);
                    }
                    catch (Exception e) {
                        fail = true;
                        ViperExceptionHandler.logError("failed to get device compute capability", e);
                    }
                    events = Collections.emptyList();
                    try {
                        events = NativeCupti.cuptiDeviceGetEvents(cuDevice);
                    }
                    catch (CuptiException e) {
                        fail = true;
                        ViperExceptionHandler.logError("failed to get device events", e);
                    }
                    metrics = Collections.emptyList();
                    if (!events.isEmpty()) {
                        try {
                            metrics = NativeCupti.cuptiDeviceGetMetrics(cuDevice);
                        }
                        catch (CuptiException e) {
                            if (CUptiResult.CUPTI_ERROR_NOT_INITIALIZED.equals((Object)e.getCuptiResult())) break block17;
                            fail = true;
                            ViperExceptionHandler.logError("failed to get device metrics", e);
                        }
                    }
                }
                if (fail) {
                    ++failCnt;
                }
                DeviceDescriptor desc = DeviceManager.createDeviceDescriptor(name, major, minor, events, metrics);
                Device device = new Device(desc, i, cuDevice);
                devices.put(i, device);
                ++i;
            }
        }
        catch (Exception e2) {
            ViperException e2;
            if (!(e2 instanceof ViperException)) {
                e2 = new ViperException(e2);
            }
            Activator.getDefault().getViperWorkbench().informUnableToLoadLibraries(e2);
        }
        if (failCnt > 0) {
            ViperExceptionHandler.handle(ViperMessages.DeviceManager_Fail_Title, ViperMessages.DeviceManager_Fail_Message, null);
        }
    }

    private static DeviceDescriptor createDeviceDescriptor(String name, int computeCapabilityMajor, int computeCapabilityMinor, List<CuptiEvent> events, List<CuptiMetric> metrics) throws ViperException {
        DeviceDescriptor desc = deviceDescriptors.get(name);
        if (desc == null) {
            desc = new DeviceDescriptor(name, computeCapabilityMajor, computeCapabilityMinor, events, metrics);
            deviceDescriptors.put(name, desc);
        }
        return desc;
    }

    public static Collection<DeviceDescriptor> getDeviceDescriptors() {
        return Collections.unmodifiableCollection(deviceDescriptors.values());
    }

    public static DeviceDescriptor getDeviceDescriptor(String name) {
        return deviceDescriptors.get(name);
    }

    public static Collection<Device> getDevices() {
        return Collections.unmodifiableCollection(devices.values());
    }

    public static Device getDevice(int deviceNum) {
        return devices.get(deviceNum);
    }

    public static Device getDevice(DeviceDescriptor desc) {
        for (Device device : devices.values()) {
            DeviceDescriptor ddesc = device.getDescriptor();
            if (ddesc == null || !ddesc.equals(desc)) continue;
            return device;
        }
        return null;
    }

    public static Collection<Device> getDevices(DeviceDescriptor desc) {
        HashSet<Device> deviceSet = new HashSet<Device>();
        for (Device device : devices.values()) {
            DeviceDescriptor ddesc = device.getDescriptor();
            if (ddesc == null || !ddesc.equals(desc)) continue;
            deviceSet.add(device);
        }
        return deviceSet;
    }
}

