/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.Stack;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ErrorHandler;
import org.eclipse.birt.report.model.util.ParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLParserHandler
extends DefaultHandler {
    protected Locator locator = null;
    protected Stack<AbstractParseState> stateStack = new Stack();
    protected ErrorHandler errorHandler;
    protected AbstractParseState topState;

    public XMLParserHandler(ErrorHandler errorHandler) {
        assert (errorHandler != null);
        this.errorHandler = errorHandler;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        assert (this.stateStack.isEmpty());
        this.pushState(this.createStartState());
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        assert (this.stateStack.size() == 1);
        this.topState.end();
        this.popState();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    protected void pushState(AbstractParseState state) {
        assert (state != null);
        state.context = this.errorHandler.getCurrentElement();
        this.stateStack.push(state);
        this.topState = state;
    }

    private AbstractParseState popState() {
        assert (!this.stateStack.isEmpty());
        AbstractParseState state = this.stateStack.pop();
        if (this.stateStack.size() > 0) {
            this.topState = (AbstractParseState)this.stateStack.lastElement();
        }
        return state;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.errorHandler.setCurrentElement(qName);
        AbstractParseState newState = this.topState.startElement(qName);
        newState.elementName = qName;
        this.pushState(newState);
        newState.parseAttrs(atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        AbstractParseState state = this.topState;
        state.end();
        this.popState();
        if (!this.stateStack.isEmpty()) {
            this.topState.endElement(state);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.stateStack.isEmpty()) {
            this.topState.text.append(ch, start, length);
        }
    }

    public abstract AbstractParseState createStartState();

    public void setDocumentLocator(Locator theLocator) {
        super.setDocumentLocator(theLocator);
        this.locator = theLocator;
        this.errorHandler.setDocumentLocator(theLocator);
    }

    public void error(SAXParseException e) throws SAXException {
        this.errorHandler.semanticError(new XMLParserException(e));
    }

    public void warning(SAXParseException e) throws SAXException {
        this.errorHandler.semanticError(new XMLParserException(e));
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.errorHandler.semanticError(new XMLParserException(e));
    }

    public final Locator getLocator() {
        return this.locator;
    }

    public final int getCurrentLineNo() {
        return this.locator.getLineNumber();
    }

    public class InnerAnyTagState
    extends InnerParseState {
        public AbstractParseState startElement(String tagName) {
            return new InnerAnyTagState();
        }
    }

    public class InnerParseState
    extends ParseState {
        public InnerParseState() {
            super(XMLParserHandler.this);
        }
    }
}

