/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.SlotState;
import org.eclipse.birt.report.model.parser.StyleState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesState
extends SlotState {
    private static final String STYLE_NAME_FORBIDDEN_PATTERN = "[\\x00-\\x1D]|[\\x1F-\\x2F]|[\\x3A-\\x40]|[\\x5B-\\x60]|[\\x7B-\\xC7]";
    private static final String STYLE_NAME_START = "([a-z]|[^\u0000-\u007f]|((\\[0-9a-f]{1,6}[ \n\r\t\f]?)|\\[ -~\u0080-!77777]))";
    public static final Pattern styleNameStartPattern = Pattern.compile("([a-z]|[^\u0000-\u007f]|((\\[0-9a-f]{1,6}[ \n\r\t\f]?)|\\[ -~\u0080-!77777]))", 2);
    private static final String MIDDLE_LINE = "-";
    private static final String REPLACE_LETTER = "s";

    public StylesState(ModuleParserHandler handler, DesignElement container, int slot) {
        super(handler, container, slot);
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.STYLE_TAG == tagValue) {
            return new StyleState(this.handler, this.container, this.slotID);
        }
        return super.startElement(tagName);
    }

    @Override
    public void end() throws SAXException {
        if (this.handler.versionNumber < 3021900) {
            List<DesignElement> styles = this.container.getSlot(this.slotID).getContents();
            this.checkStyleName(styles);
        }
        super.end();
    }

    private void checkStyleName(List<DesignElement> styles) {
        if (styles != null && !styles.isEmpty()) {
            Map<String, DesignElement> styleMap = this.buildNameMap(styles);
            int i = 0;
            while (i < styles.size()) {
                String styleName;
                String lowerCaseName;
                DesignElement style = styles.get(i);
                String oldName = style.getName();
                NameSpace ns = null;
                if (style.getContainer() instanceof ReportDesign) {
                    NameExecutor executor = new NameExecutor((ReportDesign)style.getContainer(), style);
                    ns = executor.getNameSpace();
                }
                if (styleMap.containsKey(lowerCaseName = (styleName = style.getName()).toLowerCase()) && styleMap.get(lowerCaseName) != style) {
                    HashMap<String, String> nameMaps;
                    String baseName = styleName;
                    String name = styleName;
                    int index = 0;
                    while (styleMap.containsKey(lowerCaseName) && styleMap.get(lowerCaseName) != style) {
                        name = String.valueOf(baseName) + ++index;
                        lowerCaseName = name.toLowerCase();
                    }
                    style.setName(name);
                    if (ns != null && !ns.contains(name.toLowerCase())) {
                        ns.insert(style);
                    }
                    if (!styleMap.containsKey(name.toLowerCase())) {
                        styleMap.put(name.toLowerCase(), style);
                    }
                    if (styleMap.get(styleName.toLowerCase()) == style) {
                        styleMap.remove(styleName.toLowerCase());
                    }
                    if ((nameMaps = (HashMap<String, String>)this.handler.tempValue.get(this.container)) == null) {
                        nameMaps = new HashMap<String, String>();
                        this.handler.tempValue.put(this.container, nameMaps);
                    }
                    nameMaps.put(oldName, name);
                } else if (ns != null && !ns.contains(lowerCaseName)) {
                    ns.insert(style);
                }
                ++i;
            }
        }
    }

    private Map<String, DesignElement> buildNameMap(List<DesignElement> styles) {
        HashMap<String, DesignElement> styleMap = new HashMap<String, DesignElement>();
        int i = 0;
        while (i < styles.size()) {
            DesignElement style = styles.get(i);
            String styleName = style.getName();
            String lowerName = styleName.toLowerCase();
            if (!styleMap.containsKey(lowerName)) {
                styleMap.put(lowerName, style);
            }
            ++i;
        }
        return styleMap;
    }
}

