/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.DataColumnNameValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportItemState;
import org.eclipse.birt.report.model.util.LevelContentIterator;
import org.xml.sax.SAXException;

public abstract class ListingItemState
extends ReportItemState {
    private static final Integer PAGE_BREAK_INTERVAL_DEFAULT_VALUE = 50;
    protected ListingElement element;

    public ListingItemState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public ListingItemState(ModuleParserHandler handler, DesignElement theContainer, String prop) {
        super(handler, theContainer, prop);
    }

    public DesignElement getElement() {
        return this.element;
    }

    public void end() throws SAXException {
        this.makeTestExpressionCompatible();
        this.checkListingGroup();
        Set<Object> elements = this.handler.tempValue.keySet();
        ContainerSlot groups = this.element.getSlot(1);
        int i = 0;
        while (i < groups.getCount()) {
            List columns;
            GroupElement group = (GroupElement)groups.getContent(i);
            String groupName = (String)group.getLocalProperty(this.handler.module, "groupName");
            if (StringUtil.isBlank(groupName)) {
                this.handler.getModule().makeUniqueName(group);
            }
            groupName = (String)group.getLocalProperty(this.handler.getModule(), "groupName");
            if (elements.contains(group) && this.handler.versionNumber < 3020200 && (columns = (List)this.handler.tempValue.get(group)) != null && !columns.isEmpty()) {
                ArrayList tmpList = (ArrayList)this.element.getLocalProperty(this.handler.module, "boundDataColumns");
                ElementPropertyDefn boundPropDefn = this.element.getPropertyDefn("boundDataColumns");
                if (tmpList == null) {
                    tmpList = new ArrayList();
                    this.element.setProperty(boundPropDefn, tmpList);
                }
                StructureContext context = new StructureContext(this.element, boundPropDefn, null);
                if (this.handler.versionNumber <= 3000000) {
                    this.addCachedListWithAggregateOnToListing(columns, context, tmpList, group, groupName);
                } else {
                    this.addCachedListToListing(columns, context, tmpList, group, groupName);
                }
            }
            ++i;
        }
        if (this.handler.versionNumber < 3021600) {
            ElementPropertyDefn prop = this.element.getPropertyDefn("pageBreakInterval");
            Object value = this.element.getStrategy().getPropertyExceptRomDefault(this.handler.getModule(), this.element, prop);
            if (value == null) {
                this.element.setProperty("pageBreakInterval", (Object)PAGE_BREAK_INTERVAL_DEFAULT_VALUE);
            }
        }
        super.end();
    }

    private ComputedColumn checkMatchedBoundColumnForGroup(List columns, String expression, String aggregateOn, boolean mustMatchAggregateOn) {
        if (columns == null || columns.size() == 0 || expression == null) {
            return null;
        }
        int i = 0;
        while (i < columns.size()) {
            ComputedColumn column = (ComputedColumn)columns.get(i);
            if (expression.equals(column.getExpression())) {
                String tmpAggregateOn = column.getAggregateOn();
                if (mustMatchAggregateOn) {
                    if (aggregateOn == null && tmpAggregateOn == null) {
                        return column;
                    }
                    if (aggregateOn != null && aggregateOn.equals(tmpAggregateOn)) {
                        return column;
                    }
                } else if (tmpAggregateOn == null || tmpAggregateOn.equals(aggregateOn)) {
                    return column;
                }
            }
            ++i;
        }
        return null;
    }

    private String getUniqueBoundColumnNameForGroup(List columns, ComputedColumn checkColumn) {
        ComputedColumn column;
        String oldName;
        String tmpName = oldName = checkColumn.getName();
        int index = 0;
        while ((column = DataColumnNameValidator.getColumn(columns, tmpName)) != null) {
            tmpName = String.valueOf(oldName) + "_" + ++index;
        }
        return tmpName;
    }

    private void reCheckResultSetColumnName(GroupElement group, List columns) {
        int level = -1;
        if (group instanceof TableGroup) {
            level = 3;
        }
        if (group instanceof ListGroup) {
            level = 1;
        }
        LevelContentIterator contentIter = new LevelContentIterator(this.handler.module, group, level);
        while (contentIter.hasNext()) {
            ComputedColumn foundColumn;
            String resultSetColumn;
            DesignElement item = contentIter.next();
            if (!(item instanceof DataItem) || StringUtil.isBlank(resultSetColumn = (String)item.getLocalProperty(this.handler.module, "resultSetColumn")) || (foundColumn = DataColumnNameValidator.getColumn(columns, resultSetColumn)) == null || (foundColumn = this.checkMatchedBoundColumnForGroup(columns, foundColumn.getExpression(), (String)group.getLocalProperty(this.handler.module, "groupName"), ExpressionUtil.hasAggregation((String)foundColumn.getExpression()))) == null) continue;
            item.setProperty("resultSetColumn", (Object)foundColumn.getName());
        }
    }

    public void addCachedListWithAggregateOnToListing(List columns, StructureContext context, List tmpList, GroupElement group, String groupName) {
        int j = 0;
        while (j < columns.size()) {
            ComputedColumn foundColumn;
            ComputedColumn column = (ComputedColumn)columns.get(j);
            if (ExpressionUtil.hasAggregation((String)column.getExpression())) {
                column.setAggregateOn(groupName);
            }
            if ((foundColumn = this.checkMatchedBoundColumnForGroup(tmpList, column.getExpression(), column.getAggregateOn(), true)) == null || !foundColumn.getName().equals(column.getName())) {
                String newName = this.getUniqueBoundColumnNameForGroup(tmpList, column);
                column.setName(newName);
                context.add(column);
            }
            ++j;
        }
        this.reCheckResultSetColumnName(group, tmpList);
    }

    public void addCachedListToListing(List columns, StructureContext context, List tmpList, GroupElement group, String groupName) {
        int j = 0;
        while (j < columns.size()) {
            ComputedColumn column = (ComputedColumn)columns.get(j);
            if (!tmpList.contains(column)) {
                if (ExpressionUtil.hasAggregation((String)column.getExpression())) {
                    column.setAggregateOn(groupName);
                }
                context.add(column);
            }
            ++j;
        }
    }

    private void checkListingGroup() {
        if (this.handler.versionNumber < 3021400) {
            return;
        }
        ElementRefValue refValue = (ElementRefValue)this.element.getLocalProperty(this.handler.module, "dataBindingRef");
        if (refValue == null) {
            return;
        }
        if (this.element.getContainerInfo().isManagedByNameSpace()) {
            this.handler.addUnresolveListingElement(this.element);
        }
    }
}

