/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.model.api.extension.IMessages;
import org.eclipse.birt.report.model.api.metadata.ILocalizableInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.i18n.ThreadResources;

public abstract class LocalizableInfo
implements ILocalizableInfo {
    protected IMessages messages;
    protected String name;
    protected String displayNameKey;
    protected String toolTipKey;

    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    public void setDisplayNameKey(String displayNameKey) {
        this.displayNameKey = displayNameKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getToolTipKey() {
        return this.toolTipKey;
    }

    public void setToolTipKey(String toolTipKey) {
        this.toolTipKey = toolTipKey;
    }

    public String getDisplayName() {
        if (this.displayNameKey != null) {
            String displayName = null;
            if (this.messages == null) {
                displayName = ModelMessages.getMessage(this.displayNameKey);
            } else {
                ULocale locale = ThreadResources.getLocale();
                displayName = this.messages.getMessage(this.displayNameKey, locale);
            }
            if (displayName != null) {
                return displayName;
            }
        }
        return this.name;
    }

    public String getToolTip() {
        if (this.toolTipKey != null) {
            if (this.messages == null) {
                return ModelMessages.getMessage(this.toolTipKey);
            }
            ULocale locale = ThreadResources.getLocale();
            return this.messages.getMessage(this.toolTipKey, locale);
        }
        return "";
    }

    public String toString() {
        if (!StringUtil.isBlank(this.getName())) {
            return this.getName();
        }
        return super.toString();
    }

    public void setMessages(IMessages messages) {
        this.messages = messages;
    }

    public IMessages getMessages() {
        return this.messages;
    }
}

