/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public class ElementRefPropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(ElementRefPropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.elementRef";

    public ElementRefPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 15;
    }

    public String getName() {
        return "elementRef";
    }

    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        ElementDefn targetDefn = (ElementDefn)defn.getTargetElementType();
        if (value instanceof String) {
            return this.validateStringValue(module, element, targetDefn, defn, (String)value);
        }
        if (value instanceof DesignElement) {
            DesignElement target = (DesignElement)value;
            return this.validateElementValue(module, element, targetDefn, defn, target);
        }
        logger.log(Level.SEVERE, "Invalid value type: " + value);
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 15);
    }

    private ElementRefValue validateStringValue(Module module, DesignElement element, ElementDefn targetDefn, PropertyDefn propDefn, String name) throws PropertyValueException {
        if ((name = StringUtil.trimString(name)) == null) {
            return null;
        }
        ElementRefValue refValue = module.getNameHelper().resolve(element, name, propDefn, (IElementDefn)targetDefn);
        assert (refValue != null);
        if (!refValue.isResolved()) {
            return refValue;
        }
        DesignElement target = refValue.getElement();
        assert (target != null);
        if (!target.getDefn().isKindOf(targetDefn)) {
            throw new PropertyValueException((Object)target.getFullName(), "Error.PropertyValueException.WRONG_ELEMENT_TYPE", 15);
        }
        return refValue;
    }

    private ElementRefValue validateElementValue(Module module, DesignElement element, ElementDefn targetDefn, PropertyDefn propDefn, DesignElement target) throws PropertyValueException {
        if (StringUtil.isBlank(target.getName())) {
            throw new PropertyValueException((Object)target.getIdentifier(), "Error.PropertyValueException.INVALID_VALUE", 15);
        }
        ElementRefValue refValue = module.getNameHelper().resolve(element, target, propDefn, null);
        if (!target.getDefn().isKindOf(targetDefn)) {
            throw new PropertyValueException((Object)target.getFullName(), "Error.PropertyValueException.WRONG_ELEMENT_TYPE", 15);
        }
        return refValue;
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        ElementRefValue refValue = (ElementRefValue)value;
        if (!"style".equals(defn.getName())) {
            return ReferenceValueUtil.needTheNamespacePrefix((ReferenceValue)value, module);
        }
        return refValue.getName();
    }

    public void resolve(Module module, DesignElement element, PropertyDefn defn, ElementRefValue ref) {
        if (ref.isResolved()) {
            return;
        }
        String name = ReferenceValueUtil.needTheNamespacePrefix(ref, module);
        DesignElement target = null;
        target = module.resolveElement(element, name, defn, null);
        if (target != null) {
            ref.resolve(target);
        }
    }
}

