/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.util;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.model.CudaApplicationState;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaException;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.state.SourceLocation;
import com.nvidia.cuda.ide.debug.ui.IDebugLabelProvider;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public final class RIRequestMonitor
extends ViewerDataRequestMonitor<CudaRuntimeInformation> {
    private static final String[] ASYNC_PROPS = new String[]{"cuda_object_active", "cuda_state_label_long", "cuda_state_label", "warp_id", "lane_id", "sm_id", "device_id", "diverged", "is_active_i", "source_file", "source_line", "active_warps", "pc_formatted", "active_lane", "divergent_lanes", "block_id", "kernel_id", "thread_id"};
    private final IPropertiesUpdate update;
    private final ISourceLookup lookup;
    private final ICudaRuntimeObject object;

    public RIRequestMonitor(Executor executor, ICudaRuntimeObject object, IPropertiesUpdate update, ISourceLookup lookup) {
        super(executor, (IViewerUpdate)update);
        this.object = object;
        this.update = update;
        this.lookup = lookup;
    }

    protected void handleSuccess() {
        SourceLocation sourceLocation;
        CudaRuntimeInformation info;
        CudaRuntimeInformation data = info = (CudaRuntimeInformation)this.getData();
        this.setProperty("device_id", data.getDeviceId());
        this.setProperty("sm_id", data.getSm());
        this.setProperty("warp_id", data.getWarpId());
        this.setProperty("lane_id", data.getLane());
        IDebugLabelProvider formatter = Activator.getDefault().getFormatter();
        CudaThreadState state = info.getState();
        this.setProperty("cuda_state_label", formatter.format(state));
        this.setProperty("cuda_state_label_long", formatter.formatLong(state));
        this.setProperty("cuda_object_active", state.isActive());
        this.setProperty("is_active_i", state.isActive() ? 1 : 0);
        this.setProperty("diverged", CudaThreadState.DIVERGENT.equals((Object)state));
        this.setProperty("active_warps", info.getActiveWarps());
        this.setProperty("active_lane", info.getActiveLanes());
        this.setProperty("divergent_lanes", info.getDivergentLanes());
        this.setProperty("block_id", info.getBlockIdx());
        this.setProperty("thread_id", info.getThreadIdx());
        Long kernelId = info.getKernelId();
        this.setProperty("kernel_id", kernelId);
        if (this.update.getProperties().contains("cuda_object_pinned")) {
            DeviceThread thread = this.getDeviceThread(info);
            boolean pinned = thread != null && DebugUtil.isPinned(thread);
            this.setProperty("cuda_object_pinned", pinned);
        }
        if ((sourceLocation = ((CudaRuntimeInformation)this.getData()).getSourceLocation()) != null) {
            this.setProperty("source_line", sourceLocation.lineno);
            this.setProperty("pc_formatted", "0x" + Long.toHexString(sourceLocation.virtualPC));
            this.setProperty("phys_pc_formatted", "0x" + Long.toHexString(sourceLocation.devicePC));
            if (this.lookup != null) {
                this.performSourceLookup(sourceLocation);
                return;
            }
            this.update.setProperty("has_source", (Object)2);
            this.setProperty("source_file", new Path(sourceLocation.filename).lastSegment());
            this.update.done();
        } else {
            this.update.setProperty("has_source", (Object)0);
            this.update.done();
        }
    }

    private DeviceThread getDeviceThread(CudaRuntimeInformation info) {
        if (this.object instanceof DeviceThread) {
            return (DeviceThread)this.object;
        }
        if (this.object instanceof Lane) {
            CudaCoord threadIdx = info.getThreadIdx();
            CudaCoord blockIdx = info.getBlockIdx();
            long kId = info.getKernelId();
            if (threadIdx != null && blockIdx != null) {
                CudaApplicationState applicationState = (CudaApplicationState)DMContexts.getAncestorOfType((IDMContext)this.object, CudaApplicationState.class);
                Kernel kernel = applicationState.getKernel(kId);
                try {
                    return kernel.getBlock(blockIdx).getThread(threadIdx);
                }
                catch (CudaException e) {
                    Activator.log(e);
                    return null;
                }
            }
            return null;
        }
        return null;
    }

    private void setProperty(String key, Object value) {
        if (this.update.getProperties().contains(key)) {
            this.update.setProperty(key, value);
        }
    }

    private void performSourceLookup(final SourceLocation sourceLocation) {
        IDMContext dmContext = ((IDMVMContext)this.update.getElement()).getDMContext();
        ISourceLookup.ISourceLookupDMContext dmc = (ISourceLookup.ISourceLookupDMContext)DMContexts.getAncestorOfType((IDMContext)dmContext, ISourceLookup.ISourceLookupDMContext.class);
        if (dmc != null) {
            this.lookup.getSource(dmc, sourceLocation.filename, (DataRequestMonitor)new ViewerDataRequestMonitor<Object>((Executor)this.lookup.getExecutor(), (IViewerUpdate)this.update){

                protected void handleSuccess() {
                    RIRequestMonitor.this.setProperty("source_file", new Path(sourceLocation.filename).lastSegment());
                    RIRequestMonitor.this.setProperty("source_resource", this.getData());
                    RIRequestMonitor.this.update.setProperty("has_source", (Object)1);
                    RIRequestMonitor.this.update.done();
                }

                protected void handleFailure() {
                    RIRequestMonitor.this.update.setProperty("has_source", (Object)2);
                    RIRequestMonitor.this.setProperty("source_file", sourceLocation.filename);
                    RIRequestMonitor.this.update.done();
                }
            });
        } else {
            this.update.done();
        }
    }

    public static void fill(IPropertiesUpdate update, Executor executor, ICudaRuntimeObject object) {
        RIRequestMonitor.fill(update, executor, object, null);
    }

    public static void fill(final IPropertiesUpdate update, final Executor executor, final ICudaRuntimeObject object, final ISourceLookup lookup) {
        if (RIRequestMonitor.needsAsyncQuery(update)) {
            executor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    object.getState((DataRequestMonitor<CudaRuntimeInformation>)new RIRequestMonitor(executor, object, update, lookup));
                }
            });
        } else {
            update.done();
        }
    }

    private static boolean needsAsyncQuery(IPropertiesUpdate update) {
        Set properties = update.getProperties();
        return new ArrayList<String>(Arrays.asList(ASYNC_PROPS)).removeAll(properties);
    }
}

