/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.common.util.CoreUtil;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.ui.viewmodel.IColumnsVMContext;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.CudaStackFramesVMNode;
import com.nvidia.cuda.ide.debug.util.DeviceThreadComparator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;

public class MulticolumnCudaStackFramesVMNode
extends CudaStackFramesVMNode
implements IVMNode {
    protected final void filterInactiveThreads(DeviceThread[] data, DataRequestMonitor<IDMContext[]> rm) {
        if (data == null || data.length == 0) {
            rm.setData((Object)new IDMContext[0]);
        } else {
            Executor immediateExecutor = ImmediateExecutor.getInstance();
            final TreeSet<DeviceThread> activeThreads = new TreeSet<DeviceThread>(new DeviceThreadComparator(ICoordSorter.CUDA));
            final CountingRequestMonitor crm = new CountingRequestMonitor(immediateExecutor, (RequestMonitor)rm, (DataRequestMonitor)rm, activeThreads){
                private final /* synthetic */ DataRequestMonitor val$rm;
                private final /* synthetic */ Set val$activeThreads;
                {
                    this.val$rm = dataRequestMonitor;
                    this.val$activeThreads = set;
                    super($anonymous0, $anonymous1);
                }

                protected void handleSuccess() {
                    this.val$rm.setData((Object)this.val$activeThreads.toArray(new IDMContext[this.val$activeThreads.size()]));
                    this.val$rm.done();
                }
            };
            crm.setDoneCount(data.length);
            DeviceThread[] deviceThreadArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                final DeviceThread deviceThread = deviceThreadArray[n2];
                deviceThread.getState(new DataRequestMonitor<CudaRuntimeInformation>(immediateExecutor, (RequestMonitor)crm){

                    protected void handleSuccess() {
                        if (((CudaRuntimeInformation)this.getData()).getState().isActive()) {
                            activeThreads.add(deviceThread);
                        }
                        crm.done();
                    }
                });
                ++n2;
            }
        }
    }

    public MulticolumnCudaStackFramesVMNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session);
    }

    protected IDMVMContext createVMContext(IDMContext dmc) {
        return new MultiColumnDMVMContext(dmc);
    }

    public void getTopFrame(IRunControl.IExecutionDMContext context, final DataRequestMonitor<IDMVMContext> drm) {
        IStack service = (IStack)this.getServicesTracker().getService(IStack.class);
        if (service != null) {
            service.getTopFrame((IDMContext)context, (DataRequestMonitor)new DataRequestMonitor<IStack.IFrameDMContext>(ImmediateExecutor.getInstance(), drm){

                protected void handleSuccess() {
                    IStack.IFrameDMContext data = (IStack.IFrameDMContext)this.getData();
                    if (data != null) {
                        drm.setData((Object)MulticolumnCudaStackFramesVMNode.this.createVMContext((IDMContext)data));
                    }
                    drm.done();
                }
            });
        } else {
            drm.done();
        }
    }

    public class MultiColumnDMVMContext
    extends AbstractDMVMNode.DMVMContext
    implements IColumnsVMContext {
        public MultiColumnDMVMContext(IDMContext dmc) {
            super((AbstractDMVMNode)MulticolumnCudaStackFramesVMNode.this, dmc);
        }

        @Override
        public void getColumnContexts(final DataRequestMonitor<IDMContext[]> rm) {
            IRunControl service = (IRunControl)MulticolumnCudaStackFramesVMNode.this.getServicesTracker().getService(IRunControl.class);
            IDebuggerUIState state = (IDebuggerUIState)MulticolumnCudaStackFramesVMNode.this.getServicesTracker().getService(IDebuggerUIState.class);
            Kernel container = (Kernel)DMContexts.getAncestorOfType((IDMContext)this.getDMContext(), Kernel.class);
            DeviceThread thread = (DeviceThread)DMContexts.getAncestorOfType((IDMContext)this.getDMContext(), DeviceThread.class);
            if (container != null && service != null && state != null && thread != null && service.isSuspended((IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)this.getDMContext(), IRunControl.IExecutionDMContext.class)) && (state.isPinned(thread) || state.isRemembered(thread) || CoreUtil.equals((Object)state.getFocus(), (Object)thread))) {
                state.getThreads(container, 5, (DataRequestMonitor<? super DeviceThread[]>)new DataRequestMonitor<DeviceThread[]>(ImmediateExecutor.getInstance(), rm){

                    protected void handleSuccess() {
                        MulticolumnCudaStackFramesVMNode.this.filterInactiveThreads((DeviceThread[])this.getData(), (DataRequestMonitor<IDMContext[]>)rm);
                    }
                });
            } else {
                rm.done(null);
            }
        }
    }
}

